/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.handler.ssl.SslContext;
import io.vertx.core.VertxException;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.VertxSslContext;
import io.vertx.core.net.impl.VertxTrustManagerFactory;
import io.vertx.core.spi.tls.SslContextFactory;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public class SslContextProvider {
    private final Supplier<SslContextFactory> provider;
    private final Set<String> enabledProtocols;
    private final List<CRL> crls;
    private final ClientAuth clientAuth;
    private final Set<String> enabledCipherSuites;
    private final List<String> applicationProtocols;
    private final String endpointIdentificationAlgorithm;
    private final KeyManagerFactory keyManagerFactory;
    private final TrustManagerFactory trustManagerFactory;
    private final Function<String, X509KeyManager> keyManagerMapper;
    private final Function<String, TrustManager[]> trustManagerMapper;

    public SslContextProvider(ClientAuth clientAuth, String endpointIdentificationAlgorithm, List<String> applicationProtocols, Set<String> enabledCipherSuites, Set<String> enabledProtocols, KeyManagerFactory keyManagerFactory, Function<String, X509KeyManager> keyManagerMapper, TrustManagerFactory trustManagerFactory, Function<String, TrustManager[]> trustManagerMapper, List<CRL> crls, Supplier<SslContextFactory> provider) {
        this.provider = provider;
        this.clientAuth = clientAuth;
        this.endpointIdentificationAlgorithm = endpointIdentificationAlgorithm;
        this.applicationProtocols = applicationProtocols;
        this.enabledCipherSuites = new HashSet<String>(enabledCipherSuites);
        this.enabledProtocols = enabledProtocols;
        this.keyManagerFactory = keyManagerFactory;
        this.trustManagerFactory = trustManagerFactory;
        this.keyManagerMapper = keyManagerMapper;
        this.trustManagerMapper = trustManagerMapper;
        this.crls = crls;
    }

    public VertxSslContext createClientContext(final String serverName, boolean useAlpn, boolean trustAll) {
        try {
            SslContextFactory factory = this.provider.get().useAlpn(useAlpn).forClient(true).enabledCipherSuites(this.enabledCipherSuites).applicationProtocols(this.applicationProtocols);
            if (this.keyManagerFactory != null) {
                factory.keyMananagerFactory(this.keyManagerFactory);
            }
            TrustManager[] trustManagers = null;
            if (trustAll) {
                trustManagers = new TrustManager[]{SslContextProvider.createTrustAllTrustManager()};
            } else if (this.trustManagerFactory != null) {
                trustManagers = this.trustManagerFactory.getTrustManagers();
            }
            if (trustManagers != null) {
                VertxTrustManagerFactory tmf = this.buildVertxTrustManagerFactory(trustManagers);
                factory.trustManagerFactory(tmf);
            }
            SslContext context = factory.create();
            return new VertxSslContext(context){

                protected void initEngine(SSLEngine engine) {
                    SslContextProvider.this.configureEngine(engine, SslContextProvider.this.enabledProtocols, serverName, true);
                }
            };
        }
        catch (Exception e) {
            throw new VertxException(e);
        }
    }

    public VertxSslContext createServerContext(boolean useAlpn) {
        return this.createServerContext(this.keyManagerFactory, this.trustManagerFactory != null ? this.trustManagerFactory.getTrustManagers() : null, null, useAlpn);
    }

    public VertxSslContext createServerContext(KeyManagerFactory keyManagerFactory, TrustManager[] trustManagers, final String serverName, boolean useAlpn) {
        try {
            SslContextFactory factory = this.provider.get().useAlpn(useAlpn).forClient(false).enabledCipherSuites(this.enabledCipherSuites).applicationProtocols(this.applicationProtocols);
            factory.clientAuth(SSLHelper.CLIENT_AUTH_MAPPING.get((Object)this.clientAuth));
            if (serverName != null) {
                factory.serverName(serverName);
            }
            if (keyManagerFactory != null) {
                factory.keyMananagerFactory(keyManagerFactory);
            }
            if (trustManagers != null) {
                VertxTrustManagerFactory tmf = this.buildVertxTrustManagerFactory(trustManagers);
                factory.trustManagerFactory(tmf);
            }
            SslContext context = factory.create();
            return new VertxSslContext(context){

                protected void initEngine(SSLEngine engine) {
                    SslContextProvider.this.configureEngine(engine, SslContextProvider.this.enabledProtocols, serverName, false);
                }
            };
        }
        catch (Exception e) {
            throw new VertxException(e);
        }
    }

    public KeyManagerFactory loadKeyManagerFactory(String serverName) throws Exception {
        X509KeyManager mgr;
        if (this.keyManagerMapper != null && (mgr = this.keyManagerMapper.apply(serverName)) != null) {
            String keyStoreType = KeyStore.getDefaultType();
            KeyStore ks = KeyStore.getInstance(keyStoreType);
            ks.load(null, null);
            ks.setKeyEntry("key", mgr.getPrivateKey(null), new char[0], mgr.getCertificateChain(null));
            String keyAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyAlgorithm);
            kmf.init(ks, new char[0]);
            return kmf;
        }
        return null;
    }

    public KeyManagerFactory resolveKeyManagerFactory(String serverName) throws Exception {
        KeyManagerFactory kmf = this.loadKeyManagerFactory(serverName);
        if (kmf == null) {
            kmf = this.keyManagerFactory;
        }
        return kmf;
    }

    public TrustManager[] loadTrustManagers(String serverName) throws Exception {
        if (this.trustManagerMapper != null) {
            return this.trustManagerMapper.apply(serverName);
        }
        return null;
    }

    public TrustManager[] resolveTrustManagers(String serverName) throws Exception {
        TrustManager[] trustManagers = this.loadTrustManagers(serverName);
        if (trustManagers == null && this.trustManagerFactory != null) {
            trustManagers = this.trustManagerFactory.getTrustManagers();
        }
        return trustManagers;
    }

    private VertxTrustManagerFactory buildVertxTrustManagerFactory(TrustManager[] mgrs) {
        if (this.crls != null && this.crls.size() > 0) {
            mgrs = SslContextProvider.createUntrustRevokedCertTrustManager(mgrs, this.crls);
        }
        return new VertxTrustManagerFactory(mgrs);
    }

    private static TrustManager[] createUntrustRevokedCertTrustManager(TrustManager[] trustMgrs, final List<CRL> crls) {
        trustMgrs = (TrustManager[])trustMgrs.clone();
        for (int i = 0; i < trustMgrs.length; ++i) {
            TrustManager trustMgr = trustMgrs[i];
            if (!(trustMgr instanceof X509TrustManager)) continue;
            final X509TrustManager x509TrustManager = (X509TrustManager)trustMgr;
            trustMgrs[i] = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    this.checkRevoked(x509Certificates);
                    x509TrustManager.checkClientTrusted(x509Certificates, s);
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    this.checkRevoked(x509Certificates);
                    x509TrustManager.checkServerTrusted(x509Certificates, s);
                }

                private void checkRevoked(X509Certificate[] x509Certificates) throws CertificateException {
                    for (X509Certificate cert : x509Certificates) {
                        for (CRL crl : crls) {
                            if (!crl.isRevoked(cert)) continue;
                            throw new CertificateException("Certificate revoked");
                        }
                    }
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return x509TrustManager.getAcceptedIssuers();
                }
            };
        }
        return trustMgrs;
    }

    private static TrustManager createTrustAllTrustManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }

    public void configureEngine(SSLEngine engine, Set<String> enabledProtocols, String serverName, boolean client) {
        SSLParameters sslParameters;
        LinkedHashSet<String> protocols = new LinkedHashSet<String>(enabledProtocols);
        protocols.retainAll(Arrays.asList(engine.getSupportedProtocols()));
        engine.setEnabledProtocols(protocols.toArray(new String[protocols.size()]));
        if (client && !this.endpointIdentificationAlgorithm.isEmpty()) {
            sslParameters = engine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm(this.endpointIdentificationAlgorithm);
            engine.setSSLParameters(sslParameters);
        }
        if (serverName != null) {
            sslParameters = engine.getSSLParameters();
            sslParameters.setServerNames(Collections.singletonList(new SNIHostName(serverName)));
            engine.setSSLParameters(sslParameters);
        }
    }
}

