/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.outbox.quarkus.deployment;

import com.fasterxml.jackson.databind.JsonNode;
import io.debezium.outbox.quarkus.ExportedEvent;
import io.debezium.outbox.quarkus.deployment.DebeziumOutboxConfig;
import io.debezium.outbox.quarkus.deployment.OutboxEventEntityBuildItem;
import io.debezium.outbox.quarkus.deployment.OutboxEventHbmWriter;
import io.debezium.outbox.quarkus.internal.EventDispatcher;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public final class OutboxProcessor {
    private static final Logger LOGGER = Logger.getLogger(OutboxProcessor.class);
    private static final String DEBEZIUM_OUTBOX = "debezium-outbox";
    DebeziumOutboxConfig debeziumOutboxConfig;

    @BuildStep
    public FeatureBuildItem feature() {
        return new FeatureBuildItem(DEBEZIUM_OUTBOX);
    }

    @BuildStep
    public void produceOutboxBuildItem(CombinedIndexBuildItem index, BuildProducer<OutboxEventEntityBuildItem> outboxEventEntityProducer) {
        DotName exportedEvent = DotName.createSimple((String)ExportedEvent.class.getName());
        Type aggregateIdType = Type.create((DotName)DotName.createSimple((String)String.class.getName()), (Type.Kind)Type.Kind.CLASS);
        Type payloadType = Type.create((DotName)DotName.createSimple((String)JsonNode.class.getName()), (Type.Kind)Type.Kind.CLASS);
        boolean parameterizedTypesDetected = false;
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(exportedEvent)) {
            LOGGER.infof("Found ExportedEvent type: %s", (Object)classInfo.name());
            for (Type interfaceType : classInfo.interfaceTypes()) {
                if (!interfaceType.name().equals((Object)exportedEvent)) continue;
                if (interfaceType.kind().equals((Object)Type.Kind.PARAMETERIZED_TYPE)) {
                    ParameterizedType pType = interfaceType.asParameterizedType();
                    if (pType.arguments().size() != 2) {
                        throw new IllegalArgumentException(String.format("Expected 2 parameterized types for class %s using interface ExportedEvent", classInfo.name()));
                    }
                    Type pTypeAggregateType = (Type)pType.arguments().get(0);
                    Type pTypePayloadType = (Type)pType.arguments().get(1);
                    LOGGER.debug((Object)" * Implements ExportedEvent with generic parameters:");
                    LOGGER.debugf("     AggregateId: %s", (Object)pTypeAggregateType.name().toString());
                    LOGGER.debugf("     Payload: %s", (Object)pTypePayloadType.name().toString());
                    if (parameterizedTypesDetected) {
                        if (!pTypeAggregateType.equals((Object)aggregateIdType)) {
                            throw new IllegalStateException(String.format("Class %s implements ExportedEvent and expected aggregate-id parameter type to be %s but was %s. All ExportedEvent implementors must use the same parameter types.", classInfo.name(), aggregateIdType.name(), pTypeAggregateType.name()));
                        }
                        if (pTypePayloadType.equals((Object)payloadType)) continue;
                        throw new IllegalStateException(String.format("Class %s implements ExportedEvent and expected payload parameter type to be %s but was %s. All ExportedEvent implementors must use the same parameter types.", classInfo.name(), payloadType.name(), pTypePayloadType.name()));
                    }
                    aggregateIdType = pTypeAggregateType;
                    payloadType = pTypePayloadType;
                    parameterizedTypesDetected = true;
                    continue;
                }
                LOGGER.debug((Object)" * Implements ExportedEvent without parameters, using:");
                LOGGER.debugf("     AggregateId: %s", (Object)aggregateIdType.name().toString());
                LOGGER.debugf("     Payload: %s", (Object)payloadType.name().toString());
            }
        }
        LOGGER.infof("Binding Aggregate Id as '%s'.", (Object)aggregateIdType.name().toString());
        LOGGER.infof("Binding Payload as '%s'.", (Object)payloadType.name().toString());
        outboxEventEntityProducer.produce((BuildItem)new OutboxEventEntityBuildItem(aggregateIdType, payloadType));
    }

    @BuildStep
    public void build(OutboxEventEntityBuildItem outboxBuildItem, BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer, BuildProducer<GeneratedResourceBuildItem> generatedResourcesProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer) {
        additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(EventDispatcher.class));
        this.generateHbmMapping(outboxBuildItem, generatedResourcesProducer);
    }

    private void generateHbmMapping(OutboxEventEntityBuildItem outboxBuildItem, BuildProducer<GeneratedResourceBuildItem> generatedResourcesProducer) {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            JaxbHbmHibernateMapping jaxbMapping = OutboxEventHbmWriter.write(this.debeziumOutboxConfig, outboxBuildItem);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{JaxbHbmHibernateMapping.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            PrintWriter writer = new PrintWriter(os);
            marshaller.marshal((Object)jaxbMapping, (Writer)writer);
            LOGGER.debugf("Outbox entity HBM mapping:\n%s", (Object)new String(os.toByteArray()));
            generatedResourcesProducer.produce((BuildItem)new GeneratedResourceBuildItem("META-INF/OutboxEvent.hbm.xml", os.toByteArray()));
        }
        catch (IOException | JAXBException e) {
            throw new IllegalStateException("Failed to produce Outbox HBM mapping", e);
        }
    }
}

