/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.outbox.reactive.quarkus.internal;

import io.debezium.outbox.quarkus.ExportedEvent;
import io.debezium.outbox.quarkus.internal.DataMapTracingSetter;
import io.debezium.outbox.reactive.quarkus.DebeziumCustomCodec;
import io.debezium.outbox.reactive.quarkus.internal.AbstractEventDispatcher;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.quarkus.vertx.ConsumeEvent;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DebeziumTracerEventDispatcher
extends AbstractEventDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebeziumTracerEventDispatcher.class);
    private static final String OPERATION_NAME = "outbox-write";
    private static final String TRACING_COMPONENT = "debezium";
    @Inject
    OpenTelemetry openTelemetry;

    @Override
    @ConsumeEvent(value="debezium-outbox", codec=DebeziumCustomCodec.class)
    public Uni<Void> onExportedEvent(Object incomingevent) {
        ExportedEvent event = (ExportedEvent)incomingevent;
        LOGGER.debug("An exported event was found for type {}", (Object)event.getType());
        Tracer tracer = this.openTelemetry.getTracer(TRACING_COMPONENT);
        SpanBuilder spanBuilder = tracer.spanBuilder(OPERATION_NAME);
        DataMapTracingSetter exportedSpanData = DataMapTracingSetter.create();
        Span parentSpan = Span.current();
        if (parentSpan != null) {
            spanBuilder.setParent(Context.current().with((ImplicitContextKeyed)parentSpan));
        }
        spanBuilder.setAttribute("aggregateType", event.getAggregateType()).setAttribute("aggregateId", event.getAggregateId().toString()).setAttribute("type", event.getAggregateType()).setAttribute("timestamp", event.getTimestamp().toString()).setSpanKind(SpanKind.INTERNAL);
        Span activeSpan = spanBuilder.startSpan();
        try {
            Uni<Void> uni;
            block10: {
                Scope outboxSpanScope = activeSpan.makeCurrent();
                try {
                    Map dataMap = this.getDataMapFromEvent(event);
                    TextMapPropagator textMapPropagator = this.openTelemetry.getPropagators().getTextMapPropagator();
                    textMapPropagator.inject(Context.current(), (Object)dataMap, (TextMapSetter)exportedSpanData);
                    uni = this.persist((Map<String, Object>)dataMap);
                    if (outboxSpanScope == null) break block10;
                }
                catch (Throwable throwable) {
                    if (outboxSpanScope != null) {
                        try {
                            outboxSpanScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                outboxSpanScope.close();
            }
            return uni;
        }
        finally {
            activeSpan.end();
        }
    }
}

