/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.outbox.quarkus.internal;

import io.debezium.outbox.quarkus.ExportedEvent;
import io.debezium.outbox.quarkus.internal.DebeziumOutboxRuntimeConfig;
import io.debezium.outbox.quarkus.internal.DebeziumTextMap;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.util.HashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class EventDispatcher {
    private static final String OPERATION_NAME = "outbox-write";
    private static final String TIMESTAMP = "timestamp";
    private static final String PAYLOAD = "payload";
    private static final String TYPE = "type";
    private static final String AGGREGATE_ID = "aggregateId";
    private static final String AGGREGATE_TYPE = "aggregateType";
    public static final String TRACING_SPAN_CONTEXT = "tracingspancontext";
    private static final String TRACING_COMPONENT = "debezium";
    private static final Logger LOGGER = LoggerFactory.getLogger(EventDispatcher.class);
    @Inject
    EntityManager entityManager;
    @Inject
    DebeziumOutboxRuntimeConfig config;
    @Inject
    Tracer tracer;

    public void onExportedEvent(@Observes ExportedEvent<?, ?> event) {
        LOGGER.debug("An exported event was found for type {}", (Object)event.getType());
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(OPERATION_NAME);
        DebeziumTextMap exportedSpanData = new DebeziumTextMap();
        Span parentSpan = this.tracer.activeSpan();
        if (parentSpan != null) {
            spanBuilder.asChildOf(parentSpan);
        }
        spanBuilder.withTag(AGGREGATE_TYPE, event.getAggregateType()).withTag(AGGREGATE_ID, event.getAggregateId().toString()).withTag(TYPE, event.getAggregateType()).withTag(TIMESTAMP, event.getTimestamp().toString());
        try (Scope outboxSpanScope = spanBuilder.startActive(true);){
            Tags.COMPONENT.set(outboxSpanScope.span(), TRACING_COMPONENT);
            this.tracer.inject(outboxSpanScope.span().context(), Format.Builtin.TEXT_MAP, (Object)exportedSpanData);
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put(AGGREGATE_TYPE, event.getAggregateType());
            dataMap.put(AGGREGATE_ID, event.getAggregateId());
            dataMap.put(TYPE, event.getType());
            dataMap.put(PAYLOAD, event.getPayload());
            dataMap.put(TIMESTAMP, event.getTimestamp());
            dataMap.put(TRACING_SPAN_CONTEXT, exportedSpanData.export());
            Session session = (Session)this.entityManager.unwrap(Session.class);
            session.save("io.debezium.outbox.quarkus.internal.OutboxEvent", dataMap);
            session.setReadOnly(dataMap, true);
            if (this.config.removeAfterInsert) {
                session.delete("io.debezium.outbox.quarkus.internal.OutboxEvent", dataMap);
            }
        }
    }
}

