/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.outbox.quarkus.internal;

import io.debezium.outbox.quarkus.ExportedEvent;
import io.debezium.outbox.quarkus.internal.AbstractEventDispatcher;
import io.debezium.outbox.quarkus.internal.DataMapTracingSetter;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DebeziumTracerEventDispatcher
extends AbstractEventDispatcher {
    private static final String OPERATION_NAME = "outbox-write";
    private static final String TRACING_COMPONENT = "debezium";
    private static final Logger LOGGER = LoggerFactory.getLogger(DebeziumTracerEventDispatcher.class);
    @Inject
    OpenTelemetry openTelemetry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onExportedEvent(@Observes ExportedEvent<?, ?> event) {
        LOGGER.debug("An exported event was found for type {}", (Object)event.getType());
        Tracer tracer = this.openTelemetry.getTracer(TRACING_COMPONENT);
        SpanBuilder spanBuilder = tracer.spanBuilder(OPERATION_NAME);
        DataMapTracingSetter exportedSpanData = DataMapTracingSetter.create();
        Span parentSpan = Span.current();
        if (parentSpan != null) {
            spanBuilder.setParent(Context.current().with((ImplicitContextKeyed)parentSpan));
        }
        spanBuilder.setAttribute("aggregateType", event.getAggregateType()).setAttribute("aggregateId", event.getAggregateId().toString()).setAttribute("type", event.getAggregateType()).setAttribute("timestamp", event.getTimestamp().toString()).setSpanKind(SpanKind.INTERNAL);
        Span activeSpan = spanBuilder.startSpan();
        try (Scope outboxSpanScope = activeSpan.makeCurrent();){
            Map dataMap = this.getDataMapFromEvent(event);
            TextMapPropagator textMapPropagator = this.openTelemetry.getPropagators().getTextMapPropagator();
            textMapPropagator.inject(Context.current(), (Object)dataMap, (TextMapSetter)exportedSpanData);
            this.persist(dataMap);
        }
        finally {
            activeSpan.end();
        }
    }
}

