/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import com.google.inject.AbstractModule;
import java.io.BufferedInputStream;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.maven.BuildAbort;
import org.apache.maven.InternalErrorException;
import org.apache.maven.Maven;
import org.apache.maven.building.FileSource;
import org.apache.maven.building.Problem;
import org.apache.maven.building.Source;
import org.apache.maven.cli.CLIManager;
import org.apache.maven.cli.CLIReportingUtils;
import org.apache.maven.cli.CliRequest;
import org.apache.maven.cli.ResolveFile;
import org.apache.maven.cli.configuration.ConfigurationProcessor;
import org.apache.maven.cli.event.DefaultEventSpyContext;
import org.apache.maven.cli.event.ExecutionEventLogger;
import org.apache.maven.cli.internal.BootstrapCoreExtensionManager;
import org.apache.maven.cli.internal.extension.model.CoreExtension;
import org.apache.maven.cli.internal.extension.model.io.xpp3.CoreExtensionsXpp3Reader;
import org.apache.maven.cli.logging.Slf4jConfiguration;
import org.apache.maven.cli.logging.Slf4jConfigurationFactory;
import org.apache.maven.cli.logging.Slf4jLoggerManager;
import org.apache.maven.cli.logging.Slf4jStdoutLogger;
import org.apache.maven.cli.transfer.ConsoleMavenTransferListener;
import org.apache.maven.cli.transfer.QuietMavenTransferListener;
import org.apache.maven.cli.transfer.Slf4jMavenTransferListener;
import org.apache.maven.eventspy.internal.EventSpyDispatcher;
import org.apache.maven.exception.DefaultExceptionHandler;
import org.apache.maven.exception.ExceptionSummary;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.scope.internal.MojoExecutionScopeModule;
import org.apache.maven.extension.internal.CoreExports;
import org.apache.maven.extension.internal.CoreExtensionEntry;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.properties.internal.EnvironmentUtils;
import org.apache.maven.properties.internal.SystemProperties;
import org.apache.maven.session.scope.internal.SessionScopeModule;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.apache.maven.toolchain.building.DefaultToolchainsBuildingRequest;
import org.apache.maven.toolchain.building.ToolchainsBuilder;
import org.apache.maven.toolchain.building.ToolchainsBuildingResult;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.transfer.TransferListener;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecUtil;
import org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;

public class MavenCli {
    public static final String LOCAL_REPO_PROPERTY = "maven.repo.local";
    public static final String MULTIMODULE_PROJECT_DIRECTORY = "maven.multiModuleProjectDirectory";
    public static final String USER_HOME = System.getProperty("user.home");
    public static final File USER_MAVEN_CONFIGURATION_HOME = new File(USER_HOME, ".m2");
    public static final File DEFAULT_USER_TOOLCHAINS_FILE = new File(USER_MAVEN_CONFIGURATION_HOME, "toolchains.xml");
    public static final File DEFAULT_GLOBAL_TOOLCHAINS_FILE = new File(System.getProperty("maven.conf"), "toolchains.xml");
    private static final String EXT_CLASS_PATH = "maven.ext.class.path";
    private static final String EXTENSIONS_FILENAME = ".mvn/extensions.xml";
    private static final String MVN_MAVEN_CONFIG = ".mvn/maven.config";
    public static final String STYLE_COLOR_PROPERTY = "style.color";
    private ClassWorld classWorld;
    private LoggerManager plexusLoggerManager;
    private ILoggerFactory slf4jLoggerFactory;
    private Logger slf4jLogger;
    private EventSpyDispatcher eventSpyDispatcher;
    private ModelProcessor modelProcessor;
    private Maven maven;
    private MavenExecutionRequestPopulator executionRequestPopulator;
    private ToolchainsBuilder toolchainsBuilder;
    private DefaultSecDispatcher dispatcher;
    private Map<String, ConfigurationProcessor> configurationProcessors;
    private static final Pattern LAST_ANSI_SEQUENCE = Pattern.compile("(\u001b\\[[;\\d]*[ -/]*[@-~])[^\u001b]*$");
    private static final String ANSI_RESET = "\u001b[m";

    public MavenCli() {
        this(null);
    }

    public MavenCli(ClassWorld classWorld) {
        this.classWorld = classWorld;
    }

    public static void main(String[] args) {
        int result = MavenCli.main(args, null);
        System.exit(result);
    }

    public static int main(String[] args, ClassWorld classWorld) {
        MavenCli cli = new MavenCli();
        MessageUtils.systemInstall();
        MessageUtils.registerShutdownHook();
        int result = cli.doMain(new CliRequest(args, classWorld));
        MessageUtils.systemUninstall();
        return result;
    }

    public static int doMain(String[] args, ClassWorld classWorld) {
        MavenCli cli = new MavenCli();
        return cli.doMain(new CliRequest(args, classWorld));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doMain(String[] args, String workingDirectory, PrintStream stdout, PrintStream stderr) {
        Set realms;
        PrintStream oldout = System.out;
        PrintStream olderr = System.err;
        if (this.classWorld != null) {
            realms = new HashSet();
            for (ClassRealm realm : this.classWorld.getRealms()) {
                realms.add(realm.getId());
            }
        } else {
            realms = Collections.emptySet();
        }
        try {
            if (stdout != null) {
                System.setOut(stdout);
            }
            if (stderr != null) {
                System.setErr(stderr);
            }
            CliRequest cliRequest = new CliRequest(args, this.classWorld);
            cliRequest.workingDirectory = workingDirectory;
            int n = this.doMain(cliRequest);
            return n;
        }
        finally {
            if (this.classWorld != null) {
                for (ClassRealm realm : new ArrayList<ClassRealm>(this.classWorld.getRealms())) {
                    String realmId = realm.getId();
                    if (realms.contains(realmId)) continue;
                    try {
                        this.classWorld.disposeRealm(realmId);
                    }
                    catch (NoSuchRealmException noSuchRealmException) {}
                }
            }
            System.setOut(oldout);
            System.setErr(olderr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doMain(CliRequest cliRequest) {
        PlexusContainer localContainer = null;
        try {
            this.initialize(cliRequest);
            this.cli(cliRequest);
            this.properties(cliRequest);
            this.logging(cliRequest);
            this.version(cliRequest);
            localContainer = this.container(cliRequest);
            this.commands(cliRequest);
            this.configure(cliRequest);
            this.toolchains(cliRequest);
            this.populateRequest(cliRequest);
            this.encryption(cliRequest);
            this.repository(cliRequest);
            int n = this.execute(cliRequest);
            return n;
        }
        catch (ExitException e) {
            int n = e.exitCode;
            return n;
        }
        catch (UnrecognizedOptionException e) {
            int n = 1;
            return n;
        }
        catch (BuildAbort e) {
            CLIReportingUtils.showError(this.slf4jLogger, "ABORTED", e, cliRequest.showErrors);
            int n = 2;
            return n;
        }
        catch (Exception e) {
            CLIReportingUtils.showError(this.slf4jLogger, "Error executing Maven.", e, cliRequest.showErrors);
            int n = 1;
            return n;
        }
        finally {
            if (localContainer != null) {
                localContainer.dispose();
            }
        }
    }

    void initialize(CliRequest cliRequest) throws ExitException {
        String mavenHome;
        if (cliRequest.workingDirectory == null) {
            cliRequest.workingDirectory = System.getProperty("user.dir");
        }
        if (cliRequest.multiModuleProjectDirectory == null) {
            String basedirProperty = System.getProperty(MULTIMODULE_PROJECT_DIRECTORY);
            if (basedirProperty == null) {
                System.err.format("-D%s system property is not set.", MULTIMODULE_PROJECT_DIRECTORY);
                throw new ExitException(1);
            }
            File basedir = basedirProperty != null ? new File(basedirProperty) : new File("");
            try {
                cliRequest.multiModuleProjectDirectory = basedir.getCanonicalFile();
            }
            catch (IOException e) {
                cliRequest.multiModuleProjectDirectory = basedir.getAbsoluteFile();
            }
        }
        if ((mavenHome = System.getProperty("maven.home")) != null) {
            System.setProperty("maven.home", new File(mavenHome).getAbsolutePath());
        }
    }

    void cli(CliRequest cliRequest) throws Exception {
        this.slf4jLogger = new Slf4jStdoutLogger();
        CLIManager cliManager = new CLIManager();
        ArrayList<String> args = new ArrayList<String>();
        CommandLine mavenConfig = null;
        try {
            File configFile = new File(cliRequest.multiModuleProjectDirectory, MVN_MAVEN_CONFIG);
            if (configFile.isFile()) {
                for (String arg : new String(Files.readAllBytes(configFile.toPath())).split("\\s+")) {
                    if (arg.isEmpty()) continue;
                    args.add(arg);
                }
                mavenConfig = cliManager.parse(args.toArray(new String[0]));
                List<String> unrecongized = mavenConfig.getArgList();
                if (!unrecongized.isEmpty()) {
                    throw new ParseException("Unrecognized maven.config entries: " + unrecongized);
                }
            }
        }
        catch (ParseException e) {
            System.err.println("Unable to parse maven.config: " + e.getMessage());
            cliManager.displayHelp(System.out);
            throw e;
        }
        try {
            cliRequest.commandLine = mavenConfig == null ? cliManager.parse(cliRequest.args) : this.cliMerge(cliManager.parse(cliRequest.args), mavenConfig);
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line options: " + e.getMessage());
            cliManager.displayHelp(System.out);
            throw e;
        }
        if (cliRequest.commandLine.hasOption('h')) {
            cliManager.displayHelp(System.out);
            throw new ExitException(0);
        }
        if (cliRequest.commandLine.hasOption('v')) {
            System.out.println(CLIReportingUtils.showVersion());
            throw new ExitException(0);
        }
    }

    private CommandLine cliMerge(CommandLine mavenArgs, CommandLine mavenConfig) {
        CommandLine.Builder commandLineBuilder = new CommandLine.Builder();
        for (String arg : mavenArgs.getArgs()) {
            commandLineBuilder.addArg(arg);
        }
        for (String arg : mavenConfig.getArgs()) {
            commandLineBuilder.addArg(arg);
        }
        ArrayList<Option> setPropertyOptions = new ArrayList<Option>();
        for (Option opt : mavenArgs.getOptions()) {
            if (String.valueOf('D').equals(opt.getOpt())) {
                setPropertyOptions.add(opt);
                continue;
            }
            commandLineBuilder.addOption(opt);
        }
        for (Option opt : mavenConfig.getOptions()) {
            commandLineBuilder.addOption(opt);
        }
        for (Option opt : setPropertyOptions) {
            commandLineBuilder.addOption(opt);
        }
        return commandLineBuilder.build();
    }

    void logging(CliRequest cliRequest) {
        cliRequest.debug = cliRequest.commandLine.hasOption('X');
        cliRequest.quiet = !cliRequest.debug && cliRequest.commandLine.hasOption('q');
        cliRequest.showErrors = cliRequest.debug || cliRequest.commandLine.hasOption('e');
        this.slf4jLoggerFactory = LoggerFactory.getILoggerFactory();
        Slf4jConfiguration slf4jConfiguration = Slf4jConfigurationFactory.getConfiguration(this.slf4jLoggerFactory);
        if (cliRequest.debug) {
            cliRequest.request.setLoggingLevel(0);
            slf4jConfiguration.setRootLoggerLevel(Slf4jConfiguration.Level.DEBUG);
        } else if (cliRequest.quiet) {
            cliRequest.request.setLoggingLevel(3);
            slf4jConfiguration.setRootLoggerLevel(Slf4jConfiguration.Level.ERROR);
        }
        String styleColor = cliRequest.getUserProperties().getProperty(STYLE_COLOR_PROPERTY, "auto");
        if ("always".equals(styleColor)) {
            MessageUtils.setColorEnabled(true);
        } else if ("never".equals(styleColor)) {
            MessageUtils.setColorEnabled(false);
        } else {
            if (!"auto".equals(styleColor)) {
                throw new IllegalArgumentException("Invalid color configuration option [" + styleColor + "]. Supported values are (auto|always|never).");
            }
            if (cliRequest.commandLine.hasOption('B') || cliRequest.commandLine.hasOption("l")) {
                MessageUtils.setColorEnabled(false);
            }
        }
        if (cliRequest.commandLine.hasOption("l")) {
            File logFile = new File(cliRequest.commandLine.getOptionValue("l"));
            logFile = ResolveFile.resolveFile(logFile, cliRequest.workingDirectory);
            try {
                PrintStream ps = new PrintStream(new FileOutputStream(logFile));
                System.setOut(ps);
                System.setErr(ps);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        slf4jConfiguration.activate();
        this.plexusLoggerManager = new Slf4jLoggerManager();
        this.slf4jLogger = this.slf4jLoggerFactory.getLogger(this.getClass().getName());
    }

    private void version(CliRequest cliRequest) {
        if (cliRequest.debug || cliRequest.commandLine.hasOption('V')) {
            System.out.println(CLIReportingUtils.showVersion());
        }
    }

    private void commands(CliRequest cliRequest) {
        if (cliRequest.showErrors) {
            this.slf4jLogger.info("Error stacktraces are turned on.");
        }
        if ("warn".equals(cliRequest.request.getGlobalChecksumPolicy())) {
            this.slf4jLogger.info("Disabling strict checksum verification on all artifact downloads.");
        } else if ("fail".equals(cliRequest.request.getGlobalChecksumPolicy())) {
            this.slf4jLogger.info("Enabling strict checksum verification on all artifact downloads.");
        }
        if (this.slf4jLogger.isDebugEnabled()) {
            this.slf4jLogger.debug("Message scheme: {}", (Object)(MessageUtils.isColorEnabled() ? "color" : "plain"));
            if (MessageUtils.isColorEnabled()) {
                MessageBuilder buff = MessageUtils.buffer();
                buff.a("Message styles: ");
                buff.a(MessageUtils.level().debug("debug")).a(Character.valueOf(' '));
                buff.a(MessageUtils.level().info("info")).a(Character.valueOf(' '));
                buff.a(MessageUtils.level().warning("warning")).a(Character.valueOf(' '));
                buff.a(MessageUtils.level().error("error")).a(Character.valueOf(' '));
                buff.success("success").a(Character.valueOf(' '));
                buff.failure("failure").a(Character.valueOf(' '));
                buff.strong("strong").a(Character.valueOf(' '));
                buff.mojo("mojo").a(Character.valueOf(' '));
                buff.project("project");
                this.slf4jLogger.debug(buff.toString());
            }
        }
    }

    void properties(CliRequest cliRequest) {
        MavenCli.populateProperties(cliRequest.commandLine, cliRequest.systemProperties, cliRequest.userProperties);
    }

    PlexusContainer container(CliRequest cliRequest) throws Exception {
        ClassRealm coreRealm;
        if (cliRequest.classWorld == null) {
            cliRequest.classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
        }
        if ((coreRealm = cliRequest.classWorld.getClassRealm("plexus.core")) == null) {
            coreRealm = cliRequest.classWorld.getRealms().iterator().next();
        }
        List<File> extClassPath = this.parseExtClasspath(cliRequest);
        CoreExtensionEntry coreEntry = CoreExtensionEntry.discoverFrom(coreRealm);
        List<CoreExtensionEntry> extensions = this.loadCoreExtensions(cliRequest, coreRealm, coreEntry.getExportedArtifacts());
        ClassRealm containerRealm = this.setupContainerRealm(cliRequest.classWorld, coreRealm, extClassPath, extensions);
        ContainerConfiguration cc = new DefaultContainerConfiguration().setClassWorld(cliRequest.classWorld).setRealm(containerRealm).setClassPathScanning("index").setAutoWiring(true).setJSR250Lifecycle(true).setName("maven");
        HashSet<String> exportedArtifacts = new HashSet<String>(coreEntry.getExportedArtifacts());
        HashSet<String> exportedPackages = new HashSet<String>(coreEntry.getExportedPackages());
        for (CoreExtensionEntry extension : extensions) {
            exportedArtifacts.addAll(extension.getExportedArtifacts());
            exportedPackages.addAll(extension.getExportedPackages());
        }
        final CoreExports exports = new CoreExports(containerRealm, exportedArtifacts, exportedPackages);
        DefaultPlexusContainer container = new DefaultPlexusContainer(cc, new AbstractModule(){

            @Override
            protected void configure() {
                this.bind(ILoggerFactory.class).toInstance(MavenCli.this.slf4jLoggerFactory);
                this.bind(CoreExports.class).toInstance(exports);
            }
        });
        container.setLookupRealm(null);
        Thread.currentThread().setContextClassLoader(container.getContainerRealm());
        container.setLoggerManager(this.plexusLoggerManager);
        for (CoreExtensionEntry extension : extensions) {
            container.discoverComponents(extension.getClassRealm(), new SessionScopeModule(container), new MojoExecutionScopeModule(container));
        }
        this.customizeContainer(container);
        container.getLoggerManager().setThresholds(cliRequest.request.getLoggingLevel());
        this.eventSpyDispatcher = container.lookup(EventSpyDispatcher.class);
        DefaultEventSpyContext eventSpyContext = new DefaultEventSpyContext();
        Map<String, Object> data = eventSpyContext.getData();
        data.put("plexus", container);
        data.put("workingDirectory", cliRequest.workingDirectory);
        data.put("systemProperties", cliRequest.systemProperties);
        data.put("userProperties", cliRequest.userProperties);
        data.put("versionProperties", CLIReportingUtils.getBuildProperties());
        this.eventSpyDispatcher.init(eventSpyContext);
        this.slf4jLogger = this.slf4jLoggerFactory.getLogger(this.getClass().getName());
        this.maven = container.lookup(Maven.class);
        this.executionRequestPopulator = container.lookup(MavenExecutionRequestPopulator.class);
        this.modelProcessor = this.createModelProcessor(container);
        this.configurationProcessors = container.lookupMap(ConfigurationProcessor.class);
        this.toolchainsBuilder = container.lookup(ToolchainsBuilder.class);
        this.dispatcher = (DefaultSecDispatcher)container.lookup(SecDispatcher.class, "maven");
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CoreExtensionEntry> loadCoreExtensions(CliRequest cliRequest, ClassRealm containerRealm, Set<String> providedArtifacts) {
        if (cliRequest.multiModuleProjectDirectory == null) {
            return Collections.emptyList();
        }
        File extensionsFile = new File(cliRequest.multiModuleProjectDirectory, EXTENSIONS_FILENAME);
        if (!extensionsFile.isFile()) {
            return Collections.emptyList();
        }
        List<CoreExtension> extensions = this.readCoreExtensionsDescriptor(extensionsFile);
        if (extensions.isEmpty()) {
            return Collections.emptyList();
        }
        ContainerConfiguration cc = new DefaultContainerConfiguration().setClassWorld(cliRequest.classWorld).setRealm(containerRealm).setClassPathScanning("index").setAutoWiring(true).setJSR250Lifecycle(true).setName("maven");
        DefaultPlexusContainer container = new DefaultPlexusContainer(cc, new AbstractModule(){

            @Override
            protected void configure() {
                this.bind(ILoggerFactory.class).toInstance(MavenCli.this.slf4jLoggerFactory);
            }
        });
        try {
            container.setLookupRealm(null);
            container.setLoggerManager(this.plexusLoggerManager);
            container.getLoggerManager().setThresholds(cliRequest.request.getLoggingLevel());
            Thread.currentThread().setContextClassLoader(container.getContainerRealm());
            this.executionRequestPopulator = container.lookup(MavenExecutionRequestPopulator.class);
            this.configurationProcessors = container.lookupMap(ConfigurationProcessor.class);
            this.configure(cliRequest);
            MavenExecutionRequest request = DefaultMavenExecutionRequest.copy(cliRequest.request);
            request = this.populateRequest(cliRequest, request);
            request = this.executionRequestPopulator.populateDefaults(request);
            BootstrapCoreExtensionManager resolver = container.lookup(BootstrapCoreExtensionManager.class);
            List<CoreExtensionEntry> list = Collections.unmodifiableList(resolver.loadCoreExtensions(request, providedArtifacts, extensions));
            this.executionRequestPopulator = null;
            container.dispose();
            return list;
        }
        catch (Throwable throwable) {
            try {
                this.executionRequestPopulator = null;
                container.dispose();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                this.slf4jLogger.warn("Failed to read extensions descriptor {}: {}", (Object)extensionsFile, (Object)e.getMessage());
                return Collections.emptyList();
            }
        }
    }

    private List<CoreExtension> readCoreExtensionsDescriptor(File extensionsFile) throws IOException, XmlPullParserException {
        CoreExtensionsXpp3Reader parser = new CoreExtensionsXpp3Reader();
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(extensionsFile));){
            List<CoreExtension> list = parser.read(is).getExtensions();
            return list;
        }
    }

    private ClassRealm setupContainerRealm(ClassWorld classWorld, ClassRealm coreRealm, List<File> extClassPath, List<CoreExtensionEntry> extensions) throws Exception {
        if (!extClassPath.isEmpty() || !extensions.isEmpty()) {
            ClassRealm extRealm = classWorld.newRealm("maven.ext", null);
            extRealm.setParentRealm(coreRealm);
            this.slf4jLogger.debug("Populating class realm {}", (Object)extRealm.getId());
            for (File file : extClassPath) {
                this.slf4jLogger.debug("  Included {}", (Object)file);
                extRealm.addURL(file.toURI().toURL());
            }
            for (CoreExtensionEntry entry : MavenCli.reverse(extensions)) {
                Set<String> exportedPackages = entry.getExportedPackages();
                ClassRealm realm = entry.getClassRealm();
                for (String exportedPackage : exportedPackages) {
                    extRealm.importFrom(realm, exportedPackage);
                }
                if (!exportedPackages.isEmpty()) continue;
                extRealm.importFrom(realm, realm.getId());
            }
            return extRealm;
        }
        return coreRealm;
    }

    private static <T> List<T> reverse(List<T> list) {
        ArrayList<T> copy = new ArrayList<T>(list);
        Collections.reverse(copy);
        return copy;
    }

    private List<File> parseExtClasspath(CliRequest cliRequest) {
        String extClassPath = cliRequest.userProperties.getProperty(EXT_CLASS_PATH);
        if (extClassPath == null) {
            extClassPath = cliRequest.systemProperties.getProperty(EXT_CLASS_PATH);
        }
        ArrayList<File> jars = new ArrayList<File>();
        if (StringUtils.isNotEmpty(extClassPath)) {
            for (String jar : StringUtils.split(extClassPath, File.pathSeparator)) {
                File file = ResolveFile.resolveFile(new File(jar), cliRequest.workingDirectory);
                this.slf4jLogger.debug("  Included {}", (Object)file);
                jars.add(file);
            }
        }
        return jars;
    }

    private void encryption(CliRequest cliRequest) throws Exception {
        if (cliRequest.commandLine.hasOption("emp")) {
            String passwd = cliRequest.commandLine.getOptionValue("emp");
            if (passwd == null) {
                char[] password;
                Console cons = System.console();
                char[] cArray = password = cons == null ? null : cons.readPassword("Master password: ", new Object[0]);
                if (password != null) {
                    passwd = String.copyValueOf(password);
                    Arrays.fill(password, ' ');
                }
            }
            DefaultPlexusCipher cipher = new DefaultPlexusCipher();
            System.out.println(cipher.encryptAndDecorate(passwd, "settings.security"));
            throw new ExitException(0);
        }
        if (cliRequest.commandLine.hasOption("ep")) {
            String configurationFile;
            String passwd = cliRequest.commandLine.getOptionValue("ep");
            if (passwd == null) {
                char[] password;
                Console cons = System.console();
                char[] cArray = password = cons == null ? null : cons.readPassword("Password: ", new Object[0]);
                if (password != null) {
                    passwd = String.copyValueOf(password);
                    Arrays.fill(password, ' ');
                }
            }
            if ((configurationFile = this.dispatcher.getConfigurationFile()).startsWith("~")) {
                configurationFile = System.getProperty("user.home") + configurationFile.substring(1);
            }
            String file = System.getProperty("settings.security", configurationFile);
            String master = null;
            SettingsSecurity sec = SecUtil.read(file, true);
            if (sec != null) {
                master = sec.getMaster();
            }
            if (master == null) {
                throw new IllegalStateException("Master password is not set in the setting security file: " + file);
            }
            DefaultPlexusCipher cipher = new DefaultPlexusCipher();
            String masterPasswd = cipher.decryptDecorated(master, "settings.security");
            System.out.println(cipher.encryptAndDecorate(passwd, masterPasswd));
            throw new ExitException(0);
        }
    }

    private void repository(CliRequest cliRequest) throws Exception {
        if (cliRequest.commandLine.hasOption("llr") || Boolean.getBoolean("maven.legacyLocalRepo")) {
            cliRequest.request.setUseLegacyLocalRepository(true);
        }
    }

    private int execute(CliRequest cliRequest) throws MavenExecutionRequestPopulationException {
        MavenExecutionRequest request = this.executionRequestPopulator.populateDefaults(cliRequest.request);
        this.eventSpyDispatcher.onEvent(request);
        MavenExecutionResult result = this.maven.execute(request);
        this.eventSpyDispatcher.onEvent(result);
        this.eventSpyDispatcher.close();
        if (result.hasExceptions()) {
            DefaultExceptionHandler handler = new DefaultExceptionHandler();
            LinkedHashMap<String, String> references = new LinkedHashMap<String, String>();
            MavenProject project = null;
            for (Throwable throwable : result.getExceptions()) {
                ExceptionSummary summary = handler.handleException(throwable);
                this.logSummary(summary, references, "", cliRequest.showErrors);
                if (project != null || !(throwable instanceof LifecycleExecutionException)) continue;
                project = ((LifecycleExecutionException)throwable).getProject();
            }
            this.slf4jLogger.error("");
            if (!cliRequest.showErrors) {
                this.slf4jLogger.error("To see the full stack trace of the errors, re-run Maven with the {} switch.", (Object)MessageUtils.buffer().strong("-e"));
            }
            if (!this.slf4jLogger.isDebugEnabled()) {
                this.slf4jLogger.error("Re-run Maven using the {} switch to enable full debug logging.", (Object)MessageUtils.buffer().strong("-X"));
            }
            if (!references.isEmpty()) {
                this.slf4jLogger.error("");
                this.slf4jLogger.error("For more information about the errors and possible solutions, please read the following articles:");
                for (Map.Entry entry : references.entrySet()) {
                    this.slf4jLogger.error("{} {}", (Object)MessageUtils.buffer().strong(entry.getValue()), entry.getKey());
                }
            }
            if (project != null && !project.equals(result.getTopologicallySortedProjects().get(0))) {
                this.slf4jLogger.error("");
                this.slf4jLogger.error("After correcting the problems, you can resume the build with the command");
                this.slf4jLogger.error(MessageUtils.buffer().a("  ").strong("mvn <args> -rf " + this.getResumeFrom(result.getTopologicallySortedProjects(), project)).toString());
            }
            if ("FAIL_NEVER".equals(cliRequest.request.getReactorFailureBehavior())) {
                this.slf4jLogger.info("Build failures were ignored.");
                return 0;
            }
            return 1;
        }
        return 0;
    }

    private String getResumeFrom(List<MavenProject> mavenProjects, MavenProject failedProject) {
        for (MavenProject buildProject : mavenProjects) {
            if (!failedProject.getArtifactId().equals(buildProject.getArtifactId()) || failedProject.equals(buildProject)) continue;
            return failedProject.getGroupId() + ":" + failedProject.getArtifactId();
        }
        return ":" + failedProject.getArtifactId();
    }

    private void logSummary(ExceptionSummary summary, Map<String, String> references, String indent, boolean showErrors) {
        String referenceKey = "";
        if (StringUtils.isNotEmpty(summary.getReference()) && (referenceKey = references.get(summary.getReference())) == null) {
            referenceKey = "[Help " + (references.size() + 1) + "]";
            references.put(summary.getReference(), referenceKey);
        }
        String msg = summary.getMessage();
        if (StringUtils.isNotEmpty(referenceKey)) {
            msg = msg.indexOf(10) < 0 ? msg + " -> " + MessageUtils.buffer().strong(referenceKey) : msg + "\n-> " + MessageUtils.buffer().strong(referenceKey);
        }
        String[] lines = msg.split("(\r\n)|(\r)|(\n)");
        String currentColor = "";
        for (int i = 0; i < lines.length; ++i) {
            String line = currentColor + lines[i];
            Matcher matcher = LAST_ANSI_SEQUENCE.matcher(line);
            String nextColor = "";
            if (matcher.find() && ANSI_RESET.equals(nextColor = matcher.group(1))) {
                nextColor = "";
            }
            line = indent + line + ("".equals(nextColor) ? "" : ANSI_RESET);
            if (i == lines.length - 1 && (showErrors || summary.getException() instanceof InternalErrorException)) {
                this.slf4jLogger.error(line, summary.getException());
            } else {
                this.slf4jLogger.error(line);
            }
            currentColor = nextColor;
        }
        indent = indent + "  ";
        for (ExceptionSummary child : summary.getChildren()) {
            this.logSummary(child, references, indent, showErrors);
        }
    }

    private void configure(CliRequest cliRequest) throws Exception {
        cliRequest.request.setEventSpyDispatcher(this.eventSpyDispatcher);
        int userSuppliedConfigurationProcessorCount = this.configurationProcessors.size() - 1;
        if (userSuppliedConfigurationProcessorCount == 0) {
            this.configurationProcessors.get("settings").process(cliRequest);
        } else if (userSuppliedConfigurationProcessorCount == 1) {
            for (Map.Entry<String, ConfigurationProcessor> entry : this.configurationProcessors.entrySet()) {
                String hint = entry.getKey();
                if (hint.equals("settings")) continue;
                ConfigurationProcessor configurationProcessor = entry.getValue();
                configurationProcessor.process(cliRequest);
            }
        } else if (userSuppliedConfigurationProcessorCount > 1) {
            StringBuilder sb = new StringBuilder(String.format("\nThere can only be one user supplied ConfigurationProcessor, there are %s:\n\n", userSuppliedConfigurationProcessorCount));
            for (Map.Entry<String, ConfigurationProcessor> entry : this.configurationProcessors.entrySet()) {
                String hint = entry.getKey();
                if (hint.equals("settings")) continue;
                ConfigurationProcessor configurationProcessor = entry.getValue();
                sb.append(String.format("%s\n", configurationProcessor.getClass().getName()));
            }
            sb.append("\n");
            throw new Exception(sb.toString());
        }
    }

    void toolchains(CliRequest cliRequest) throws Exception {
        File globalToolchainsFile;
        File userToolchainsFile;
        if (cliRequest.commandLine.hasOption('t')) {
            userToolchainsFile = new File(cliRequest.commandLine.getOptionValue('t'));
            if (!(userToolchainsFile = ResolveFile.resolveFile(userToolchainsFile, cliRequest.workingDirectory)).isFile()) {
                throw new FileNotFoundException("The specified user toolchains file does not exist: " + userToolchainsFile);
            }
        } else {
            userToolchainsFile = DEFAULT_USER_TOOLCHAINS_FILE;
        }
        if (cliRequest.commandLine.hasOption("gt")) {
            globalToolchainsFile = new File(cliRequest.commandLine.getOptionValue("gt"));
            if (!(globalToolchainsFile = ResolveFile.resolveFile(globalToolchainsFile, cliRequest.workingDirectory)).isFile()) {
                throw new FileNotFoundException("The specified global toolchains file does not exist: " + globalToolchainsFile);
            }
        } else {
            globalToolchainsFile = DEFAULT_GLOBAL_TOOLCHAINS_FILE;
        }
        cliRequest.request.setGlobalToolchainsFile(globalToolchainsFile);
        cliRequest.request.setUserToolchainsFile(userToolchainsFile);
        DefaultToolchainsBuildingRequest toolchainsRequest = new DefaultToolchainsBuildingRequest();
        if (globalToolchainsFile.isFile()) {
            toolchainsRequest.setGlobalToolchainsSource(new FileSource(globalToolchainsFile));
        }
        if (userToolchainsFile.isFile()) {
            toolchainsRequest.setUserToolchainsSource(new FileSource(userToolchainsFile));
        }
        this.eventSpyDispatcher.onEvent(toolchainsRequest);
        this.slf4jLogger.debug("Reading global toolchains from {}", this.getLocation(toolchainsRequest.getGlobalToolchainsSource(), globalToolchainsFile));
        this.slf4jLogger.debug("Reading user toolchains from {}", this.getLocation(toolchainsRequest.getUserToolchainsSource(), userToolchainsFile));
        ToolchainsBuildingResult toolchainsResult = this.toolchainsBuilder.build(toolchainsRequest);
        this.eventSpyDispatcher.onEvent(toolchainsResult);
        this.executionRequestPopulator.populateFromToolchains(cliRequest.request, toolchainsResult.getEffectiveToolchains());
        if (!toolchainsResult.getProblems().isEmpty() && this.slf4jLogger.isWarnEnabled()) {
            this.slf4jLogger.warn("");
            this.slf4jLogger.warn("Some problems were encountered while building the effective toolchains");
            for (Problem problem : toolchainsResult.getProblems()) {
                this.slf4jLogger.warn("{} @ {}", (Object)problem.getMessage(), (Object)problem.getLocation());
            }
            this.slf4jLogger.warn("");
        }
    }

    private Object getLocation(Source source, File defaultLocation) {
        if (source != null) {
            return source.getLocation();
        }
        return defaultLocation;
    }

    private MavenExecutionRequest populateRequest(CliRequest cliRequest) {
        return this.populateRequest(cliRequest, cliRequest.request);
    }

    private MavenExecutionRequest populateRequest(CliRequest cliRequest, MavenExecutionRequest request) {
        String threadConfiguration;
        File pom;
        String[] profileOptionValues;
        String[] deprecatedOptions;
        CommandLine commandLine = cliRequest.commandLine;
        String workingDirectory = cliRequest.workingDirectory;
        boolean quiet = cliRequest.quiet;
        boolean showErrors = cliRequest.showErrors;
        for (String deprecatedOption : deprecatedOptions = new String[]{"up", "npu", "cpu", "npr"}) {
            if (!commandLine.hasOption(deprecatedOption)) continue;
            this.slf4jLogger.warn("Command line option -{} is deprecated and will be removed in future Maven versions.", (Object)deprecatedOption);
        }
        if (commandLine.hasOption('B')) {
            request.setInteractiveMode(false);
        }
        boolean noSnapshotUpdates = false;
        if (commandLine.hasOption("nsu")) {
            noSnapshotUpdates = true;
        }
        List<String> goals = commandLine.getArgList();
        boolean recursive = true;
        String reactorFailureBehaviour = "FAIL_FAST";
        if (commandLine.hasOption('N')) {
            recursive = false;
        }
        if (commandLine.hasOption("ff")) {
            reactorFailureBehaviour = "FAIL_FAST";
        } else if (commandLine.hasOption("fae")) {
            reactorFailureBehaviour = "FAIL_AT_END";
        } else if (commandLine.hasOption("fn")) {
            reactorFailureBehaviour = "FAIL_NEVER";
        }
        if (commandLine.hasOption('o')) {
            request.setOffline(true);
        }
        boolean updateSnapshots = false;
        if (commandLine.hasOption('U')) {
            updateSnapshots = true;
        }
        String globalChecksumPolicy = null;
        if (commandLine.hasOption('C')) {
            globalChecksumPolicy = "fail";
        } else if (commandLine.hasOption('c')) {
            globalChecksumPolicy = "warn";
        }
        File baseDirectory = new File(workingDirectory, "").getAbsoluteFile();
        ArrayList<String> activeProfiles = new ArrayList<String>();
        ArrayList<String> inactiveProfiles = new ArrayList<String>();
        if (commandLine.hasOption('P') && (profileOptionValues = commandLine.getOptionValues('P')) != null) {
            for (String profileOptionValue : profileOptionValues) {
                StringTokenizer profileTokens = new StringTokenizer(profileOptionValue, ",");
                while (profileTokens.hasMoreTokens()) {
                    String profileAction = profileTokens.nextToken().trim();
                    if (profileAction.startsWith("-") || profileAction.startsWith("!")) {
                        inactiveProfiles.add(profileAction.substring(1));
                        continue;
                    }
                    if (profileAction.startsWith("+")) {
                        activeProfiles.add(profileAction.substring(1));
                        continue;
                    }
                    activeProfiles.add(profileAction);
                }
            }
        }
        TransferListener transferListener = quiet || cliRequest.commandLine.hasOption("ntp") ? new QuietMavenTransferListener() : (request.isInteractiveMode() && !cliRequest.commandLine.hasOption("l") ? this.getConsoleTransferListener(cliRequest.commandLine.hasOption('X')) : this.getBatchTransferListener());
        ExecutionListener executionListener = new ExecutionEventLogger();
        if (this.eventSpyDispatcher != null) {
            executionListener = this.eventSpyDispatcher.chainListener(executionListener);
        }
        String alternatePomFile = null;
        if (commandLine.hasOption('f')) {
            alternatePomFile = commandLine.getOptionValue('f');
        }
        request.setBaseDirectory(baseDirectory).setGoals(goals).setSystemProperties(cliRequest.systemProperties).setUserProperties(cliRequest.userProperties).setReactorFailureBehavior(reactorFailureBehaviour).setRecursive(recursive).setShowErrors(showErrors).addActiveProfiles(activeProfiles).addInactiveProfiles(inactiveProfiles).setExecutionListener(executionListener).setTransferListener(transferListener).setUpdateSnapshots(updateSnapshots).setNoSnapshotUpdates(noSnapshotUpdates).setGlobalChecksumPolicy(globalChecksumPolicy).setMultiModuleProjectDirectory(cliRequest.multiModuleProjectDirectory);
        if (alternatePomFile != null) {
            File pom2 = ResolveFile.resolveFile(new File(alternatePomFile), workingDirectory);
            if (pom2.isDirectory()) {
                pom2 = new File(pom2, "pom.xml");
            }
            request.setPom(pom2);
        } else if (this.modelProcessor != null && (pom = this.modelProcessor.locatePom(baseDirectory)).isFile()) {
            request.setPom(pom);
        }
        if (request.getPom() != null && request.getPom().getParentFile() != null) {
            request.setBaseDirectory(request.getPom().getParentFile());
        }
        if (commandLine.hasOption("rf")) {
            request.setResumeFrom(commandLine.getOptionValue("rf"));
        }
        if (commandLine.hasOption("pl")) {
            String[] projectOptionValues = commandLine.getOptionValues("pl");
            ArrayList<String> inclProjects = new ArrayList<String>();
            ArrayList<String> exclProjects = new ArrayList<String>();
            if (projectOptionValues != null) {
                for (String projectOptionValue : projectOptionValues) {
                    StringTokenizer projectTokens = new StringTokenizer(projectOptionValue, ",");
                    while (projectTokens.hasMoreTokens()) {
                        String projectAction = projectTokens.nextToken().trim();
                        if (projectAction.startsWith("-") || projectAction.startsWith("!")) {
                            exclProjects.add(projectAction.substring(1));
                            continue;
                        }
                        if (projectAction.startsWith("+")) {
                            inclProjects.add(projectAction.substring(1));
                            continue;
                        }
                        inclProjects.add(projectAction);
                    }
                }
            }
            request.setSelectedProjects(inclProjects);
            request.setExcludedProjects(exclProjects);
        }
        if (commandLine.hasOption("am") && !commandLine.hasOption("amd")) {
            request.setMakeBehavior("make-upstream");
        } else if (!commandLine.hasOption("am") && commandLine.hasOption("amd")) {
            request.setMakeBehavior("make-downstream");
        } else if (commandLine.hasOption("am") && commandLine.hasOption("amd")) {
            request.setMakeBehavior("make-both");
        }
        String localRepoProperty = request.getUserProperties().getProperty(LOCAL_REPO_PROPERTY);
        if (localRepoProperty == null) {
            localRepoProperty = request.getSystemProperties().getProperty(LOCAL_REPO_PROPERTY);
        }
        if (localRepoProperty != null) {
            request.setLocalRepositoryPath(localRepoProperty);
        }
        request.setCacheNotFound(true);
        request.setCacheTransferError(false);
        String string = threadConfiguration = commandLine.hasOption("T") ? commandLine.getOptionValue("T") : null;
        if (threadConfiguration != null) {
            request.setBuilderId("multithreaded");
            if (threadConfiguration.contains("C")) {
                request.setDegreeOfConcurrency(this.calculateDegreeOfConcurrencyWithCoreMultiplier(threadConfiguration));
            } else {
                request.setDegreeOfConcurrency(Integer.valueOf(threadConfiguration));
            }
        }
        if (commandLine.hasOption("b")) {
            request.setBuilderId(commandLine.getOptionValue("b"));
        }
        return request;
    }

    int calculateDegreeOfConcurrencyWithCoreMultiplier(String threadConfiguration) {
        int procs = Runtime.getRuntime().availableProcessors();
        return (int)(Float.valueOf(threadConfiguration.replace("C", "")).floatValue() * (float)procs);
    }

    static void populateProperties(CommandLine commandLine, Properties systemProperties, Properties userProperties) {
        String[] defStrs;
        EnvironmentUtils.addEnvVars(systemProperties);
        if (commandLine.hasOption('D') && (defStrs = commandLine.getOptionValues('D')) != null) {
            for (String defStr : defStrs) {
                MavenCli.setCliProperty(defStr, userProperties);
            }
        }
        SystemProperties.addSystemProperties(systemProperties);
        Properties buildProperties = CLIReportingUtils.getBuildProperties();
        String mavenVersion = buildProperties.getProperty("version");
        systemProperties.setProperty("maven.version", mavenVersion);
        String mavenBuildVersion = CLIReportingUtils.createMavenVersionString(buildProperties);
        systemProperties.setProperty("maven.build.version", mavenBuildVersion);
    }

    private static void setCliProperty(String property, Properties properties) {
        String value;
        String name;
        int i = property.indexOf(61);
        if (i <= 0) {
            name = property.trim();
            value = "true";
        } else {
            name = property.substring(0, i).trim();
            value = property.substring(i + 1);
        }
        properties.setProperty(name, value);
        System.setProperty(name, value);
    }

    protected TransferListener getConsoleTransferListener(boolean printResourceNames) {
        return new ConsoleMavenTransferListener(System.out, printResourceNames);
    }

    protected TransferListener getBatchTransferListener() {
        return new Slf4jMavenTransferListener();
    }

    protected void customizeContainer(PlexusContainer container) {
    }

    protected ModelProcessor createModelProcessor(PlexusContainer container) throws ComponentLookupException {
        return container.lookup(ModelProcessor.class);
    }

    static class ExitException
    extends Exception {
        int exitCode;

        ExitException(int exitCode) {
            this.exitCode = exitCode;
        }
    }
}

