/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.file.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.file.CopyOptions;
import io.vertx.core.file.FileProps;
import io.vertx.core.file.FileSystem;
import io.vertx.core.file.FileSystemException;
import io.vertx.core.file.FileSystemProps;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.file.impl.AsyncFileImpl;
import io.vertx.core.file.impl.FilePropsImpl;
import io.vertx.core.file.impl.FileSystemPropsImpl;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class FileSystemImpl
implements FileSystem {
    private static final CopyOptions DEFAULT_OPTIONS = new CopyOptions();
    protected final VertxInternal vertx;

    public FileSystemImpl(VertxInternal vertx) {
        this.vertx = vertx;
    }

    @Override
    public FileSystem copy(String from, String to, Handler<AsyncResult<Void>> handler) {
        return this.copy(from, to, DEFAULT_OPTIONS, handler);
    }

    @Override
    public FileSystem copy(String from, String to, CopyOptions options, Handler<AsyncResult<Void>> handler) {
        this.copyInternal(from, to, options, handler).run();
        return this;
    }

    @Override
    public FileSystem copyBlocking(String from, String to) {
        this.copyInternal(from, to, DEFAULT_OPTIONS, null).perform();
        return this;
    }

    @Override
    public FileSystem copyRecursive(String from, String to, boolean recursive, Handler<AsyncResult<Void>> handler) {
        this.copyRecursiveInternal(from, to, recursive, handler).run();
        return this;
    }

    @Override
    public FileSystem copyRecursiveBlocking(String from, String to, boolean recursive) {
        this.copyRecursiveInternal(from, to, recursive, null).perform();
        return this;
    }

    @Override
    public FileSystem move(String from, String to, Handler<AsyncResult<Void>> handler) {
        return this.move(from, to, DEFAULT_OPTIONS, handler);
    }

    @Override
    public FileSystem move(String from, String to, CopyOptions options, Handler<AsyncResult<Void>> handler) {
        this.moveInternal(from, to, options, handler).run();
        return this;
    }

    @Override
    public FileSystem moveBlocking(String from, String to) {
        this.moveInternal(from, to, DEFAULT_OPTIONS, null).perform();
        return this;
    }

    @Override
    public FileSystem truncate(String path, long len, Handler<AsyncResult<Void>> handler) {
        this.truncateInternal(path, len, handler).run();
        return this;
    }

    @Override
    public FileSystem truncateBlocking(String path, long len) {
        this.truncateInternal(path, len, null).perform();
        return this;
    }

    @Override
    public FileSystem chmod(String path, String perms, Handler<AsyncResult<Void>> handler) {
        this.chmodInternal(path, perms, handler).run();
        return this;
    }

    @Override
    public FileSystem chmodBlocking(String path, String perms) {
        this.chmodInternal(path, perms, null).perform();
        return this;
    }

    @Override
    public FileSystem chmodRecursive(String path, String perms, String dirPerms, Handler<AsyncResult<Void>> handler) {
        this.chmodInternal(path, perms, dirPerms, handler).run();
        return this;
    }

    @Override
    public FileSystem chmodRecursiveBlocking(String path, String perms, String dirPerms) {
        this.chmodInternal(path, perms, dirPerms, null).perform();
        return this;
    }

    @Override
    public FileSystem chown(String path, String user, String group, Handler<AsyncResult<Void>> handler) {
        this.chownInternal(path, user, group, handler).run();
        return this;
    }

    @Override
    public FileSystem chownBlocking(String path, String user, String group) {
        this.chownInternal(path, user, group, null).perform();
        return this;
    }

    @Override
    public FileSystem props(String path, Handler<AsyncResult<FileProps>> handler) {
        this.propsInternal(path, handler).run();
        return this;
    }

    @Override
    public FileProps propsBlocking(String path) {
        return this.propsInternal(path, null).perform();
    }

    @Override
    public FileSystem lprops(String path, Handler<AsyncResult<FileProps>> handler) {
        this.lpropsInternal(path, handler).run();
        return this;
    }

    @Override
    public FileProps lpropsBlocking(String path) {
        return this.lpropsInternal(path, null).perform();
    }

    @Override
    public FileSystem link(String link, String existing, Handler<AsyncResult<Void>> handler) {
        this.linkInternal(link, existing, handler).run();
        return this;
    }

    @Override
    public FileSystem linkBlocking(String link, String existing) {
        this.linkInternal(link, existing, null).perform();
        return this;
    }

    @Override
    public FileSystem symlink(String link, String existing, Handler<AsyncResult<Void>> handler) {
        this.symlinkInternal(link, existing, handler).run();
        return this;
    }

    @Override
    public FileSystem symlinkBlocking(String link, String existing) {
        this.symlinkInternal(link, existing, null).perform();
        return this;
    }

    @Override
    public FileSystem unlink(String link, Handler<AsyncResult<Void>> handler) {
        this.unlinkInternal(link, handler).run();
        return this;
    }

    @Override
    public FileSystem unlinkBlocking(String link) {
        this.unlinkInternal(link, null).perform();
        return this;
    }

    @Override
    public FileSystem readSymlink(String link, Handler<AsyncResult<String>> handler) {
        this.readSymlinkInternal(link, handler).run();
        return this;
    }

    @Override
    public String readSymlinkBlocking(String link) {
        return this.readSymlinkInternal(link, null).perform();
    }

    @Override
    public FileSystem delete(String path, Handler<AsyncResult<Void>> handler) {
        this.deleteInternal(path, handler).run();
        return this;
    }

    @Override
    public FileSystem deleteBlocking(String path) {
        this.deleteInternal(path, null).perform();
        return this;
    }

    @Override
    public FileSystem deleteRecursive(String path, boolean recursive, Handler<AsyncResult<Void>> handler) {
        this.deleteInternal(path, recursive, handler).run();
        return this;
    }

    @Override
    public FileSystem deleteRecursiveBlocking(String path, boolean recursive) {
        this.deleteInternal(path, recursive, null).perform();
        return this;
    }

    @Override
    public FileSystem mkdir(String path, Handler<AsyncResult<Void>> handler) {
        this.mkdirInternal(path, handler).run();
        return this;
    }

    @Override
    public FileSystem mkdirBlocking(String path) {
        this.mkdirInternal(path, null).perform();
        return this;
    }

    @Override
    public FileSystem mkdirs(String path, Handler<AsyncResult<Void>> handler) {
        this.mkdirInternal(path, true, handler).run();
        return this;
    }

    @Override
    public FileSystem mkdirsBlocking(String path) {
        this.mkdirInternal(path, true, null).perform();
        return this;
    }

    @Override
    public FileSystem mkdir(String path, String perms, Handler<AsyncResult<Void>> handler) {
        this.mkdirInternal(path, perms, handler).run();
        return this;
    }

    @Override
    public FileSystem mkdirBlocking(String path, String perms) {
        this.mkdirInternal(path, perms, null).perform();
        return this;
    }

    @Override
    public FileSystem mkdirs(String path, String perms, Handler<AsyncResult<Void>> handler) {
        this.mkdirInternal(path, perms, true, handler).run();
        return this;
    }

    @Override
    public FileSystem mkdirsBlocking(String path, String perms) {
        this.mkdirInternal(path, perms, true, null).perform();
        return this;
    }

    @Override
    public FileSystem readDir(String path, Handler<AsyncResult<List<String>>> handler) {
        this.readDirInternal(path, handler).run();
        return this;
    }

    @Override
    public List<String> readDirBlocking(String path) {
        return this.readDirInternal(path, null).perform();
    }

    @Override
    public FileSystem readDir(String path, String filter, Handler<AsyncResult<List<String>>> handler) {
        this.readDirInternal(path, filter, handler).run();
        return this;
    }

    @Override
    public List<String> readDirBlocking(String path, String filter) {
        return this.readDirInternal(path, filter, null).perform();
    }

    @Override
    public FileSystem readFile(String path, Handler<AsyncResult<Buffer>> handler) {
        this.readFileInternal(path, handler).run();
        return this;
    }

    @Override
    public Buffer readFileBlocking(String path) {
        return this.readFileInternal(path, null).perform();
    }

    @Override
    public FileSystem writeFile(String path, Buffer data, Handler<AsyncResult<Void>> handler) {
        this.writeFileInternal(path, data, handler).run();
        return this;
    }

    @Override
    public FileSystem writeFileBlocking(String path, Buffer data) {
        this.writeFileInternal(path, data, null).perform();
        return this;
    }

    @Override
    public FileSystem open(String path, OpenOptions options, Handler<AsyncResult<AsyncFile>> handler) {
        this.openInternal(path, options, handler).run();
        return this;
    }

    @Override
    public AsyncFile openBlocking(String path, OpenOptions options) {
        return this.openInternal(path, options, null).perform();
    }

    @Override
    public FileSystem createFile(String path, Handler<AsyncResult<Void>> handler) {
        this.createFileInternal(path, handler).run();
        return this;
    }

    @Override
    public FileSystem createFileBlocking(String path) {
        this.createFileInternal(path, null).perform();
        return this;
    }

    @Override
    public FileSystem createFile(String path, String perms, Handler<AsyncResult<Void>> handler) {
        this.createFileInternal(path, perms, handler).run();
        return this;
    }

    @Override
    public FileSystem createFileBlocking(String path, String perms) {
        this.createFileInternal(path, perms, null).perform();
        return this;
    }

    @Override
    public FileSystem exists(String path, Handler<AsyncResult<Boolean>> handler) {
        this.existsInternal(path, handler).run();
        return this;
    }

    @Override
    public boolean existsBlocking(String path) {
        return this.existsInternal(path, null).perform();
    }

    @Override
    public FileSystem fsProps(String path, Handler<AsyncResult<FileSystemProps>> handler) {
        this.fsPropsInternal(path, handler).run();
        return this;
    }

    @Override
    public FileSystemProps fsPropsBlocking(String path) {
        return this.fsPropsInternal(path, null).perform();
    }

    @Override
    public FileSystem createTempDirectory(String prefix, Handler<AsyncResult<String>> handler) {
        this.createTempDirectoryInternal(null, prefix, null, handler).run();
        return this;
    }

    @Override
    public String createTempDirectoryBlocking(String prefix) {
        return this.createTempDirectoryInternal(null, prefix, null, null).perform();
    }

    @Override
    public FileSystem createTempDirectory(String prefix, String perms, Handler<AsyncResult<String>> handler) {
        this.createTempDirectoryInternal(null, prefix, perms, handler).run();
        return this;
    }

    @Override
    public String createTempDirectoryBlocking(String prefix, String perms) {
        return this.createTempDirectoryInternal(null, prefix, perms, null).perform();
    }

    @Override
    public FileSystem createTempDirectory(String dir, String prefix, String perms, Handler<AsyncResult<String>> handler) {
        this.createTempDirectoryInternal(dir, prefix, perms, handler).run();
        return this;
    }

    @Override
    public String createTempDirectoryBlocking(String dir, String prefix, String perms) {
        return this.createTempDirectoryInternal(dir, prefix, perms, null).perform();
    }

    @Override
    public FileSystem createTempFile(String prefix, String suffix, Handler<AsyncResult<String>> handler) {
        this.createTempFileInternal(null, prefix, suffix, null, handler).run();
        return this;
    }

    @Override
    public String createTempFileBlocking(String prefix, String suffix) {
        return this.createTempFileInternal(null, prefix, suffix, null, null).perform();
    }

    @Override
    public FileSystem createTempFile(String prefix, String suffix, String perms, Handler<AsyncResult<String>> handler) {
        this.createTempFileInternal(null, prefix, suffix, perms, handler).run();
        return this;
    }

    @Override
    public String createTempFileBlocking(String prefix, String suffix, String perms) {
        return this.createTempFileInternal(null, prefix, suffix, perms, null).perform();
    }

    @Override
    public FileSystem createTempFile(String dir, String prefix, String suffix, String perms, Handler<AsyncResult<String>> handler) {
        this.createTempFileInternal(dir, prefix, suffix, perms, handler).run();
        return this;
    }

    @Override
    public String createTempFileBlocking(String dir, String prefix, String suffix, String perms) {
        return this.createTempFileInternal(dir, prefix, suffix, perms, null).perform();
    }

    private BlockingAction<Void> copyInternal(final String from, final String to, CopyOptions options, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        Objects.requireNonNull(options);
        Set<CopyOption> copyOptionSet = FileSystemImpl.toCopyOptionSet(options);
        final CopyOption[] copyOptions = copyOptionSet.toArray(new CopyOption[copyOptionSet.size()]);
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    Path source = FileSystemImpl.this.vertx.resolveFile(from).toPath();
                    Path target = FileSystemImpl.this.vertx.resolveFile(to).toPath();
                    Files.copy(source, target, copyOptions);
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> copyRecursiveInternal(final String from, final String to, final boolean recursive, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    final Path source = FileSystemImpl.this.vertx.resolveFile(from).toPath();
                    final Path target = FileSystemImpl.this.vertx.resolveFile(to).toPath();
                    if (recursive) {
                        Files.walkFileTree(source, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                block2: {
                                    Path targetDir = target.resolve(source.relativize(dir));
                                    try {
                                        Files.copy(dir, targetDir, new CopyOption[0]);
                                    }
                                    catch (FileAlreadyExistsException e) {
                                        if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                                        throw e;
                                    }
                                }
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                Files.copy(file, target.resolve(source.relativize(file)), new CopyOption[0]);
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    } else {
                        Files.copy(source, target, new CopyOption[0]);
                    }
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> moveInternal(final String from, final String to, CopyOptions options, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        Objects.requireNonNull(options);
        Set<CopyOption> copyOptionSet = FileSystemImpl.toCopyOptionSet(options);
        final CopyOption[] copyOptions = copyOptionSet.toArray(new CopyOption[copyOptionSet.size()]);
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    Path source = FileSystemImpl.this.vertx.resolveFile(from).toPath();
                    Path target = FileSystemImpl.this.vertx.resolveFile(to).toPath();
                    Files.move(source, target, copyOptions);
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> truncateInternal(final String p, final long len, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(p);
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                RandomAccessFile raf = null;
                try {
                    String path = FileSystemImpl.this.vertx.resolveFile(p).getAbsolutePath();
                    if (len < 0L) {
                        throw new FileSystemException("Cannot truncate file to size < 0");
                    }
                    if (!Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
                        throw new FileSystemException("Cannot truncate file " + path + ". Does not exist");
                    }
                    try {
                        raf = new RandomAccessFile(path, "rw");
                        raf.setLength(len);
                    }
                    finally {
                        if (raf != null) {
                            raf.close();
                        }
                    }
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> chmodInternal(String path, String perms, Handler<AsyncResult<Void>> handler) {
        return this.chmodInternal(path, perms, null, handler);
    }

    protected BlockingAction<Void> chmodInternal(final String path, String perms, String dirPerms, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(path);
        final Set<PosixFilePermission> permissions = PosixFilePermissions.fromString(perms);
        final Set<PosixFilePermission> dirPermissions = dirPerms == null ? null : PosixFilePermissions.fromString(dirPerms);
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    Path target = FileSystemImpl.this.vertx.resolveFile(path).toPath();
                    if (dirPermissions != null) {
                        Files.walkFileTree(target, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                Files.setPosixFilePermissions(dir, dirPermissions);
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                Files.setPosixFilePermissions(file, permissions);
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    } else {
                        Files.setPosixFilePermissions(target, permissions);
                    }
                }
                catch (SecurityException e) {
                    throw new FileSystemException("Accessed denied for chmod on " + path);
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    protected BlockingAction<Void> chownInternal(final String path, final String user, final String group, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(path);
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    GroupPrincipal groupPrincipal;
                    Path target = FileSystemImpl.this.vertx.resolveFile(path).toPath();
                    UserPrincipalLookupService service = target.getFileSystem().getUserPrincipalLookupService();
                    UserPrincipal userPrincipal = user == null ? null : service.lookupPrincipalByName(user);
                    GroupPrincipal groupPrincipal2 = groupPrincipal = group == null ? null : service.lookupPrincipalByGroupName(group);
                    if (groupPrincipal != null) {
                        PosixFileAttributeView view = Files.getFileAttributeView(target, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
                        if (view == null) {
                            throw new FileSystemException("Change group of file not supported");
                        }
                        view.setGroup(groupPrincipal);
                    }
                    if (userPrincipal != null) {
                        Files.setOwner(target, userPrincipal);
                    }
                }
                catch (SecurityException e) {
                    throw new FileSystemException("Accessed denied for chown on " + path);
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    private BlockingAction<FileProps> propsInternal(String path, Handler<AsyncResult<FileProps>> handler) {
        return this.props(path, true, handler);
    }

    private BlockingAction<FileProps> lpropsInternal(String path, Handler<AsyncResult<FileProps>> handler) {
        return this.props(path, false, handler);
    }

    private BlockingAction<FileProps> props(final String path, final boolean followLinks, Handler<AsyncResult<FileProps>> handler) {
        Objects.requireNonNull(path);
        return new BlockingAction<FileProps>(handler){

            @Override
            public FileProps perform() {
                try {
                    Path target = FileSystemImpl.this.vertx.resolveFile(path).toPath();
                    BasicFileAttributes attrs = followLinks ? Files.readAttributes(target, BasicFileAttributes.class, new LinkOption[0]) : Files.readAttributes(target, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                    return new FilePropsImpl(attrs);
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
        };
    }

    private BlockingAction<Void> linkInternal(String link, String existing, Handler<AsyncResult<Void>> handler) {
        return this.link(link, existing, false, handler);
    }

    private BlockingAction<Void> symlinkInternal(String link, String existing, Handler<AsyncResult<Void>> handler) {
        return this.link(link, existing, true, handler);
    }

    private BlockingAction<Void> link(final String link, final String existing, final boolean symbolic, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(link);
        Objects.requireNonNull(existing);
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    Path source = FileSystemImpl.this.vertx.resolveFile(link).toPath();
                    Path target = FileSystemImpl.this.vertx.resolveFile(existing).toPath();
                    if (symbolic) {
                        Files.createSymbolicLink(source, target, new FileAttribute[0]);
                    } else {
                        Files.createLink(source, target);
                    }
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> unlinkInternal(String link, Handler<AsyncResult<Void>> handler) {
        return this.deleteInternal(link, handler);
    }

    private BlockingAction<String> readSymlinkInternal(final String link, Handler<AsyncResult<String>> handler) {
        Objects.requireNonNull(link);
        return new BlockingAction<String>(handler){

            @Override
            public String perform() {
                try {
                    Path source = FileSystemImpl.this.vertx.resolveFile(link).toPath();
                    return Files.readSymbolicLink(source).toString();
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
        };
    }

    private BlockingAction<Void> deleteInternal(String path, Handler<AsyncResult<Void>> handler) {
        return this.deleteInternal(path, false, handler);
    }

    private BlockingAction<Void> deleteInternal(final String path, final boolean recursive, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(path);
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    Path source = FileSystemImpl.this.vertx.resolveFile(path).toPath();
                    FileSystemImpl.delete(source, recursive);
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    public static void delete(Path path, boolean recursive) throws IOException {
        if (recursive) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    if (e == null) {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    throw e;
                }
            });
        } else {
            Files.delete(path);
        }
    }

    private BlockingAction<Void> mkdirInternal(String path, Handler<AsyncResult<Void>> handler) {
        return this.mkdirInternal(path, null, false, handler);
    }

    private BlockingAction<Void> mkdirInternal(String path, boolean createParents, Handler<AsyncResult<Void>> handler) {
        return this.mkdirInternal(path, null, createParents, handler);
    }

    private BlockingAction<Void> mkdirInternal(String path, String perms, Handler<AsyncResult<Void>> handler) {
        return this.mkdirInternal(path, perms, false, handler);
    }

    protected BlockingAction<Void> mkdirInternal(final String path, String perms, final boolean createParents, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(path);
        final FileAttribute<Set<PosixFilePermission>> attrs = perms == null ? null : PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(perms));
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    Path source = FileSystemImpl.this.vertx.resolveFile(path).toPath();
                    if (createParents) {
                        if (attrs != null) {
                            Files.createDirectories(source, attrs);
                        } else {
                            Files.createDirectories(source, new FileAttribute[0]);
                        }
                    } else if (attrs != null) {
                        Files.createDirectory(source, attrs);
                    } else {
                        Files.createDirectory(source, new FileAttribute[0]);
                    }
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    protected BlockingAction<String> createTempDirectoryInternal(final String parentDir, final String prefix, String perms, Handler<AsyncResult<String>> handler) {
        final FileAttribute<Set<PosixFilePermission>> attrs = perms == null ? null : PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(perms));
        return new BlockingAction<String>(handler){

            @Override
            public String perform() {
                try {
                    Path tmpDir;
                    if (parentDir != null) {
                        Path dir = FileSystemImpl.this.vertx.resolveFile(parentDir).toPath();
                        tmpDir = attrs != null ? Files.createTempDirectory(dir, prefix, attrs) : Files.createTempDirectory(dir, prefix, new FileAttribute[0]);
                    } else {
                        tmpDir = attrs != null ? Files.createTempDirectory(prefix, attrs) : Files.createTempDirectory(prefix, new FileAttribute[0]);
                    }
                    return tmpDir.toFile().getAbsolutePath();
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
        };
    }

    protected BlockingAction<String> createTempFileInternal(final String parentDir, final String prefix, final String suffix, String perms, Handler<AsyncResult<String>> handler) {
        final FileAttribute<Set<PosixFilePermission>> attrs = perms == null ? null : PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(perms));
        return new BlockingAction<String>(handler){

            @Override
            public String perform() {
                try {
                    Path tmpFile;
                    if (parentDir != null) {
                        Path dir = FileSystemImpl.this.vertx.resolveFile(parentDir).toPath();
                        tmpFile = attrs != null ? Files.createTempFile(dir, prefix, suffix, attrs) : Files.createTempFile(dir, prefix, suffix, new FileAttribute[0]);
                    } else {
                        tmpFile = attrs != null ? Files.createTempFile(prefix, suffix, attrs) : Files.createTempFile(prefix, suffix, new FileAttribute[0]);
                    }
                    return tmpFile.toFile().getAbsolutePath();
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
        };
    }

    private BlockingAction<List<String>> readDirInternal(String path, Handler<AsyncResult<List<String>>> handler) {
        return this.readDirInternal(path, null, handler);
    }

    private BlockingAction<List<String>> readDirInternal(final String p, final String filter, Handler<AsyncResult<List<String>>> handler) {
        Objects.requireNonNull(p);
        return new BlockingAction<List<String>>(handler){

            @Override
            public List<String> perform() {
                try {
                    File file = FileSystemImpl.this.vertx.resolveFile(p);
                    if (!file.exists()) {
                        throw new FileSystemException("Cannot read directory " + file + ". Does not exist");
                    }
                    if (!file.isDirectory()) {
                        throw new FileSystemException("Cannot read directory " + file + ". It's not a directory");
                    }
                    FilenameFilter fnFilter = filter != null ? new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return Pattern.matches(filter, name);
                        }
                    } : null;
                    File[] files = fnFilter == null ? file.listFiles() : file.listFiles(fnFilter);
                    ArrayList<String> ret = new ArrayList<String>(files.length);
                    for (File f : files) {
                        ret.add(f.getCanonicalPath());
                    }
                    return ret;
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
        };
    }

    private BlockingAction<Buffer> readFileInternal(final String path, Handler<AsyncResult<Buffer>> handler) {
        Objects.requireNonNull(path);
        return new BlockingAction<Buffer>(handler){

            @Override
            public Buffer perform() {
                try {
                    Path target = FileSystemImpl.this.vertx.resolveFile(path).toPath();
                    byte[] bytes = Files.readAllBytes(target);
                    Buffer buff = Buffer.buffer(bytes);
                    return buff;
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
        };
    }

    private BlockingAction<Void> writeFileInternal(final String path, final Buffer data, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(data);
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    Path target = FileSystemImpl.this.vertx.resolveFile(path).toPath();
                    Files.write(target, data.getBytes(), new OpenOption[0]);
                    return null;
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
        };
    }

    private BlockingAction<AsyncFile> openInternal(final String p, final OpenOptions options, Handler<AsyncResult<AsyncFile>> handler) {
        Objects.requireNonNull(p);
        Objects.requireNonNull(options);
        return new BlockingAction<AsyncFile>(handler){

            @Override
            public AsyncFile perform() {
                String path = FileSystemImpl.this.vertx.resolveFile(p).getAbsolutePath();
                return FileSystemImpl.this.doOpen(path, options, this.context);
            }
        };
    }

    protected AsyncFile doOpen(String path, OpenOptions options, ContextInternal context) {
        return new AsyncFileImpl(this.vertx, path, options, context);
    }

    private BlockingAction<Void> createFileInternal(String path, Handler<AsyncResult<Void>> handler) {
        return this.createFileInternal(path, null, handler);
    }

    protected BlockingAction<Void> createFileInternal(final String p, String perms, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(p);
        final FileAttribute<Set<PosixFilePermission>> attrs = perms == null ? null : PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(perms));
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    Path target = FileSystemImpl.this.vertx.resolveFile(p).toPath();
                    if (attrs != null) {
                        Files.createFile(target, attrs);
                    } else {
                        Files.createFile(target, new FileAttribute[0]);
                    }
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    private BlockingAction<Boolean> existsInternal(final String path, Handler<AsyncResult<Boolean>> handler) {
        Objects.requireNonNull(path);
        return new BlockingAction<Boolean>(handler){

            @Override
            public Boolean perform() {
                File file = FileSystemImpl.this.vertx.resolveFile(path);
                return file.exists();
            }
        };
    }

    private BlockingAction<FileSystemProps> fsPropsInternal(final String path, Handler<AsyncResult<FileSystemProps>> handler) {
        Objects.requireNonNull(path);
        return new BlockingAction<FileSystemProps>(handler){

            @Override
            public FileSystemProps perform() {
                try {
                    Path target = FileSystemImpl.this.vertx.resolveFile(path).toPath();
                    FileStore fs = Files.getFileStore(target);
                    return new FileSystemPropsImpl(fs.getTotalSpace(), fs.getUnallocatedSpace(), fs.getUsableSpace());
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
        };
    }

    static Set<CopyOption> toCopyOptionSet(CopyOptions copyOptions) {
        HashSet<CopyOption> copyOptionSet = new HashSet<CopyOption>();
        if (copyOptions.isReplaceExisting()) {
            copyOptionSet.add(StandardCopyOption.REPLACE_EXISTING);
        }
        if (copyOptions.isCopyAttributes()) {
            copyOptionSet.add(StandardCopyOption.COPY_ATTRIBUTES);
        }
        if (copyOptions.isAtomicMove()) {
            copyOptionSet.add(StandardCopyOption.ATOMIC_MOVE);
        }
        if (copyOptions.isNofollowLinks()) {
            copyOptionSet.add(LinkOption.NOFOLLOW_LINKS);
        }
        return copyOptionSet;
    }

    protected abstract class BlockingAction<T>
    implements Handler<Promise<T>> {
        private final Handler<AsyncResult<T>> handler;
        protected final ContextInternal context;

        public BlockingAction(Handler<AsyncResult<T>> handler) {
            this.handler = handler;
            this.context = FileSystemImpl.this.vertx.getOrCreateContext();
        }

        public void run() {
            this.context.executeBlockingInternal(this, this.handler);
        }

        @Override
        public void handle(Promise<T> fut) {
            try {
                T result = this.perform();
                fut.complete(result);
            }
            catch (Exception e) {
                fut.fail(e);
            }
        }

        public abstract T perform();
    }
}

