/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.attribute;

import io.quarkus.vertx.http.runtime.attribute.ExchangeAttribute;
import io.quarkus.vertx.http.runtime.attribute.ExchangeAttributeBuilder;
import io.quarkus.vertx.http.runtime.attribute.ReadOnlyAttributeException;
import io.vertx.ext.web.RoutingContext;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public class DateTimeAttribute
implements ExchangeAttribute {
    private static final String COMMON_LOG_PATTERN = "[dd/MMM/yyyy:HH:mm:ss Z]";
    public static final String DATE_TIME_SHORT = "%t";
    public static final String DATE_TIME = "%{DATE_TIME}";
    public static final String CUSTOM_TIME = "%{time,";
    public static final ExchangeAttribute INSTANCE = new DateTimeAttribute();
    private final DateTimeFormatter formatter;

    private DateTimeAttribute() {
        this(COMMON_LOG_PATTERN, null);
    }

    public DateTimeAttribute(String dateFormat) {
        this(dateFormat, null);
    }

    public DateTimeAttribute(String dateFormat, String timezone) {
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(dateFormat, Locale.US);
        if (timezone != null) {
            fmt = fmt.withZone(ZoneId.of(timezone));
        }
        this.formatter = fmt;
    }

    @Override
    public String readAttribute(RoutingContext exchange) {
        return this.formatter.format(LocalDateTime.now());
    }

    @Override
    public void writeAttribute(RoutingContext exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Date time", newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Date Time";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(DateTimeAttribute.DATE_TIME) || token.equals(DateTimeAttribute.DATE_TIME_SHORT)) {
                return INSTANCE;
            }
            if (token.startsWith(DateTimeAttribute.CUSTOM_TIME) && token.endsWith("}")) {
                return new DateTimeAttribute(token.substring(DateTimeAttribute.CUSTOM_TIME.length(), token.length() - 1));
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

