/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.filters.accesslog;

import io.quarkus.vertx.http.runtime.attribute.ExchangeAttribute;
import io.quarkus.vertx.http.runtime.attribute.ExchangeAttributeParser;
import io.quarkus.vertx.http.runtime.attribute.SubstituteEmptyWrapper;
import io.quarkus.vertx.http.runtime.filters.QuarkusRequestWrapper;
import io.quarkus.vertx.http.runtime.filters.accesslog.AccessLogReceiver;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;

public class AccessLogHandler
implements Handler<RoutingContext> {
    private final AccessLogReceiver accessLogReceiver;
    private final String formatString;
    private final ExchangeAttribute tokens;

    public AccessLogHandler(AccessLogReceiver accessLogReceiver, String formatString, ClassLoader classLoader) {
        this.accessLogReceiver = accessLogReceiver;
        this.formatString = AccessLogHandler.handleCommonNames(formatString);
        this.tokens = new ExchangeAttributeParser(classLoader, Collections.singletonList(new SubstituteEmptyWrapper("-"))).parse(this.formatString);
    }

    public AccessLogHandler(AccessLogReceiver accessLogReceiver, String formatString, ExchangeAttribute attribute) {
        this.accessLogReceiver = accessLogReceiver;
        this.formatString = AccessLogHandler.handleCommonNames(formatString);
        this.tokens = attribute;
    }

    private static String handleCommonNames(String formatString) {
        if (formatString.equals("common")) {
            return "%h %l %u %t \"%r\" %s %b";
        }
        if (formatString.equals("combined")) {
            return "%h %l %u %t \"%r\" %s %b \"%{i,Referer}\" \"%{i,User-Agent}\"";
        }
        return formatString;
    }

    public void handle(final RoutingContext rc) {
        QuarkusRequestWrapper.get(rc.request()).addRequestDoneHandler(new Handler<Void>(){

            public void handle(Void event) {
                AccessLogHandler.this.accessLogReceiver.logMessage(AccessLogHandler.this.tokens.readAttribute(rc));
            }
        });
        rc.next();
    }

    public String toString() {
        return "AccessLogHandler{formatString='" + this.formatString + '\'' + '}';
    }
}

