/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.sse;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.Produces;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.sse.OutboundSseEvent;
import javax.ws.rs.sse.SseEventSink;
import org.jboss.resteasy.annotations.SseElementType;
import org.jboss.resteasy.annotations.Stream;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.ServerResponseWriter;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.providers.sse.OutboundSseEventImpl;
import org.jboss.resteasy.plugins.providers.sse.SseConstants;
import org.jboss.resteasy.plugins.server.Cleanable;
import org.jboss.resteasy.plugins.server.Cleanables;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyAsynchronousContext;
import org.jboss.resteasy.spi.ResteasyAsynchronousResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class SseEventOutputImpl
extends GenericType<OutboundSseEvent>
implements SseEventSink {
    private final MessageBodyWriter<OutboundSseEvent> writer;
    private final ResteasyAsynchronousContext asyncContext;
    private final HttpResponse response;
    private final HttpRequest request;
    private volatile boolean closed;
    private final Map<Class<?>, Object> contextDataMap;
    private boolean responseFlushed = false;
    private final Object lock = new Object();

    public SseEventOutputImpl(MessageBodyWriter<OutboundSseEvent> writer) {
        this.writer = writer;
        this.contextDataMap = ResteasyContext.getContextDataMap();
        this.request = ResteasyContext.getContextData(HttpRequest.class);
        this.asyncContext = this.request.getAsyncContext();
        if (!this.asyncContext.isSuspended()) {
            try {
                this.asyncContext.suspend();
            }
            catch (IllegalStateException ex) {
                LogMessages.LOGGER.failedToSetRequestAsync();
            }
        }
        this.response = ResteasyContext.getContextData(HttpResponse.class);
    }

    public void close() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(boolean flushBeforeClose) {
        Object object = this.lock;
        synchronized (object) {
            ResteasyAsynchronousResponse asyncResponse;
            this.closed = true;
            if (flushBeforeClose && this.responseFlushed) {
                ResteasyContext.pushContextDataMap(this.contextDataMap);
                try {
                    AsyncOutputStream aos = this.response.getAsyncOutputStream();
                    aos.asyncFlush().toCompletableFuture().get();
                }
                catch (IOException | InterruptedException | ExecutionException aos) {
                }
                finally {
                    ResteasyContext.removeContextDataLevel();
                }
            }
            if (this.asyncContext.isSuspended() && (asyncResponse = this.asyncContext.getAsyncResponse()) != null) {
                asyncResponse.complete();
            }
            this.clearContextData();
        }
    }

    public void clearContextData() {
        Cleanables cleanables;
        Map<Class<?>, Object> map = ResteasyContext.getContextDataMap(false);
        Cleanables cleanables2 = cleanables = map != null ? (Cleanables)map.get(Cleanables.class) : null;
        if (cleanables != null) {
            Iterator<Cleanable> it = cleanables.getCleanables().iterator();
            while (it.hasNext()) {
                try {
                    it.next().clean();
                }
                catch (Exception exception) {}
            }
            ResteasyContext.clearContextData();
        }
    }

    protected void flushResponseToClient() {
        this.internalFlushResponseToClient(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<Void> internalFlushResponseToClient(boolean throwIOException) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.responseFlushed) {
                BuiltResponse jaxrsResponse = null;
                if (this.closed) {
                    jaxrsResponse = (BuiltResponse)Response.noContent().build();
                } else {
                    ResourceMethodInvoker method = (ResourceMethodInvoker)this.request.getAttribute(ResourceMethodInvoker.class.getName());
                    Produces produces = method.getMethod().getAnnotation(Produces.class);
                    if (produces != null && this.contains(produces.value(), "text/event-stream")) {
                        SseElementType sseElementType = method.getMethod().getAnnotation(SseElementType.class);
                        if (sseElementType != null) {
                            HashMap<String, String> parameterMap = new HashMap<String, String>();
                            parameterMap.put("element-type", sseElementType.value());
                            MediaType mediaType = new MediaType(MediaType.SERVER_SENT_EVENTS_TYPE.getType(), MediaType.SERVER_SENT_EVENTS_TYPE.getSubtype(), parameterMap);
                            jaxrsResponse = (BuiltResponse)Response.ok().type(mediaType).build();
                        } else {
                            jaxrsResponse = (BuiltResponse)Response.ok().type("text/event-stream").build();
                        }
                    } else {
                        Stream stream = method.getMethod().getAnnotation(Stream.class);
                        if (stream != null) {
                            jaxrsResponse = (BuiltResponse)Response.ok((Object)"").build();
                            MediaType elementType = ServerResponseWriter.getResponseMediaType(jaxrsResponse, this.request, this.response, ResteasyProviderFactory.getInstance(), method);
                            HashMap<String, String> parameterMap = new HashMap<String, String>();
                            parameterMap.put("element-type", elementType.toString());
                            String[] streamType = this.getStreamType(method);
                            MediaType mediaType = new MediaType(streamType[0], streamType[1], parameterMap);
                            jaxrsResponse = (BuiltResponse)Response.ok().type(mediaType).build();
                        } else {
                            throw new RuntimeException(Messages.MESSAGES.expectedStreamOrSseMediaType());
                        }
                    }
                }
                try {
                    CompletableFuture<Void> ret = new CompletableFuture<Void>();
                    ServerResponseWriter.writeNomapResponse(jaxrsResponse, this.request, this.response, ResteasyProviderFactory.getInstance(), t -> {
                        AsyncOutputStream aos;
                        try {
                            aos = this.response.getAsyncOutputStream();
                        }
                        catch (IOException x) {
                            this.close(false);
                            ret.completeExceptionally(x);
                            return;
                        }
                        CompletionStage a = aos.asyncWrite(SseConstants.DOUBLE_EOL);
                        CompletionStage b = aos.asyncFlush();
                        this.responseFlushed = true;
                        a.thenCompose(v -> b).thenAccept(v -> ret.complete(null)).exceptionally(e -> {
                            if (e instanceof CompletionException) {
                                e = e.getCause();
                            }
                            if (e instanceof IOException) {
                                this.close(false);
                            }
                            if (throwIOException) {
                                ret.completeExceptionally((Throwable)e);
                            } else {
                                ret.completeExceptionally(new ProcessingException(Messages.MESSAGES.failedToCreateSseEventOutput(), e));
                            }
                            return null;
                        });
                    }, true);
                    return ret;
                }
                catch (IOException e) {
                    this.close(false);
                    CompletableFuture<Void> ret = new CompletableFuture<Void>();
                    if (throwIOException) {
                        ret.completeExceptionally(e);
                    } else {
                        ret.completeExceptionally(new ProcessingException(Messages.MESSAGES.failedToCreateSseEventOutput(), (Throwable)e));
                    }
                    return ret;
                }
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<?> send(OutboundSseEvent event) {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException(Messages.MESSAGES.sseEventSinkIsClosed());
            }
            CompletionStage<Void> a = this.internalFlushResponseToClient(true);
            CompletionStage<Void> b = this.writeEvent(event);
            return a.thenCompose(v -> b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CompletionStage<Void> writeEvent(OutboundSseEvent event) {
        Object object = this.lock;
        synchronized (object) {
            ResteasyContext.pushContextDataMap(this.contextDataMap);
            try {
                Object o;
                boolean mediaTypeSet;
                if (event == null) return CompletableFuture.completedFuture(null);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                MediaType mediaType = event.getMediaType();
                boolean bl = mediaTypeSet = event instanceof OutboundSseEventImpl ? ((OutboundSseEventImpl)event).isMediaTypeSet() : true;
                if (!(mediaType != null && mediaTypeSet || (o = this.response.getOutputHeaders().getFirst((Object)"Content-Type")) == null)) {
                    String s;
                    MediaType mt;
                    if (o instanceof MediaType) {
                        mt = (MediaType)o;
                        s = (String)mt.getParameters().get("element-type");
                        if (s != null) {
                            mediaType = MediaType.valueOf((String)s);
                        }
                    } else {
                        if (!(o instanceof String)) throw new RuntimeException(Messages.MESSAGES.expectedStringOrMediaType(o));
                        mt = MediaType.valueOf((String)((String)o));
                        s = (String)mt.getParameters().get("element-type");
                        if (s != null) {
                            mediaType = MediaType.valueOf((String)s);
                        }
                    }
                }
                if (mediaType == null) {
                    mediaType = MediaType.TEXT_PLAIN_TYPE;
                }
                if (event instanceof OutboundSseEventImpl) {
                    ((OutboundSseEventImpl)event).setMediaType(mediaType);
                }
                this.writer.writeTo((Object)event, event.getClass(), null, new Annotation[0], mediaType, null, (OutputStream)bout);
                AsyncOutputStream aos = this.response.getAsyncOutputStream();
                CompletionStage a = aos.asyncWrite(bout.toByteArray());
                CompletionStage b = aos.asyncFlush();
                CompletionStage<Void> completionStage = a.thenCompose(v -> b).exceptionally(e -> {
                    if (e instanceof CompletionException) {
                        e = e.getCause();
                    }
                    if (e instanceof IOException) {
                        this.close(false);
                    }
                    LogMessages.LOGGER.failedToWriteSseEvent(event.toString(), e);
                    SynchronousDispatcher.rethrow(e);
                    return null;
                });
                return completionStage;
            }
            catch (IOException e2) {
                this.close(false);
                LogMessages.LOGGER.failedToWriteSseEvent(event.toString(), (Throwable)e2);
                CompletableFuture<Void> ret = new CompletableFuture<Void>();
                ret.completeExceptionally(e2);
                CompletableFuture<Void> completableFuture = ret;
                return completableFuture;
            }
            catch (Exception e3) {
                LogMessages.LOGGER.failedToWriteSseEvent(event.toString(), (Throwable)e3);
                CompletableFuture<Void> ret = new CompletableFuture<Void>();
                ret.completeExceptionally(new ProcessingException((Throwable)e3));
                CompletableFuture<Void> completableFuture = ret;
                return completableFuture;
            }
            finally {
                ResteasyContext.removeContextDataLevel();
            }
        }
    }

    private String[] getStreamType(ResourceMethodInvoker method) {
        Stream.MODE mode;
        Stream stream = method.getMethod().getAnnotation(Stream.class);
        Stream.MODE mODE = mode = stream != null ? stream.value() : null;
        if (mode == null) {
            return new String[]{"text", "event-stream"};
        }
        if (Stream.MODE.GENERAL.equals((Object)mode)) {
            return new String[]{"application", "x-stream-general"};
        }
        if (Stream.MODE.RAW.equals((Object)mode)) {
            return new String[]{"application", "x-stream-raw"};
        }
        throw new RuntimeException(Messages.MESSAGES.expectedStreamModeGeneralOrRaw(mode));
    }

    private boolean contains(String[] ss, String t) {
        for (String s : ss) {
            if (!s.startsWith(t)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

