/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerStats;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Messages;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.impl.ConsumerBase;
import org.apache.pulsar.client.impl.ConsumerImpl;
import org.apache.pulsar.client.impl.ConsumerInterceptors;
import org.apache.pulsar.client.impl.ConsumerStatsRecorder;
import org.apache.pulsar.client.impl.ConsumerStatsRecorderImpl;
import org.apache.pulsar.client.impl.HandlerState;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.MessagesImpl;
import org.apache.pulsar.client.impl.MultiMessageIdImpl;
import org.apache.pulsar.client.impl.PartitionsChangedListener;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.TopicMessageIdImpl;
import org.apache.pulsar.client.impl.TopicMessageImpl;
import org.apache.pulsar.client.impl.UnAckedMessageTracker;
import org.apache.pulsar.client.impl.UnAckedTopicMessageTracker;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;
import org.apache.pulsar.client.impl.transaction.TransactionImpl;
import org.apache.pulsar.client.util.ConsumerName;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.com.google.common.collect.Queues;
import org.apache.pulsar.shade.io.netty.util.Timeout;
import org.apache.pulsar.shade.io.netty.util.TimerTask;
import org.apache.pulsar.shade.org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTopicsConsumerImpl<T>
extends ConsumerBase<T> {
    public static final String DUMMY_TOPIC_NAME_PREFIX = "MultiTopicsConsumer-";
    protected NamespaceName namespaceName;
    private final ConcurrentHashMap<String, ConsumerImpl<T>> consumers;
    protected final ConcurrentHashMap<String, Integer> topics;
    private final ConcurrentLinkedQueue<ConsumerImpl<T>> pausedConsumers;
    private final int sharedQueueResumeThreshold;
    AtomicInteger allTopicPartitionsNumber;
    private volatile Timeout partitionsAutoUpdateTimeout = null;
    TopicsPartitionChangedListener topicsPartitionChangedListener;
    CompletableFuture<Void> partitionsAutoUpdateFuture = null;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final ConsumerStatsRecorder stats;
    private final UnAckedMessageTracker unAckedMessageTracker;
    private final ConsumerConfigurationData<T> internalConfig;
    private TimerTask partitionsAutoUpdateTimerTask = new TimerTask(){

        @Override
        public void run(Timeout timeout) throws Exception {
            if (timeout.isCancelled() || MultiTopicsConsumerImpl.this.getState() != HandlerState.State.Ready) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("[{}] run partitionsAutoUpdateTimerTask", (Object)MultiTopicsConsumerImpl.this.topic);
            }
            if (MultiTopicsConsumerImpl.this.partitionsAutoUpdateFuture == null || MultiTopicsConsumerImpl.this.partitionsAutoUpdateFuture.isDone()) {
                MultiTopicsConsumerImpl.this.partitionsAutoUpdateFuture = MultiTopicsConsumerImpl.this.topicsPartitionChangedListener.onTopicsExtended(MultiTopicsConsumerImpl.this.topics.keySet());
            }
            MultiTopicsConsumerImpl.this.partitionsAutoUpdateTimeout = MultiTopicsConsumerImpl.this.client.timer().newTimeout(MultiTopicsConsumerImpl.this.partitionsAutoUpdateTimerTask, 1L, TimeUnit.MINUTES);
        }
    };
    private static final Logger log = LoggerFactory.getLogger(MultiTopicsConsumerImpl.class);

    MultiTopicsConsumerImpl(PulsarClientImpl client, ConsumerConfigurationData<T> conf, ExecutorService listenerExecutor, CompletableFuture<Consumer<T>> subscribeFuture, Schema<T> schema, ConsumerInterceptors<T> interceptors, boolean createTopicIfDoesNotExist) {
        this(client, DUMMY_TOPIC_NAME_PREFIX + ConsumerName.generateRandomName(), conf, listenerExecutor, subscribeFuture, schema, interceptors, createTopicIfDoesNotExist);
    }

    MultiTopicsConsumerImpl(PulsarClientImpl client, String singleTopic, ConsumerConfigurationData<T> conf, ExecutorService listenerExecutor, CompletableFuture<Consumer<T>> subscribeFuture, Schema<T> schema, ConsumerInterceptors<T> interceptors, boolean createTopicIfDoesNotExist) {
        super(client, singleTopic, conf, Math.max(2, conf.getReceiverQueueSize()), listenerExecutor, subscribeFuture, schema, interceptors);
        Preconditions.checkArgument(conf.getReceiverQueueSize() > 0, "Receiver queue size needs to be greater than 0 for Topics Consumer");
        this.topics = new ConcurrentHashMap();
        this.consumers = new ConcurrentHashMap();
        this.pausedConsumers = new ConcurrentLinkedQueue();
        this.sharedQueueResumeThreshold = this.maxReceiverQueueSize / 2;
        this.allTopicPartitionsNumber = new AtomicInteger(0);
        this.unAckedMessageTracker = conf.getAckTimeoutMillis() != 0L ? (conf.getTickDurationMillis() > 0L ? new UnAckedTopicMessageTracker(client, this, conf.getAckTimeoutMillis(), conf.getTickDurationMillis()) : new UnAckedTopicMessageTracker(client, this, conf.getAckTimeoutMillis())) : UnAckedMessageTracker.UNACKED_MESSAGE_TRACKER_DISABLED;
        this.internalConfig = this.getInternalConsumerConfig();
        ConsumerStatsRecorder consumerStatsRecorder = this.stats = client.getConfiguration().getStatsIntervalSeconds() > 0L ? new ConsumerStatsRecorderImpl() : null;
        if (conf.isAutoUpdatePartitions()) {
            this.topicsPartitionChangedListener = new TopicsPartitionChangedListener();
            this.partitionsAutoUpdateTimeout = client.timer().newTimeout(this.partitionsAutoUpdateTimerTask, 1L, TimeUnit.MINUTES);
        }
        if (conf.getTopicNames().isEmpty()) {
            this.namespaceName = null;
            this.setState(HandlerState.State.Ready);
            this.subscribeFuture().complete(this);
            return;
        }
        Preconditions.checkArgument(conf.getTopicNames().isEmpty() || MultiTopicsConsumerImpl.topicNamesValid(conf.getTopicNames()), "Topics should have same namespace.");
        this.namespaceName = (NamespaceName)conf.getTopicNames().stream().findFirst().flatMap(s -> Optional.of(TopicName.get(s).getNamespaceObject())).get();
        List futures = conf.getTopicNames().stream().map(t -> this.subscribeAsync((String)t, createTopicIfDoesNotExist)).collect(Collectors.toList());
        ((CompletableFuture)FutureUtil.waitForAll(futures).thenAccept(finalFuture -> {
            if (this.allTopicPartitionsNumber.get() > this.maxReceiverQueueSize) {
                this.setMaxReceiverQueueSize(this.allTopicPartitionsNumber.get());
            }
            this.setState(HandlerState.State.Ready);
            this.startReceivingMessages(new ArrayList<ConsumerImpl<T>>(this.consumers.values()));
            log.info("[{}] [{}] Created topics consumer with {} sub-consumers", new Object[]{this.topic, this.subscription, this.allTopicPartitionsNumber.get()});
            this.subscribeFuture().complete(this);
        })).exceptionally(ex -> {
            log.warn("[{}] Failed to subscribe topics: {}", (Object)this.topic, (Object)ex.getMessage());
            subscribeFuture.completeExceptionally((Throwable)ex);
            return null;
        });
    }

    private static boolean topicNamesValid(Collection<String> topics) {
        Preconditions.checkState(topics != null && topics.size() >= 1, "topics should contain more than 1 topic");
        String namespace = TopicName.get(topics.stream().findFirst().get()).getNamespace();
        Optional<String> result = topics.stream().filter(topic -> {
            boolean topicInvalid;
            boolean bl = topicInvalid = !TopicName.isValid(topic);
            if (topicInvalid) {
                return true;
            }
            String newNamespace = TopicName.get(topic).getNamespace();
            return !namespace.equals(newNamespace);
        }).findFirst();
        if (result.isPresent()) {
            log.warn("Received invalid topic name: {}", (Object)result.get());
            return false;
        }
        HashSet<String> set = new HashSet<String>(topics);
        if (set.size() == topics.size()) {
            return true;
        }
        log.warn("Topic names not unique. unique/all : {}/{}", (Object)set.size(), (Object)topics.size());
        return false;
    }

    private void startReceivingMessages(List<ConsumerImpl<T>> newConsumers) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] startReceivingMessages for {} new consumers in topics consumer, state: {}", new Object[]{this.topic, newConsumers.size(), this.getState()});
        }
        if (this.getState() == HandlerState.State.Ready) {
            newConsumers.forEach(consumer -> {
                consumer.sendFlowPermitsToBroker(consumer.getConnectionHandler().cnx(), this.conf.getReceiverQueueSize());
                this.receiveMessageFromConsumer((ConsumerImpl<T>)consumer);
            });
        }
    }

    private void receiveMessageFromConsumer(ConsumerImpl<T> consumer) {
        consumer.receiveAsync().thenAccept(message -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Receive message from sub consumer:{}", new Object[]{this.topic, this.subscription, consumer.getTopic()});
            }
            this.messageReceived(consumer, (Message<T>)message);
            this.lock.writeLock().lock();
            try {
                int size = this.incomingMessages.size();
                if (size >= this.maxReceiverQueueSize || size > this.sharedQueueResumeThreshold && !this.pausedConsumers.isEmpty()) {
                    this.pausedConsumers.add(consumer);
                } else {
                    this.client.eventLoopGroup().execute(() -> this.receiveMessageFromConsumer(consumer));
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void messageReceived(ConsumerImpl<T> consumer, Message<T> message) {
        Preconditions.checkArgument(message instanceof MessageImpl);
        this.lock.writeLock().lock();
        try {
            TopicMessageImpl topicMessage = new TopicMessageImpl(consumer.getTopic(), consumer.getTopicNameWithoutPartition(), message);
            if (log.isDebugEnabled()) {
                log.debug("[{}][{}] Received message from topics-consumer {}", new Object[]{this.topic, this.subscription, message.getMessageId()});
            }
            if (!this.pendingReceives.isEmpty()) {
                CompletableFuture receivedFuture = (CompletableFuture)this.pendingReceives.poll();
                this.unAckedMessageTracker.add(topicMessage.getMessageId());
                this.listenerExecutor.execute(() -> receivedFuture.complete(topicMessage));
            } else if (this.enqueueMessageAndCheckBatchReceive(topicMessage) && this.hasPendingBatchReceive()) {
                this.notifyPendingBatchReceivedCallBack();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (this.listener != null) {
            this.listenerExecutor.execute(() -> {
                Message<T> msg;
                try {
                    msg = this.internalReceive();
                }
                catch (PulsarClientException e) {
                    log.warn("[{}] [{}] Failed to dequeue the message for listener", new Object[]{this.topic, this.subscription, e});
                    return;
                }
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}][{}] Calling message listener for message {}", new Object[]{this.topic, this.subscription, message.getMessageId()});
                    }
                    this.listener.received((Consumer)this, msg);
                }
                catch (Throwable t) {
                    log.error("[{}][{}] Message listener error in processing message: {}", new Object[]{this.topic, this.subscription, message, t});
                }
            });
        }
    }

    @Override
    protected synchronized void messageProcessed(Message<?> msg) {
        this.unAckedMessageTracker.add(msg.getMessageId());
        INCOMING_MESSAGES_SIZE_UPDATER.addAndGet(this, -msg.getData().length);
    }

    private void resumeReceivingFromPausedConsumersIfNeeded() {
        block5: {
            this.lock.readLock().lock();
            try {
                ConsumerImpl<T> consumer;
                if (this.incomingMessages.size() > this.sharedQueueResumeThreshold || this.pausedConsumers.isEmpty()) break block5;
                while ((consumer = this.pausedConsumers.poll()) != null) {
                    this.client.eventLoopGroup().execute(() -> this.receiveMessageFromConsumer(consumer));
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    @Override
    protected Message<T> internalReceive() throws PulsarClientException {
        try {
            Message message = (Message)this.incomingMessages.take();
            INCOMING_MESSAGES_SIZE_UPDATER.addAndGet(this, -message.getData().length);
            Preconditions.checkState(message instanceof TopicMessageImpl);
            this.unAckedMessageTracker.add(message.getMessageId());
            this.resumeReceivingFromPausedConsumersIfNeeded();
            return message;
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    @Override
    protected Message<T> internalReceive(int timeout, TimeUnit unit) throws PulsarClientException {
        try {
            Message message = (Message)this.incomingMessages.poll(timeout, unit);
            if (message != null) {
                INCOMING_MESSAGES_SIZE_UPDATER.addAndGet(this, -message.getData().length);
                Preconditions.checkArgument(message instanceof TopicMessageImpl);
                this.unAckedMessageTracker.add(message.getMessageId());
            }
            this.resumeReceivingFromPausedConsumersIfNeeded();
            return message;
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    @Override
    protected Messages<T> internalBatchReceive() throws PulsarClientException {
        try {
            return this.internalBatchReceiveAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            HandlerState.State state = this.getState();
            if (state != HandlerState.State.Closing && state != HandlerState.State.Closed) {
                this.stats.incrementNumBatchReceiveFailed();
                throw PulsarClientException.unwrap((Throwable)e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompletableFuture<Messages<T>> internalBatchReceiveAsync() {
        CompletableFuture result = new CompletableFuture();
        try {
            this.lock.writeLock().lock();
            if (this.pendingBatchReceives == null) {
                this.pendingBatchReceives = Queues.newConcurrentLinkedQueue();
            }
            if (this.hasEnoughMessagesForBatchReceive()) {
                MessagesImpl messages = this.getNewMessagesImpl();
                Message msgPeeked = (Message)this.incomingMessages.peek();
                while (msgPeeked != null && messages.canAdd(msgPeeked)) {
                    Message msg = (Message)this.incomingMessages.poll();
                    if (msg != null) {
                        INCOMING_MESSAGES_SIZE_UPDATER.addAndGet(this, -msg.getData().length);
                        Message interceptMsg = this.beforeConsume(msg);
                        messages.add(interceptMsg);
                    }
                    msgPeeked = (Message)this.incomingMessages.peek();
                }
                result.complete(messages);
            } else {
                this.pendingBatchReceives.add(ConsumerBase.OpBatchReceive.of(result));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompletableFuture<Message<T>> internalReceiveAsync() {
        CompletableFuture<Message<Message>> result = new CompletableFuture<Message<Message>>();
        try {
            this.lock.writeLock().lock();
            Message message = (Message)this.incomingMessages.poll(0L, TimeUnit.SECONDS);
            if (message == null) {
                this.pendingReceives.add(result);
            } else {
                INCOMING_MESSAGES_SIZE_UPDATER.addAndGet(this, -message.getData().length);
                Preconditions.checkState(message instanceof TopicMessageImpl);
                this.unAckedMessageTracker.add(message.getMessageId());
                this.resumeReceivingFromPausedConsumersIfNeeded();
                result.complete(message);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            result.completeExceptionally(new PulsarClientException((Throwable)e));
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return result;
    }

    @Override
    protected CompletableFuture<Void> doAcknowledge(MessageId messageId, PulsarApi.CommandAck.AckType ackType, Map<String, Long> properties, TransactionImpl txnImpl) {
        Preconditions.checkArgument(messageId instanceof TopicMessageIdImpl);
        TopicMessageIdImpl topicMessageId = (TopicMessageIdImpl)messageId;
        if (this.getState() != HandlerState.State.Ready) {
            return FutureUtil.failedFuture(new PulsarClientException("Consumer already closed"));
        }
        if (ackType == PulsarApi.CommandAck.AckType.Cumulative) {
            Consumer individualConsumer = this.consumers.get(topicMessageId.getTopicPartitionName());
            if (individualConsumer != null) {
                MessageId innerId = topicMessageId.getInnerMessageId();
                return individualConsumer.acknowledgeCumulativeAsync(innerId);
            }
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.NotConnectedException());
        }
        ConsumerImpl<T> consumer = this.consumers.get(topicMessageId.getTopicPartitionName());
        MessageId innerId = topicMessageId.getInnerMessageId();
        return consumer.doAcknowledgeWithTxn(innerId, ackType, properties, txnImpl).thenRun(() -> this.unAckedMessageTracker.remove(topicMessageId));
    }

    public void negativeAcknowledge(MessageId messageId) {
        Preconditions.checkArgument(messageId instanceof TopicMessageIdImpl);
        TopicMessageIdImpl topicMessageId = (TopicMessageIdImpl)messageId;
        ConsumerImpl<T> consumer = this.consumers.get(topicMessageId.getTopicPartitionName());
        consumer.negativeAcknowledge(topicMessageId.getInnerMessageId());
    }

    @Override
    public CompletableFuture<Void> unsubscribeAsync() {
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Topics Consumer was already closed"));
        }
        this.setState(HandlerState.State.Closing);
        CompletableFuture<Void> unsubscribeFuture = new CompletableFuture<Void>();
        List futureList = this.consumers.values().stream().map(c -> c.unsubscribeAsync()).collect(Collectors.toList());
        FutureUtil.waitForAll(futureList).whenComplete((r, ex) -> {
            if (ex == null) {
                this.setState(HandlerState.State.Closed);
                this.unAckedMessageTracker.close();
                unsubscribeFuture.complete(null);
                log.info("[{}] [{}] [{}] Unsubscribed Topics Consumer", new Object[]{this.topic, this.subscription, this.consumerName});
            } else {
                this.setState(HandlerState.State.Failed);
                unsubscribeFuture.completeExceptionally((Throwable)ex);
                log.error("[{}] [{}] [{}] Could not unsubscribe Topics Consumer", new Object[]{this.topic, this.subscription, this.consumerName, ex.getCause()});
            }
        });
        return unsubscribeFuture;
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            this.unAckedMessageTracker.close();
            return CompletableFuture.completedFuture(null);
        }
        this.setState(HandlerState.State.Closing);
        if (this.partitionsAutoUpdateTimeout != null) {
            this.partitionsAutoUpdateTimeout.cancel();
            this.partitionsAutoUpdateTimeout = null;
        }
        CompletableFuture<Void> closeFuture = new CompletableFuture<Void>();
        List futureList = this.consumers.values().stream().map(c -> c.closeAsync()).collect(Collectors.toList());
        FutureUtil.waitForAll(futureList).whenComplete((r, ex) -> {
            if (ex == null) {
                this.setState(HandlerState.State.Closed);
                this.unAckedMessageTracker.close();
                closeFuture.complete(null);
                log.info("[{}] [{}] Closed Topics Consumer", (Object)this.topic, (Object)this.subscription);
                this.client.cleanupConsumer(this);
                this.failPendingReceive();
            } else {
                this.setState(HandlerState.State.Failed);
                closeFuture.completeExceptionally((Throwable)ex);
                log.error("[{}] [{}] Could not close Topics Consumer", new Object[]{this.topic, this.subscription, ex.getCause()});
            }
        });
        return closeFuture;
    }

    private void failPendingReceive() {
        this.lock.readLock().lock();
        try {
            if (this.listenerExecutor != null && !this.listenerExecutor.isShutdown()) {
                CompletableFuture receiveFuture;
                while (!this.pendingReceives.isEmpty() && (receiveFuture = (CompletableFuture)this.pendingReceives.poll()) != null) {
                    receiveFuture.completeExceptionally((Throwable)new PulsarClientException.AlreadyClosedException("Consumer is already closed"));
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isConnected() {
        return this.consumers.values().stream().allMatch(consumer -> consumer.isConnected());
    }

    @Override
    String getHandlerName() {
        return this.subscription;
    }

    private ConsumerConfigurationData<T> getInternalConsumerConfig() {
        Object internalConsumerConfig = this.conf.clone();
        ((ConsumerConfigurationData)internalConsumerConfig).setSubscriptionName(this.subscription);
        ((ConsumerConfigurationData)internalConsumerConfig).setConsumerName(this.consumerName);
        ((ConsumerConfigurationData)internalConsumerConfig).setMessageListener(null);
        return internalConsumerConfig;
    }

    public void redeliverUnacknowledgedMessages() {
        this.lock.writeLock().lock();
        try {
            this.consumers.values().stream().forEach(consumer -> consumer.redeliverUnacknowledgedMessages());
            this.incomingMessages.clear();
            INCOMING_MESSAGES_SIZE_UPDATER.set(this, 0L);
            this.unAckedMessageTracker.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.resumeReceivingFromPausedConsumersIfNeeded();
    }

    @Override
    public void redeliverUnacknowledgedMessages(Set<MessageId> messageIds) {
        if (messageIds.isEmpty()) {
            return;
        }
        Preconditions.checkArgument(messageIds.stream().findFirst().get() instanceof TopicMessageIdImpl);
        if (this.conf.getSubscriptionType() != SubscriptionType.Shared) {
            this.redeliverUnacknowledgedMessages();
            return;
        }
        this.removeExpiredMessagesFromQueue(messageIds);
        messageIds.stream().map(messageId -> (TopicMessageIdImpl)messageId).collect(Collectors.groupingBy(TopicMessageIdImpl::getTopicPartitionName, Collectors.toSet())).forEach((topicName, messageIds1) -> this.consumers.get(topicName).redeliverUnacknowledgedMessages(messageIds1.stream().map(mid -> mid.getInnerMessageId()).collect(Collectors.toSet())));
        this.resumeReceivingFromPausedConsumersIfNeeded();
    }

    @Override
    protected void completeOpBatchReceive(ConsumerBase.OpBatchReceive<T> op) {
        this.notifyPendingBatchReceivedCallBack(op);
        this.resumeReceivingFromPausedConsumersIfNeeded();
    }

    public void seek(MessageId messageId) throws PulsarClientException {
        try {
            this.seekAsync(messageId).get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public void seek(long timestamp) throws PulsarClientException {
        try {
            this.seekAsync(timestamp).get();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CompletableFuture<Void> seekAsync(MessageId messageId) {
        return FutureUtil.failedFuture(new PulsarClientException("Seek operation not supported on topics consumer"));
    }

    public CompletableFuture<Void> seekAsync(long timestamp) {
        ArrayList futures = new ArrayList(this.consumers.size());
        this.consumers.values().forEach(consumer -> futures.add(consumer.seekAsync(timestamp)));
        return FutureUtil.waitForAll(futures);
    }

    @Override
    public int getAvailablePermits() {
        return this.consumers.values().stream().mapToInt(ConsumerImpl::getAvailablePermits).sum();
    }

    public boolean hasReachedEndOfTopic() {
        return this.consumers.values().stream().allMatch(Consumer::hasReachedEndOfTopic);
    }

    @Override
    public int numMessagesInQueue() {
        return this.incomingMessages.size() + this.consumers.values().stream().mapToInt(ConsumerImpl::numMessagesInQueue).sum();
    }

    public synchronized ConsumerStats getStats() {
        if (this.stats == null) {
            return null;
        }
        this.stats.reset();
        this.consumers.values().stream().forEach(consumer -> this.stats.updateCumulativeStats(consumer.getStats()));
        return this.stats;
    }

    public UnAckedMessageTracker getUnAckedMessageTracker() {
        return this.unAckedMessageTracker;
    }

    private void removeExpiredMessagesFromQueue(Set<MessageId> messageIds) {
        Message peek = (Message)this.incomingMessages.peek();
        if (peek != null) {
            if (!messageIds.contains(peek.getMessageId())) {
                return;
            }
            Message message = (Message)this.incomingMessages.poll();
            Preconditions.checkState(message instanceof TopicMessageImpl);
            while (message != null) {
                INCOMING_MESSAGES_SIZE_UPDATER.addAndGet(this, -message.getData().length);
                MessageId messageId = message.getMessageId();
                if (!messageIds.contains(messageId)) {
                    messageIds.add(messageId);
                    break;
                }
                message = (Message)this.incomingMessages.poll();
            }
        }
    }

    private boolean topicNameValid(String topicName) {
        Preconditions.checkArgument(TopicName.isValid(topicName), "Invalid topic name:" + topicName);
        Preconditions.checkArgument(!this.topics.containsKey(topicName), "Topics already contains topic:" + topicName);
        if (this.namespaceName != null) {
            Preconditions.checkArgument(TopicName.get(topicName).getNamespace().toString().equals(this.namespaceName.toString()), "Topic " + topicName + " not in same namespace with Topics");
        }
        return true;
    }

    public CompletableFuture<Void> subscribeAsync(String topicName, boolean createTopicIfDoesNotExist) {
        if (!this.topicNameValid(topicName)) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Topic name not valid"));
        }
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Topics Consumer was already closed"));
        }
        CompletableFuture<Void> subscribeResult = new CompletableFuture<Void>();
        ((CompletableFuture)this.client.getPartitionedTopicMetadata(topicName).thenAccept(metadata -> this.subscribeTopicPartitions(subscribeResult, topicName, metadata.partitions, createTopicIfDoesNotExist))).exceptionally(ex1 -> {
            log.warn("[{}] Failed to get partitioned topic metadata: {}", (Object)topicName, (Object)ex1.getMessage());
            subscribeResult.completeExceptionally((Throwable)ex1);
            return null;
        });
        return subscribeResult;
    }

    public static <T> MultiTopicsConsumerImpl<T> createPartitionedConsumer(PulsarClientImpl client, ConsumerConfigurationData<T> conf, ExecutorService listenerExecutor, CompletableFuture<Consumer<T>> subscribeFuture, int numPartitions, Schema<T> schema, ConsumerInterceptors<T> interceptors) {
        Preconditions.checkArgument(conf.getTopicNames().size() == 1, "Should have only 1 topic for partitioned consumer");
        Object cloneConf = conf.clone();
        String topicName = ((ConsumerConfigurationData)cloneConf).getSingleTopic();
        ((ConsumerConfigurationData)cloneConf).getTopicNames().remove(topicName);
        CompletableFuture<Consumer<T>> future = new CompletableFuture<Consumer<T>>();
        MultiTopicsConsumerImpl consumer = new MultiTopicsConsumerImpl(client, topicName, cloneConf, listenerExecutor, future, schema, interceptors, true);
        ((CompletableFuture)((CompletableFuture)future.thenCompose(c -> ((MultiTopicsConsumerImpl)c).subscribeAsync(topicName, numPartitions))).thenRun(() -> subscribeFuture.complete(consumer))).exceptionally(e -> {
            log.warn("Failed subscription for createPartitionedConsumer: {} {}, e:{}", new Object[]{topicName, numPartitions, e});
            subscribeFuture.completeExceptionally(PulsarClientException.wrap((Throwable)((Throwable)e).getCause(), (String)String.format("Failed to subscribe %s with %d partitions", topicName, numPartitions)));
            return null;
        });
        return consumer;
    }

    private CompletableFuture<Void> subscribeAsync(String topicName, int numberPartitions) {
        if (!this.topicNameValid(topicName)) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Topic name not valid"));
        }
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Topics Consumer was already closed"));
        }
        CompletableFuture<Void> subscribeResult = new CompletableFuture<Void>();
        this.subscribeTopicPartitions(subscribeResult, topicName, numberPartitions, true);
        return subscribeResult;
    }

    private void subscribeTopicPartitions(CompletableFuture<Void> subscribeResult, String topicName, int numPartitions, boolean createIfDoesNotExist) {
        this.client.preProcessSchemaBeforeSubscribe(this.client, this.schema, topicName).whenComplete((schema, cause) -> {
            if (null == cause) {
                this.doSubscribeTopicPartitions((Schema<T>)schema, subscribeResult, topicName, numPartitions, createIfDoesNotExist);
            } else {
                subscribeResult.completeExceptionally((Throwable)cause);
            }
        });
    }

    private void doSubscribeTopicPartitions(Schema<T> schema, CompletableFuture<Void> subscribeResult, String topicName, int numPartitions, boolean createIfDoesNotExist) {
        List<CompletableFuture<Object>> futureList;
        if (log.isDebugEnabled()) {
            log.debug("Subscribe to topic {} metadata.partitions: {}", (Object)topicName, (Object)numPartitions);
        }
        if (numPartitions > 0) {
            this.topics.putIfAbsent(topicName, numPartitions);
            this.allTopicPartitionsNumber.addAndGet(numPartitions);
            int receiverQueueSize = Math.min(this.conf.getReceiverQueueSize(), this.conf.getMaxTotalReceiverQueueSizeAcrossPartitions() / numPartitions);
            ConsumerConfigurationData<T> configurationData = this.getInternalConsumerConfig();
            configurationData.setReceiverQueueSize(receiverQueueSize);
            futureList = IntStream.range(0, numPartitions).mapToObj(partitionIndex -> {
                String partitionName = TopicName.get(topicName).getPartition(partitionIndex).toString();
                CompletableFuture subFuture = new CompletableFuture();
                ConsumerImpl newConsumer = ConsumerImpl.newConsumerImpl(this.client, partitionName, configurationData, this.client.externalExecutorProvider().getExecutor(), partitionIndex, true, subFuture, null, schema, this.interceptors, createIfDoesNotExist);
                this.consumers.putIfAbsent(newConsumer.getTopic(), newConsumer);
                return subFuture;
            }).collect(Collectors.toList());
        } else {
            this.topics.putIfAbsent(topicName, 1);
            this.allTopicPartitionsNumber.incrementAndGet();
            CompletableFuture subFuture = new CompletableFuture();
            ConsumerImpl<T> newConsumer = ConsumerImpl.newConsumerImpl(this.client, topicName, this.internalConfig, this.client.externalExecutorProvider().getExecutor(), -1, true, subFuture, null, schema, this.interceptors, createIfDoesNotExist);
            this.consumers.putIfAbsent(newConsumer.getTopic(), newConsumer);
            futureList = Collections.singletonList(subFuture);
        }
        ((CompletableFuture)FutureUtil.waitForAll(futureList).thenAccept(finalFuture -> {
            if (this.allTopicPartitionsNumber.get() > this.maxReceiverQueueSize) {
                this.setMaxReceiverQueueSize(this.allTopicPartitionsNumber.get());
            }
            int numTopics = this.topics.values().stream().mapToInt(Integer::intValue).sum();
            Preconditions.checkState(this.allTopicPartitionsNumber.get() == numTopics, "allTopicPartitionsNumber " + this.allTopicPartitionsNumber.get() + " not equals expected: " + numTopics);
            this.startReceivingMessages(this.consumers.values().stream().filter(consumer1 -> {
                String consumerTopicName = consumer1.getTopic();
                return TopicName.get(consumerTopicName).getPartitionedTopicName().equals(TopicName.get(topicName).getPartitionedTopicName().toString());
            }).collect(Collectors.toList()));
            subscribeResult.complete(null);
            log.info("[{}] [{}] Success subscribe new topic {} in topics consumer, partitions: {}, allTopicPartitionsNumber: {}", new Object[]{this.topic, this.subscription, topicName, numPartitions, this.allTopicPartitionsNumber.get()});
            if (this.namespaceName == null) {
                this.namespaceName = TopicName.get(topicName).getNamespaceObject();
            }
        })).exceptionally(ex -> {
            this.handleSubscribeOneTopicError(topicName, (Throwable)ex, subscribeResult);
            return null;
        });
    }

    private void handleSubscribeOneTopicError(String topicName, Throwable error, CompletableFuture<Void> subscribeFuture) {
        log.warn("[{}] Failed to subscribe for topic [{}] in topics consumer {}", new Object[]{this.topic, topicName, error.getMessage()});
        this.client.externalExecutorProvider().getExecutor().submit(() -> {
            AtomicInteger toCloseNum = new AtomicInteger(0);
            this.consumers.values().stream().filter(consumer1 -> {
                String consumerTopicName = consumer1.getTopic();
                if (TopicName.get(consumerTopicName).getPartitionedTopicName().equals(topicName)) {
                    toCloseNum.incrementAndGet();
                    return true;
                }
                return false;
            }).collect(Collectors.toList()).forEach(consumer2 -> consumer2.closeAsync().whenComplete((r, ex) -> {
                consumer2.subscribeFuture().completeExceptionally(error);
                this.allTopicPartitionsNumber.decrementAndGet();
                this.consumers.remove(consumer2.getTopic());
                if (toCloseNum.decrementAndGet() == 0) {
                    log.warn("[{}] Failed to subscribe for topic [{}] in topics consumer, subscribe error: {}", new Object[]{this.topic, topicName, error.getMessage()});
                    this.topics.remove(topicName);
                    Preconditions.checkState(this.allTopicPartitionsNumber.get() == this.consumers.values().size());
                    subscribeFuture.completeExceptionally(error);
                }
            }));
        });
    }

    public CompletableFuture<Void> unsubscribeAsync(String topicName) {
        Preconditions.checkArgument(TopicName.isValid(topicName), "Invalid topic name:" + topicName);
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Topics Consumer was already closed"));
        }
        if (this.partitionsAutoUpdateTimeout != null) {
            this.partitionsAutoUpdateTimeout.cancel();
            this.partitionsAutoUpdateTimeout = null;
        }
        CompletableFuture<Void> unsubscribeFuture = new CompletableFuture<Void>();
        String topicPartName = TopicName.get(topicName).getPartitionedTopicName();
        List consumersToUnsub = this.consumers.values().stream().filter(consumer -> {
            String consumerTopicName = consumer.getTopic();
            return TopicName.get(consumerTopicName).getPartitionedTopicName().equals(topicPartName);
        }).collect(Collectors.toList());
        List futureList = consumersToUnsub.stream().map(ConsumerImpl::unsubscribeAsync).collect(Collectors.toList());
        FutureUtil.waitForAll(futureList).whenComplete((r, ex) -> {
            if (ex == null) {
                consumersToUnsub.forEach(consumer1 -> {
                    this.consumers.remove(consumer1.getTopic());
                    this.pausedConsumers.remove(consumer1);
                    this.allTopicPartitionsNumber.decrementAndGet();
                });
                this.topics.remove(topicName);
                ((UnAckedTopicMessageTracker)this.unAckedMessageTracker).removeTopicMessages(topicName);
                unsubscribeFuture.complete(null);
                log.info("[{}] [{}] [{}] Unsubscribed Topics Consumer, allTopicPartitionsNumber: {}", new Object[]{topicName, this.subscription, this.consumerName, this.allTopicPartitionsNumber});
            } else {
                unsubscribeFuture.completeExceptionally((Throwable)ex);
                this.setState(HandlerState.State.Failed);
                log.error("[{}] [{}] [{}] Could not unsubscribe Topics Consumer", new Object[]{topicName, this.subscription, this.consumerName, ex.getCause()});
            }
        });
        return unsubscribeFuture;
    }

    public CompletableFuture<Void> removeConsumerAsync(String topicName) {
        Preconditions.checkArgument(TopicName.isValid(topicName), "Invalid topic name:" + topicName);
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Topics Consumer was already closed"));
        }
        CompletableFuture<Void> unsubscribeFuture = new CompletableFuture<Void>();
        String topicPartName = TopicName.get(topicName).getPartitionedTopicName();
        List consumersToClose = this.consumers.values().stream().filter(consumer -> {
            String consumerTopicName = consumer.getTopic();
            return TopicName.get(consumerTopicName).getPartitionedTopicName().equals(topicPartName);
        }).collect(Collectors.toList());
        List futureList = consumersToClose.stream().map(ConsumerImpl::closeAsync).collect(Collectors.toList());
        FutureUtil.waitForAll(futureList).whenComplete((r, ex) -> {
            if (ex == null) {
                consumersToClose.forEach(consumer1 -> {
                    this.consumers.remove(consumer1.getTopic());
                    this.pausedConsumers.remove(consumer1);
                    this.allTopicPartitionsNumber.decrementAndGet();
                });
                this.topics.remove(topicName);
                ((UnAckedTopicMessageTracker)this.unAckedMessageTracker).removeTopicMessages(topicName);
                unsubscribeFuture.complete(null);
                log.info("[{}] [{}] [{}] Removed Topics Consumer, allTopicPartitionsNumber: {}", new Object[]{topicName, this.subscription, this.consumerName, this.allTopicPartitionsNumber});
            } else {
                unsubscribeFuture.completeExceptionally((Throwable)ex);
                this.setState(HandlerState.State.Failed);
                log.error("[{}] [{}] [{}] Could not remove Topics Consumer", new Object[]{topicName, this.subscription, this.consumerName, ex.getCause()});
            }
        });
        return unsubscribeFuture;
    }

    public List<String> getTopics() {
        return this.topics.keySet().stream().collect(Collectors.toList());
    }

    public List<String> getPartitionedTopics() {
        return this.consumers.keySet().stream().collect(Collectors.toList());
    }

    public List<ConsumerImpl<T>> getConsumers() {
        return this.consumers.values().stream().collect(Collectors.toList());
    }

    public void pause() {
        this.consumers.forEach((name, consumer) -> consumer.pause());
    }

    public void resume() {
        this.consumers.forEach((name, consumer) -> consumer.resume());
    }

    private CompletableFuture<Void> subscribeIncreasedTopicPartitions(String topicName) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.client.getPartitionsForTopic(topicName).thenCompose(list -> {
            int oldPartitionNumber = this.topics.get(topicName.toString());
            int currentPartitionNumber = list.size();
            if (log.isDebugEnabled()) {
                log.debug("[{}] partitions number. old: {}, new: {}", new Object[]{topicName.toString(), oldPartitionNumber, currentPartitionNumber});
            }
            if (oldPartitionNumber == currentPartitionNumber) {
                future.complete(null);
                return future;
            }
            if (oldPartitionNumber < currentPartitionNumber) {
                List newPartitions = list.subList(oldPartitionNumber, currentPartitionNumber);
                List futureList = newPartitions.stream().map(partitionName -> {
                    int partitionIndex = TopicName.getPartitionIndex(partitionName);
                    CompletableFuture subFuture = new CompletableFuture();
                    ConsumerConfigurationData<T> configurationData = this.getInternalConsumerConfig();
                    ConsumerImpl<T> newConsumer = ConsumerImpl.newConsumerImpl(this.client, partitionName, configurationData, this.client.externalExecutorProvider().getExecutor(), partitionIndex, true, subFuture, null, this.schema, this.interceptors, true);
                    this.consumers.putIfAbsent(newConsumer.getTopic(), newConsumer);
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] create consumer {} for partitionName: {}", new Object[]{topicName.toString(), newConsumer.getTopic(), partitionName});
                    }
                    return subFuture;
                }).collect(Collectors.toList());
                ((CompletableFuture)FutureUtil.waitForAll(futureList).thenAccept(finalFuture -> {
                    List<ConsumerImpl<T>> newConsumerList = newPartitions.stream().map(partitionTopic -> this.consumers.get(partitionTopic)).collect(Collectors.toList());
                    this.startReceivingMessages(newConsumerList);
                    future.complete(null);
                })).exceptionally(ex -> {
                    log.warn("[{}] Failed to subscribe {} partition: {} - {}", new Object[]{this.topic, topicName.toString(), oldPartitionNumber, currentPartitionNumber, ex.getMessage()});
                    future.completeExceptionally((Throwable)ex);
                    return null;
                });
            } else {
                log.error("[{}] not support shrink topic partitions. old: {}, new: {}", new Object[]{topicName.toString(), oldPartitionNumber, currentPartitionNumber});
                future.completeExceptionally((Throwable)new PulsarClientException.NotSupportedException("not support shrink topic partitions"));
            }
            return future;
        });
        return future;
    }

    @VisibleForTesting
    public Timeout getPartitionsAutoUpdateTimeout() {
        return this.partitionsAutoUpdateTimeout;
    }

    @Override
    public CompletableFuture<MessageId> getLastMessageIdAsync() {
        CompletableFuture<MessageId> returnFuture = new CompletableFuture<MessageId>();
        Map<String, CompletableFuture> messageIdFutures = this.consumers.entrySet().stream().map(entry -> Pair.of(entry.getKey(), ((ConsumerImpl)entry.getValue()).getLastMessageIdAsync())).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        CompletableFuture.allOf((CompletableFuture[])messageIdFutures.entrySet().stream().map(Map.Entry::getValue).toArray(CompletableFuture[]::new)).whenComplete((ignore, ex) -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            messageIdFutures.forEach((key, future) -> {
                MessageId messageId;
                try {
                    messageId = (MessageId)future.get();
                }
                catch (Exception e) {
                    log.warn("[{}] Exception when topic {} getLastMessageId.", key, (Object)e);
                    messageId = MessageId.earliest;
                }
                builder.put(key, messageId);
            });
            returnFuture.complete(new MultiMessageIdImpl(builder.build()));
        });
        return returnFuture;
    }

    private class TopicsPartitionChangedListener
    implements PartitionsChangedListener {
        private TopicsPartitionChangedListener() {
        }

        @Override
        public CompletableFuture<Void> onTopicsExtended(Collection<String> topicsExtended) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            if (topicsExtended.isEmpty()) {
                future.complete(null);
                return future;
            }
            if (log.isDebugEnabled()) {
                log.debug("[{}]  run onTopicsExtended: {}, size: {}", new Object[]{MultiTopicsConsumerImpl.this.topic, topicsExtended.toString(), topicsExtended.size()});
            }
            ArrayList futureList = Lists.newArrayListWithExpectedSize(topicsExtended.size());
            topicsExtended.forEach(topic -> futureList.add(MultiTopicsConsumerImpl.this.subscribeIncreasedTopicPartitions(topic)));
            ((CompletableFuture)FutureUtil.waitForAll(futureList).thenAccept(finalFuture -> future.complete(null))).exceptionally(ex -> {
                log.warn("[{}] Failed to subscribe increased topics partitions: {}", (Object)MultiTopicsConsumerImpl.this.topic, (Object)ex.getMessage());
                future.completeExceptionally((Throwable)ex);
                return null;
            });
            return future;
        }
    }
}

