/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import io.quarkus.runtime.configuration.ConfigExpander;
import io.quarkus.runtime.configuration.ExpandingConfigSource;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;

final class Substitutions {
    static final FastThreadLocalInt depth = FastThreadLocalFactory.createInt();
    static final FastThreadLocalInt notExpanding = FastThreadLocalFactory.createInt();

    Substitutions() {
    }

    @TargetClass(value=ExpandingConfigSource.class)
    static final class Target_ExpandingConfigSource {
        @Delete
        private static ThreadLocal<Boolean> NO_EXPAND;

        Target_ExpandingConfigSource() {
        }

        @Substitute
        private static boolean isExpanding() {
            return notExpanding.get() == 0;
        }

        @Substitute
        public static boolean setExpanding(boolean newValue) {
            boolean bl;
            try {
                bl = notExpanding.get() == 0;
                notExpanding.set(newValue ? 0 : 1);
            }
            catch (Throwable throwable) {
                notExpanding.set(newValue ? 0 : 1);
                throw throwable;
            }
            return bl;
        }
    }

    @TargetClass(value=ConfigProviderResolver.class)
    static final class Target_ConfigurationProviderResolver {
        @Alias
        @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
        private static volatile ConfigProviderResolver instance;

        Target_ConfigurationProviderResolver() {
        }
    }

    @TargetClass(value=ConfigExpander.class)
    static final class Target_ConfigExpander {
        @Delete
        @TargetElement(name="depth")
        static ThreadLocal<int[]> origDepth = null;

        Target_ConfigExpander() {
        }

        @Substitute
        private static boolean enter() {
            int val = depth.get();
            if (val == 32) {
                return false;
            }
            depth.set(val + 1);
            return true;
        }

        @Substitute
        private static void exit() {
            depth.set(depth.get() - 1);
        }
    }
}

