/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.Produces;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.sse.SseEventSink;
import org.jboss.resteasy.annotations.Stream;
import org.jboss.resteasy.core.AsyncResponseConsumer;
import org.jboss.resteasy.core.CompletionStageHolder;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.core.MessageBodyParameterInjector;
import org.jboss.resteasy.core.PostResourceMethodInvokers;
import org.jboss.resteasy.core.ResourceMethodInvokerAwareResponse;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.interception.jaxrs.PostMatchContainerRequestContext;
import org.jboss.resteasy.core.providerfactory.ResteasyProviderFactoryImpl;
import org.jboss.resteasy.plugins.server.resourcefactory.SingletonResource;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.specimpl.BuiltResponseEntityNotBacked;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.AsyncResponseProvider;
import org.jboss.resteasy.spi.AsyncStreamProvider;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.MethodInjector;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResourceInvoker;
import org.jboss.resteasy.spi.ResteasyAsynchronousResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.UnhandledException;
import org.jboss.resteasy.spi.ValueInjector;
import org.jboss.resteasy.spi.interception.JaxrsInterceptorRegistry;
import org.jboss.resteasy.spi.interception.JaxrsInterceptorRegistryListener;
import org.jboss.resteasy.spi.metadata.MethodParameter;
import org.jboss.resteasy.spi.metadata.Parameter;
import org.jboss.resteasy.spi.metadata.ResourceLocator;
import org.jboss.resteasy.spi.metadata.ResourceMethod;
import org.jboss.resteasy.spi.statistics.MethodStatisticsLogger;
import org.jboss.resteasy.spi.validation.GeneralValidator;
import org.jboss.resteasy.spi.validation.GeneralValidatorCDI;
import org.jboss.resteasy.statistics.StatisticsControllerImpl;
import org.jboss.resteasy.tracing.RESTEasyTracingLogger;
import org.jboss.resteasy.util.DynamicFeatureContextDelegate;

public class ResourceMethodInvoker
implements ResourceInvoker,
JaxrsInterceptorRegistryListener {
    protected MethodInjector methodInjector;
    protected InjectorFactory injector;
    protected ResourceFactory resource;
    protected ResteasyProviderFactory parentProviderFactory;
    protected ResteasyProviderFactory resourceMethodProviderFactory;
    protected ResourceMethod method;
    protected Annotation[] methodAnnotations;
    protected ContainerRequestFilter[] requestFilters;
    protected ContainerResponseFilter[] responseFilters;
    protected WriterInterceptor[] writerInterceptors;
    protected ConcurrentHashMap<String, AtomicLong> stats = new ConcurrentHashMap();
    protected GeneralValidator validator;
    protected boolean isValidatable;
    protected boolean methodIsValidatable;
    protected AsyncResponseProvider asyncResponseProvider;
    AsyncStreamProvider asyncStreamProvider;
    protected boolean isSse;
    protected ResourceInfo resourceInfo;
    protected boolean expectsBody;
    protected final boolean hasProduces;
    protected MethodStatisticsLogger methodStatisticsLogger;

    public ResourceMethodInvoker(ResourceMethod method, InjectorFactory injector, ResourceFactory resource, ResteasyProviderFactory providerFactory) {
        this.injector = injector;
        this.resource = resource;
        this.parentProviderFactory = providerFactory;
        this.method = method;
        this.methodAnnotations = this.method.getAnnotatedMethod().getAnnotations();
        StatisticsControllerImpl cfr_ignored_0 = (StatisticsControllerImpl)providerFactory.getStatisticsController();
        this.methodStatisticsLogger = StatisticsControllerImpl.EMPTY;
        this.resourceInfo = new ResourceInfo(){

            public Method getResourceMethod() {
                return ResourceMethodInvoker.this.method.getAnnotatedMethod();
            }

            public Class<?> getResourceClass() {
                return ResourceMethodInvoker.this.method.getResourceClass().getClazz();
            }
        };
        Set serverDynamicFeatures = providerFactory.getServerDynamicFeatures();
        if (serverDynamicFeatures != null && !serverDynamicFeatures.isEmpty()) {
            this.resourceMethodProviderFactory = new ResteasyProviderFactoryImpl(RuntimeType.SERVER, providerFactory);
            for (DynamicFeature feature : serverDynamicFeatures) {
                feature.configure(this.resourceInfo, (FeatureContext)new DynamicFeatureContextDelegate((Configurable<?>)this.resourceMethodProviderFactory));
            }
            ((ResteasyProviderFactoryImpl)this.resourceMethodProviderFactory).lockSnapshots();
        } else {
            this.resourceMethodProviderFactory = providerFactory;
        }
        this.methodInjector = injector.createMethodInjector((ResourceLocator)method, this.resourceMethodProviderFactory);
        this.expectsBody = this.methodInjector.expectsBody();
        this.requestFilters = (ContainerRequestFilter[])this.resourceMethodProviderFactory.getContainerRequestFilterRegistry().postMatch(method.getResourceClass().getClazz(), (AccessibleObject)method.getAnnotatedMethod());
        this.responseFilters = (ContainerResponseFilter[])this.resourceMethodProviderFactory.getContainerResponseFilterRegistry().postMatch(method.getResourceClass().getClazz(), (AccessibleObject)method.getAnnotatedMethod());
        this.writerInterceptors = (WriterInterceptor[])this.resourceMethodProviderFactory.getServerWriterInterceptorRegistry().postMatch(method.getResourceClass().getClazz(), (AccessibleObject)method.getAnnotatedMethod());
        providerFactory.getContainerRequestFilterRegistry().getListeners().add(this);
        providerFactory.getContainerResponseFilterRegistry().getListeners().add(this);
        providerFactory.getServerWriterInterceptorRegistry().getListeners().add(this);
        ContextResolver resolver = providerFactory.getContextResolver(GeneralValidator.class, MediaType.WILDCARD_TYPE);
        if (resolver != null) {
            this.validator = (GeneralValidator)providerFactory.getContextResolver(GeneralValidator.class, MediaType.WILDCARD_TYPE).getContext(null);
        }
        if (this.validator != null) {
            this.isValidatable = this.validator instanceof GeneralValidatorCDI ? ((GeneralValidatorCDI)GeneralValidatorCDI.class.cast(this.validator)).isValidatable(this.getMethod().getDeclaringClass(), injector) : this.validator.isValidatable(this.getMethod().getDeclaringClass());
            this.methodIsValidatable = this.validator.isMethodValidatable(this.getMethod());
        }
        this.asyncResponseProvider = this.resourceMethodProviderFactory.getAsyncResponseProvider(method.getReturnType());
        if (this.asyncResponseProvider == null) {
            this.asyncStreamProvider = this.resourceMethodProviderFactory.getAsyncStreamProvider(method.getReturnType());
        }
        if (this.isSseResourceMethod(method)) {
            this.isSse = true;
            method.markAsynchronous();
        }
        this.hasProduces = method.getMethod().isAnnotationPresent(Produces.class) || method.getMethod().getClass().isAnnotationPresent(Produces.class);
    }

    public boolean hasProduces() {
        return this.hasProduces;
    }

    private boolean isSseResourceMethod(ResourceMethod resourceMethod) {
        boolean onlyProduceServerSentEventsMediaType;
        MediaType[] producedMediaTypes = resourceMethod.getProduces();
        boolean bl = onlyProduceServerSentEventsMediaType = producedMediaTypes != null && producedMediaTypes.length == 1 && MediaType.SERVER_SENT_EVENTS_TYPE.isCompatible(producedMediaTypes[0]);
        if (!onlyProduceServerSentEventsMediaType) {
            return false;
        }
        MethodParameter[] resourceMethodParameters = resourceMethod.getParams();
        if (resourceMethodParameters != null) {
            for (MethodParameter methodParameter : resourceMethodParameters) {
                if (!Parameter.ParamType.CONTEXT.equals((Object)methodParameter.getParamType()) || !SseEventSink.class.equals((Object)methodParameter.getType())) continue;
                return true;
            }
        }
        if (this.asyncStreamProvider != null) {
            for (Annotation annotation : resourceMethod.getAnnotatedMethod().getAnnotations()) {
                if (annotation.annotationType() != Stream.class) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void cleanup() {
        this.parentProviderFactory.getContainerRequestFilterRegistry().getListeners().remove(this);
        this.parentProviderFactory.getContainerResponseFilterRegistry().getListeners().remove(this);
        this.parentProviderFactory.getServerWriterInterceptorRegistry().getListeners().remove(this);
        for (ValueInjector param : this.methodInjector.getParams()) {
            if (!(param instanceof MessageBodyParameterInjector)) continue;
            this.parentProviderFactory.getServerReaderInterceptorRegistry().getListeners().remove(param);
        }
    }

    public void registryUpdated(JaxrsInterceptorRegistry registry, JaxrsInterceptorRegistry.InterceptorFactory factory) {
        if (registry.getIntf().equals(WriterInterceptor.class)) {
            JaxrsInterceptorRegistry serverWriterInterceptorRegistry = this.resourceMethodProviderFactory.getServerWriterInterceptorRegistry();
            if (registry != serverWriterInterceptorRegistry) {
                serverWriterInterceptorRegistry.register(factory);
            }
            this.writerInterceptors = (WriterInterceptor[])serverWriterInterceptorRegistry.postMatch(this.method.getResourceClass().getClazz(), (AccessibleObject)this.method.getAnnotatedMethod());
        } else if (registry.getIntf().equals(ContainerRequestFilter.class)) {
            JaxrsInterceptorRegistry containerRequestFilterRegistry = this.resourceMethodProviderFactory.getContainerRequestFilterRegistry();
            if (registry != containerRequestFilterRegistry) {
                containerRequestFilterRegistry.register(factory);
            }
            this.requestFilters = (ContainerRequestFilter[])containerRequestFilterRegistry.postMatch(this.method.getResourceClass().getClazz(), (AccessibleObject)this.method.getAnnotatedMethod());
        } else if (registry.getIntf().equals(ContainerResponseFilter.class)) {
            JaxrsInterceptorRegistry containerResponseFilterRegistry = this.resourceMethodProviderFactory.getContainerResponseFilterRegistry();
            if (registry != containerResponseFilterRegistry) {
                containerResponseFilterRegistry.register(factory);
            }
            this.responseFilters = (ContainerResponseFilter[])containerResponseFilterRegistry.postMatch(this.method.getResourceClass().getClazz(), (AccessibleObject)this.method.getAnnotatedMethod());
        }
    }

    protected void incrementMethodCount(String httpMethod) {
        AtomicLong old;
        AtomicLong stat = this.stats.get(httpMethod);
        if (stat == null && (old = this.stats.putIfAbsent(httpMethod, stat = new AtomicLong())) != null) {
            stat = old;
        }
        stat.incrementAndGet();
    }

    public Map<String, AtomicLong> getStats() {
        return this.stats;
    }

    public ContainerRequestFilter[] getRequestFilters() {
        return this.requestFilters;
    }

    public ContainerResponseFilter[] getResponseFilters() {
        return this.responseFilters;
    }

    public WriterInterceptor[] getWriterInterceptors() {
        return this.writerInterceptors;
    }

    public Type getGenericReturnType() {
        return this.method.getGenericReturnType();
    }

    public Class<?> getResourceClass() {
        return this.method.getResourceClass().getClazz();
    }

    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    public Annotation[] getMethodAnnotations() {
        return this.methodAnnotations;
    }

    public Method getMethod() {
        return this.method.getMethod();
    }

    public CompletionStage<Object> invokeDryRun(HttpRequest request, HttpResponse response) {
        Object resource = this.resource.createResource(request, response, this.resourceMethodProviderFactory);
        if (resource instanceof CompletionStage) {
            CompletionStage stage = (CompletionStage)resource;
            return stage.thenCompose(target -> this.invokeDryRun(request, response, target));
        }
        return this.invokeDryRun(request, response, resource);
    }

    public BuiltResponse invoke(HttpRequest request, HttpResponse response) {
        Object resource = this.resource.createResource(request, response, this.resourceMethodProviderFactory);
        if (resource instanceof CompletionStage) {
            CompletionStage stage = (CompletionStage)resource;
            return stage.thenApply(target -> this.invoke(request, response, target)).toCompletableFuture().getNow(null);
        }
        return this.invoke(request, response, resource);
    }

    public CompletionStage<Object> invokeDryRun(HttpRequest request, HttpResponse response, Object target) {
        request.setAttribute(ResourceMethodInvoker.class.getName(), (Object)this);
        this.incrementMethodCount(request.getHttpMethod());
        ResteasyUriInfo uriInfo = (ResteasyUriInfo)request.getUri();
        if (this.method.getPath() != null) {
            uriInfo.pushMatchedURI(uriInfo.getMatchingPath());
        }
        uriInfo.pushCurrentResource(target);
        return this.invokeOnTargetDryRun(request, response, target);
    }

    public BuiltResponse invoke(HttpRequest request, HttpResponse response, Object target) {
        request.setAttribute(ResourceMethodInvoker.class.getName(), (Object)this);
        this.incrementMethodCount(request.getHttpMethod());
        ResteasyUriInfo uriInfo = (ResteasyUriInfo)request.getUri();
        if (this.method.getPath() != null) {
            uriInfo.pushMatchedURI(uriInfo.getMatchingPath());
        }
        uriInfo.pushCurrentResource(target);
        return this.invokeOnTarget(request, response, target);
    }

    protected CompletionStage<Object> invokeOnTargetDryRun(HttpRequest request, HttpResponse response, Object target) {
        ResteasyContext.pushContext(ResourceInfo.class, this.resourceInfo);
        try {
            Object rtn = this.internalInvokeOnTarget(request, response, target);
            if (rtn != null && rtn instanceof CompletionStage) {
                return (CompletionStage)rtn;
            }
            return CompletableFuture.completedFuture(rtn);
        }
        catch (Failure failure) {
            throw failure;
        }
        catch (ApplicationException appException) {
            throw appException;
        }
        catch (RuntimeException ex) {
            throw new ProcessingException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BuiltResponse invokeOnTarget(HttpRequest request, HttpResponse response, Object target) {
        long msTimeStamp;
        long timestamp;
        RESTEasyTracingLogger tracingLogger;
        block9: {
            BuiltResponse builtResponse;
            tracingLogger = RESTEasyTracingLogger.getInstance(request);
            timestamp = tracingLogger.timestamp("METHOD_INVOKE");
            msTimeStamp = this.methodStatisticsLogger.timestamp();
            try {
                ResteasyContext.pushContext(ResourceInfo.class, this.resourceInfo);
                if (this.requestFilters == null || this.requestFilters.length <= 0) break block9;
                PostMatchContainerRequestContext requestContext = new PostMatchContainerRequestContext(request, this, this.requestFilters, () -> this.invokeOnTargetAfterFilter(request, response, target));
                builtResponse = requestContext.filter();
            }
            catch (Throwable throwable) {
                this.methodStatisticsLogger.duration(msTimeStamp);
                if (this.resource instanceof SingletonResource) {
                    tracingLogger.logDuration("METHOD_INVOKE", timestamp, ((SingletonResource)this.resource).traceInfo(), this.method.getMethod());
                } else {
                    tracingLogger.logDuration("METHOD_INVOKE", timestamp, this.resource, this.method.getMethod());
                }
                throw throwable;
            }
            this.methodStatisticsLogger.duration(msTimeStamp);
            if (this.resource instanceof SingletonResource) {
                tracingLogger.logDuration("METHOD_INVOKE", timestamp, ((SingletonResource)this.resource).traceInfo(), this.method.getMethod());
            } else {
                tracingLogger.logDuration("METHOD_INVOKE", timestamp, this.resource, this.method.getMethod());
            }
            return builtResponse;
        }
        BuiltResponse builtResponse = this.invokeOnTargetAfterFilter(request, response, target);
        this.methodStatisticsLogger.duration(msTimeStamp);
        if (this.resource instanceof SingletonResource) {
            tracingLogger.logDuration("METHOD_INVOKE", timestamp, ((SingletonResource)this.resource).traceInfo(), this.method.getMethod());
        } else {
            tracingLogger.logDuration("METHOD_INVOKE", timestamp, this.resource, this.method.getMethod());
        }
        return builtResponse;
    }

    protected BuiltResponse invokeOnTargetAfterFilter(HttpRequest request, HttpResponse response, Object target) {
        if (this.validator != null) {
            if (this.isValidatable) {
                this.validator.validate(request, target, new Class[0]);
            }
            if (this.methodIsValidatable) {
                request.setAttribute(GeneralValidator.class.getName(), (Object)this.validator);
            } else if (this.isValidatable) {
                this.validator.checkViolations(request);
            }
        }
        AsyncResponseConsumer asyncResponseConsumer = this.asyncResponseProvider != null ? AsyncResponseConsumer.makeAsyncResponseConsumer(this, this.asyncResponseProvider) : (this.asyncStreamProvider != null ? AsyncResponseConsumer.makeAsyncResponseConsumer(this, this.asyncStreamProvider) : null);
        try {
            Object ret = this.internalInvokeOnTarget(request, response, target);
            if (ret != null && ret instanceof CompletionStage) {
                CompletionStage retStage = (CompletionStage)ret;
                CompletionStage<BuiltResponse> stage = retStage.thenApply(rtn -> this.afterInvoke(request, asyncResponseConsumer, rtn));
                return stage.toCompletableFuture().getNow(null);
            }
            return this.afterInvoke(request, asyncResponseConsumer, CompletionStageHolder.resolve(ret));
        }
        catch (CompletionException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                return this.handleInvocationException(asyncResponseConsumer, request, (RuntimeException)ex.getCause());
            }
            SynchronousDispatcher.rethrow(ex.getCause());
            return null;
        }
        catch (RuntimeException ex) {
            return this.handleInvocationException(asyncResponseConsumer, request, ex);
        }
    }

    private BuiltResponse afterInvoke(HttpRequest request, AsyncResponseConsumer asyncResponseConsumer, Object rtn) {
        if (asyncResponseConsumer != null) {
            asyncResponseConsumer.subscribe(rtn);
            return null;
        }
        if (request.getAsyncContext().isSuspended()) {
            if (this.method.isAsynchronous()) {
                return null;
            }
            this.initializeAsync(request.getAsyncContext().getAsyncResponse());
            request.getAsyncContext().getAsyncResponse().resume(rtn);
            return null;
        }
        if (request.wasForwarded()) {
            return null;
        }
        if (rtn == null || this.method.getReturnType().equals(Void.TYPE)) {
            BuiltResponse build = (BuiltResponse)Response.noContent().build();
            build.addMethodAnnotations(this.getMethodAnnotations());
            return build;
        }
        if (Response.class.isAssignableFrom(this.method.getReturnType()) || rtn instanceof Response) {
            if (!(rtn instanceof BuiltResponse)) {
                Response r = (Response)rtn;
                Headers<Object> metadata = new Headers<Object>();
                metadata.putAll(r.getMetadata());
                rtn = new BuiltResponseEntityNotBacked(r.getStatus(), r.getStatusInfo().getReasonPhrase(), metadata, r.getEntity(), null);
            }
            BuiltResponse rtn1 = (BuiltResponse)((Object)rtn);
            rtn1.addMethodAnnotations(this.getMethodAnnotations());
            if (rtn1.getGenericType() == null) {
                if (this.getMethod().getReturnType().equals(Response.class)) {
                    rtn1.setGenericType(rtn1.getEntityClass());
                } else {
                    rtn1.setGenericType(this.method.getGenericReturnType());
                }
            }
            return rtn1;
        }
        Response.ResponseBuilder builder = Response.ok((Object)rtn);
        BuiltResponse jaxrsResponse = (BuiltResponse)builder.build();
        if (jaxrsResponse.getGenericType() == null) {
            if (this.getMethod().getReturnType().equals(Response.class)) {
                jaxrsResponse.setGenericType(jaxrsResponse.getEntityClass());
            } else {
                jaxrsResponse.setGenericType(this.method.getGenericReturnType());
            }
        }
        jaxrsResponse.addMethodAnnotations(this.getMethodAnnotations());
        return jaxrsResponse;
    }

    private BuiltResponse handleInvocationException(AsyncResponseConsumer asyncStreamResponseConsumer, HttpRequest request, RuntimeException ex) {
        if (asyncStreamResponseConsumer != null) {
            try {
                AsyncResponseConsumer consumer = asyncStreamResponseConsumer;
                asyncStreamResponseConsumer.internalResume(ex, t -> consumer.complete(ex));
            }
            catch (UnhandledException x) {
                request.getAsyncContext().getAsyncResponse().completionCallbacks((Throwable)ex);
                throw x;
            }
            return null;
        }
        if (request.getAsyncContext().isSuspended()) {
            try {
                request.getAsyncContext().getAsyncResponse().resume((Throwable)ex);
            }
            catch (Exception e) {
                LogMessages.LOGGER.errorResumingFailedAsynchOperation((Throwable)e);
            }
            return null;
        }
        throw ex;
    }

    private Object internalInvokeOnTarget(HttpRequest request, HttpResponse response, Object target) throws Failure, ApplicationException {
        PostResourceMethodInvokers postResourceMethodInvokers = ResteasyContext.getContextData(PostResourceMethodInvokers.class);
        try {
            Object methodResponse = this.methodInjector.invoke(request, response, target);
            CompletionStage stage = null;
            if (methodResponse != null && methodResponse instanceof CompletionStage) {
                stage = (CompletionStage)methodResponse;
                return stage.handle((ret, exception) -> {
                    if (exception == null && postResourceMethodInvokers != null) {
                        postResourceMethodInvokers.getInvokers().forEach(e -> e.invoke());
                    }
                    if (postResourceMethodInvokers != null) {
                        postResourceMethodInvokers.clear();
                    }
                    if (exception != null) {
                        SynchronousDispatcher.rethrow(exception);
                        return null;
                    }
                    return ret;
                });
            }
            if (postResourceMethodInvokers != null) {
                postResourceMethodInvokers.getInvokers().forEach(e -> e.invoke());
            }
            if (postResourceMethodInvokers != null) {
                postResourceMethodInvokers.clear();
            }
            return methodResponse;
        }
        catch (RuntimeException failure) {
            if (postResourceMethodInvokers != null) {
                postResourceMethodInvokers.clear();
            }
            throw failure;
        }
    }

    public void initializeAsync(ResteasyAsynchronousResponse asyncResponse) {
        asyncResponse.setAnnotations(this.method.getAnnotatedMethod().getAnnotations());
        asyncResponse.setWriterInterceptors(this.getWriterInterceptors());
        asyncResponse.setResponseFilters(this.getResponseFilters());
        if (asyncResponse instanceof ResourceMethodInvokerAwareResponse) {
            ((ResourceMethodInvokerAwareResponse)asyncResponse).setMethod(this);
        }
    }

    public boolean doesProduce(List<? extends MediaType> accepts) {
        if (accepts == null || accepts.size() == 0) {
            return true;
        }
        if (this.method.getProduces().length == 0) {
            return true;
        }
        for (MediaType mediaType : accepts) {
            for (MediaType type : this.method.getProduces()) {
                if (!type.isCompatible(mediaType)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean doesConsume(MediaType contentType) {
        boolean matches = false;
        if (this.method.getConsumes().length == 0 || contentType == null && !this.expectsBody) {
            return true;
        }
        if (contentType == null) {
            contentType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        for (MediaType type : this.method.getConsumes()) {
            if (!type.isCompatible(contentType)) continue;
            matches = true;
            break;
        }
        return matches;
    }

    public MediaType resolveContentType(HttpRequest in, Object entity) {
        MediaType chosen = (MediaType)in.getAttribute("RESTEASY_CHOSEN_ACCEPT");
        if (chosen != null && !chosen.equals((Object)MediaType.WILDCARD_TYPE)) {
            return chosen;
        }
        List accepts = in.getHttpHeaders().getAcceptableMediaTypes();
        if (accepts == null || accepts.size() == 0) {
            if (this.method.getProduces().length == 0) {
                return MediaType.WILDCARD_TYPE;
            }
            return this.method.getProduces()[0];
        }
        if (this.method.getProduces().length == 0) {
            return this.resolveContentTypeByAccept(accepts, entity);
        }
        for (MediaType accept : accepts) {
            for (MediaType type : this.method.getProduces()) {
                if (!type.isCompatible(accept)) continue;
                return type;
            }
        }
        return MediaType.WILDCARD_TYPE;
    }

    protected MediaType resolveContentTypeByAccept(List<MediaType> accepts, Object entity) {
        if (accepts == null || accepts.size() == 0 || entity == null) {
            return MediaType.WILDCARD_TYPE;
        }
        Class clazz = entity.getClass();
        Type type = this.method.getGenericReturnType();
        if (entity instanceof GenericEntity) {
            GenericEntity gen = (GenericEntity)entity;
            clazz = gen.getRawType();
            type = gen.getType();
        }
        for (MediaType accept : accepts) {
            if (this.resourceMethodProviderFactory.getMessageBodyWriter(clazz, type, this.method.getAnnotatedMethod().getAnnotations(), accept) == null) continue;
            return accept;
        }
        return MediaType.WILDCARD_TYPE;
    }

    public Set<String> getHttpMethods() {
        return this.method.getHttpMethods();
    }

    public MediaType[] getProduces() {
        return this.method.getProduces();
    }

    public MediaType[] getConsumes() {
        return this.method.getConsumes();
    }

    public boolean isSse() {
        return this.isSse;
    }

    public void markMethodAsAsync() {
        this.method.markAsynchronous();
    }

    public void setMethodStatisticsLogger(MethodStatisticsLogger msLogger) {
        this.methodStatisticsLogger = msLogger;
    }

    public MethodStatisticsLogger getMethodStatisticsLogger() {
        return this.methodStatisticsLogger;
    }
}

