/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.MongoClient;
import com.mongodb.util.JSONSerializers;
import com.mongodb.util.ObjectSerializer;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.FieldSelector;
import io.debezium.connector.mongodb.Filters;
import io.debezium.connector.mongodb.MongoDbCollectionSchema;
import io.debezium.data.Envelope;
import io.debezium.data.Json;
import io.debezium.pipeline.txmetadata.TransactionMonitor;
import io.debezium.schema.DataCollectionId;
import io.debezium.schema.DataCollectionSchema;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.TopicSelector;
import io.debezium.util.SchemaNameAdjuster;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.Encoder;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbSchema
implements DatabaseSchema<CollectionId> {
    public static final JsonWriterSettings COMPACT_JSON_SETTINGS = JsonWriterSettings.builder().outputMode(JsonMode.STRICT).indent(true).indentCharacters("").newLineCharacters("").build();
    private static final ObjectSerializer jsonSerializer = JSONSerializers.getStrict();
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbSchema.class);
    private final Filters filters;
    private final TopicSelector<CollectionId> topicSelector;
    private final Schema sourceSchema;
    private final SchemaNameAdjuster adjuster = SchemaNameAdjuster.create((Logger)LOGGER);
    private final Function<Document, String> valueTransformer;
    private final Map<CollectionId, MongoDbCollectionSchema> collections = new HashMap<CollectionId, MongoDbCollectionSchema>();

    public MongoDbSchema(Filters filters, TopicSelector<CollectionId> topicSelector, Schema sourceSchema) {
        this.filters = filters;
        this.topicSelector = topicSelector;
        this.sourceSchema = sourceSchema;
        this.valueTransformer = MongoDbSchema.resolveValueTransformer();
    }

    public void close() {
    }

    public DataCollectionSchema schemaFor(CollectionId collectionId) {
        return this.collections.computeIfAbsent(collectionId, id -> {
            FieldSelector.FieldFilter fieldFilter = this.filters.fieldFilterFor((CollectionId)id);
            String topicName = this.topicSelector.topicNameFor((DataCollectionId)id);
            Schema keySchema = SchemaBuilder.struct().name(this.adjuster.adjust(topicName + ".Key")).field("id", Schema.STRING_SCHEMA).build();
            Schema valueSchema = SchemaBuilder.struct().name(this.adjuster.adjust(Envelope.schemaName((String)topicName))).field("after", Json.builder().optional().build()).field("patch", Json.builder().optional().build()).field("filter", Json.builder().optional().build()).field("source", this.sourceSchema).field("op", Schema.OPTIONAL_STRING_SCHEMA).field("ts_ms", Schema.OPTIONAL_INT64_SCHEMA).field("transaction", TransactionMonitor.TRANSACTION_BLOCK_SCHEMA).build();
            Envelope envelope = Envelope.fromSchema((Schema)valueSchema);
            return new MongoDbCollectionSchema((CollectionId)id, fieldFilter, keySchema, this::getDocumentId, envelope, valueSchema, this::getDocumentValue);
        });
    }

    public boolean tableInformationComplete() {
        return false;
    }

    public void assureNonEmptySchema() {
        if (this.collections.isEmpty()) {
            LOGGER.warn("After applying blacklist/whitelist filters there are no tables to monitor, please check your configuration");
        }
    }

    private String getDocumentId(Document document) {
        if (document == null) {
            return null;
        }
        return jsonSerializer.serialize(document.get((Object)"_id"));
    }

    private String getDocumentValue(Document document) {
        return this.valueTransformer.apply(document);
    }

    private static Function<Document, String> resolveValueTransformer() {
        Codec encoder = MongoClient.getDefaultCodecRegistry().get(Document.class);
        return arg_0 -> MongoDbSchema.lambda$resolveValueTransformer$1((Encoder)encoder, arg_0);
    }

    private static /* synthetic */ String lambda$resolveValueTransformer$1(Encoder encoder, Document doc) {
        return doc.toJson(COMPACT_JSON_SETTINGS, encoder);
    }
}

