/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven.workspace;

import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.bootstrap.resolver.maven.workspace.UnresolvedVersionException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Resource;

public class LocalProject {
    public static final String PROJECT_GROUPID = "${project.groupId}";
    private static final String PROJECT_BASEDIR = "${project.basedir}";
    private static final String POM_XML = "pom.xml";
    private final Model rawModel;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final Path dir;
    private final LocalWorkspace workspace;
    private final List<LocalProject> modules = new ArrayList<LocalProject>(0);
    private AppArtifactKey key;

    public static LocalProject load(Path path) throws BootstrapException {
        return LocalProject.load(path, true);
    }

    public static LocalProject load(Path path, boolean required) throws BootstrapException {
        Path pom = LocalProject.locateCurrentProjectPom(path, required);
        if (pom == null) {
            return null;
        }
        try {
            return new LocalProject(LocalProject.readModel(pom), null);
        }
        catch (UnresolvedVersionException e) {
            return LocalProject.loadWorkspace(pom);
        }
    }

    public static LocalProject loadWorkspace(Path path) throws BootstrapException {
        return LocalProject.loadWorkspace(path, true);
    }

    public static LocalProject loadWorkspace(Path path, boolean required) throws BootstrapException {
        path = path.normalize().toAbsolutePath();
        Path currentProjectPom = null;
        Model rootModel = null;
        if (!Files.isDirectory(path, new LinkOption[0])) {
            try {
                rootModel = LocalProject.loadRootModel(path);
                if (rootModel != null) {
                    currentProjectPom = path;
                }
            }
            catch (BootstrapException bootstrapException) {
                // empty catch block
            }
        }
        if (currentProjectPom == null) {
            currentProjectPom = LocalProject.locateCurrentProjectPom(path, required);
            if (currentProjectPom == null) {
                return null;
            }
            rootModel = LocalProject.loadRootModel(currentProjectPom);
        }
        return LocalProject.loadWorkspace(currentProjectPom, rootModel);
    }

    public static LocalProject loadWorkspace(BootstrapMavenContext ctx) throws BootstrapException {
        Path currentProjectPom = ctx.getCurrentProjectPomOrNull();
        if (currentProjectPom == null) {
            return null;
        }
        Path rootProjectBaseDir = ctx.getRootProjectBaseDir();
        Model rootModel = rootProjectBaseDir == null || rootProjectBaseDir.equals(currentProjectPom.getParent()) ? LocalProject.loadRootModel(currentProjectPom) : LocalProject.readModel(rootProjectBaseDir.resolve(POM_XML));
        return LocalProject.loadWorkspace(currentProjectPom, rootModel);
    }

    private static LocalProject loadWorkspace(Path currentProjectPom, Model rootModel) throws BootstrapException {
        LocalWorkspace ws = new LocalWorkspace();
        LocalProject project = LocalProject.load(ws, null, rootModel, currentProjectPom.getParent());
        return project == null ? LocalProject.load(ws, null, LocalProject.readModel(currentProjectPom), currentProjectPom.getParent()) : project;
    }

    private static LocalProject load(LocalWorkspace workspace, LocalProject parent, Model model, Path currentProjectDir) throws BootstrapException {
        LocalProject project = new LocalProject(model, workspace);
        if (parent != null) {
            parent.modules.add(project);
        }
        LocalProject result = currentProjectDir == null || !currentProjectDir.equals(project.getDir()) ? null : project;
        List<String> modules = project.getRawModel().getModules();
        if (!modules.isEmpty()) {
            Path dirArg = result == null ? currentProjectDir : null;
            for (String module : modules) {
                LocalProject loaded = LocalProject.load(workspace, project, LocalProject.readModel(project.getDir().resolve(module).resolve(POM_XML)), dirArg);
                if (loaded == null || result != null) continue;
                result = loaded;
                dirArg = null;
            }
        }
        return result;
    }

    private static Model loadRootModel(Path pomXml) throws BootstrapException {
        Model model = null;
        while (pomXml != null && Files.exists(pomXml, new LinkOption[0])) {
            model = LocalProject.readModel(pomXml);
            Parent parent = model.getParent();
            if (parent != null && parent.getRelativePath() != null && !parent.getRelativePath().isEmpty()) {
                if (!Files.isDirectory(pomXml = pomXml.getParent().resolve(parent.getRelativePath()).normalize(), new LinkOption[0])) continue;
                pomXml = pomXml.resolve(POM_XML);
                continue;
            }
            Path parentDir = pomXml.getParent().getParent();
            pomXml = parentDir == null ? null : parentDir.resolve(POM_XML);
        }
        return model;
    }

    private static final Model readModel(Path pom) throws BootstrapException {
        try {
            Model model = ModelUtils.readModel(pom);
            model.setPomFile(pom.toFile());
            return model;
        }
        catch (IOException e) {
            throw new BootstrapException("Failed to read " + pom, e);
        }
    }

    private static Path locateCurrentProjectPom(Path path, boolean required) throws BootstrapException {
        for (Path p = path; p != null; p = p.getParent()) {
            Path pom = p.resolve(POM_XML);
            if (!Files.exists(pom, new LinkOption[0])) continue;
            return pom;
        }
        if (required) {
            throw new BootstrapException("Failed to locate project pom.xml for " + path);
        }
        return null;
    }

    private LocalProject(Model rawModel, LocalWorkspace workspace) throws BootstrapException {
        String resolvedVersion;
        this.rawModel = rawModel;
        this.dir = rawModel.getProjectDirectory().toPath();
        this.workspace = workspace;
        this.groupId = ModelUtils.getGroupId(rawModel);
        this.artifactId = rawModel.getArtifactId();
        String rawVersion = ModelUtils.getRawVersion(rawModel);
        boolean rawVersionIsUnresolved = ModelUtils.isUnresolvedVersion(rawVersion);
        String string = resolvedVersion = rawVersionIsUnresolved ? ModelUtils.resolveVersion(rawVersion, rawModel) : rawVersion;
        if (workspace != null) {
            workspace.addProject(this, rawModel.getPomFile().lastModified());
            if (rawVersionIsUnresolved) {
                if (resolvedVersion == null) {
                    resolvedVersion = workspace.getResolvedVersion();
                    if (resolvedVersion == null) {
                        throw UnresolvedVersionException.forGa(this.groupId, this.artifactId, rawVersion);
                    }
                } else {
                    workspace.setResolvedVersion(resolvedVersion);
                }
            }
        } else if (resolvedVersion == null) {
            throw UnresolvedVersionException.forGa(this.groupId, this.artifactId, rawVersion);
        }
        this.version = resolvedVersion;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public Path getDir() {
        return this.dir;
    }

    public Path getOutputDir() {
        return this.dir.resolve("target");
    }

    public Path getClassesDir() {
        String classesDir = this.rawModel.getBuild() == null ? null : this.rawModel.getBuild().getOutputDirectory();
        return this.resolveRelativeToBaseDir(classesDir, "target/classes");
    }

    public Path getTestClassesDir() {
        String classesDir = this.rawModel.getBuild() == null ? null : this.rawModel.getBuild().getTestOutputDirectory();
        return this.resolveRelativeToBaseDir(classesDir, "target/test-classes");
    }

    public Path getSourcesSourcesDir() {
        String srcDir = this.rawModel.getBuild() == null ? null : this.rawModel.getBuild().getSourceDirectory();
        return this.resolveRelativeToBaseDir(srcDir, "src/main/java");
    }

    public Path getResourcesSourcesDir() {
        List resources = this.rawModel.getBuild() == null ? Collections.emptyList() : this.rawModel.getBuild().getResources();
        String resourcesDir = resources.isEmpty() ? null : ((Resource)resources.get(0)).getDirectory();
        return this.resolveRelativeToBaseDir(resourcesDir, "src/main/resources");
    }

    public Model getRawModel() {
        return this.rawModel;
    }

    public LocalWorkspace getWorkspace() {
        return this.workspace;
    }

    public AppArtifactKey getKey() {
        return this.key == null ? (this.key = new AppArtifactKey(this.groupId, this.artifactId)) : this.key;
    }

    public AppArtifact getAppArtifact() {
        return this.getAppArtifact(this.rawModel.getPackaging());
    }

    public AppArtifact getAppArtifact(String extension) {
        return new AppArtifact(this.groupId, this.artifactId, "", extension, this.version);
    }

    public List<LocalProject> getSelfWithLocalDeps() {
        if (this.workspace == null) {
            return Collections.singletonList(this);
        }
        ArrayList<LocalProject> ordered = new ArrayList<LocalProject>();
        LocalProject.collectSelfWithLocalDeps(this, new HashSet<AppArtifactKey>(), ordered);
        return ordered;
    }

    private static void collectSelfWithLocalDeps(LocalProject project, Set<AppArtifactKey> addedDeps, List<LocalProject> ordered) {
        if (!project.modules.isEmpty()) {
            for (LocalProject module : project.modules) {
                LocalProject.collectSelfWithLocalDeps(module, addedDeps, ordered);
            }
        }
        for (Dependency dep : project.getRawModel().getDependencies()) {
            AppArtifactKey depKey = project.getKey(dep);
            LocalProject localDep = project.workspace.getProject(depKey);
            if (localDep == null || addedDeps.contains(depKey)) continue;
            LocalProject.collectSelfWithLocalDeps(localDep, addedDeps, ordered);
        }
        if (addedDeps.add(project.getKey())) {
            ordered.add(project);
        }
    }

    private AppArtifactKey getKey(Dependency dep) {
        return new AppArtifactKey(PROJECT_GROUPID.equals(dep.getGroupId()) ? this.getGroupId() : dep.getGroupId(), dep.getArtifactId());
    }

    private Path resolveRelativeToBaseDir(String path, String defaultPath) {
        return this.dir.resolve(path == null ? defaultPath : LocalProject.stripProjectBasedirPrefix(path));
    }

    private static String stripProjectBasedirPrefix(String path) {
        return path.startsWith(PROJECT_BASEDIR) ? path.substring(PROJECT_BASEDIR.length() + 1) : path;
    }
}

