/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.function.Consumer;

public class QuarkusLauncher {
    public static void launch(String callingClass, String quarkusApplication, Consumer<Integer> exitHandler, String ... args) {
        try {
            String classResource = callingClass.replace(".", "/") + ".class";
            URL resource = Thread.currentThread().getContextClassLoader().getResource(classResource);
            String path = resource.getPath();
            path = path.substring(0, path.length() - classResource.length());
            URL newResource = new URL(resource.getProtocol(), resource.getHost(), resource.getPort(), path);
            Path appClasses = Paths.get(newResource.toURI());
            if (quarkusApplication != null) {
                System.setProperty("quarkus.package.main-class", quarkusApplication);
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("app-classes", appClasses);
            context.put("args", args);
            CuratedApplication app = QuarkusBootstrap.builder(appClasses).setBaseClassLoader(QuarkusLauncher.class.getClassLoader()).setProjectRoot(appClasses).setIsolateDeployment(true).setMode(QuarkusBootstrap.Mode.DEV).build().bootstrap();
            app.runInAugmentClassLoader("io.quarkus.deployment.dev.IDEDevModeMain", context);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

