/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;

public class BytesSchema
extends AbstractSchema<byte[]> {
    private static final BytesSchema INSTANCE;
    private static final SchemaInfo SCHEMA_INFO;

    public static BytesSchema of() {
        return INSTANCE;
    }

    public byte[] encode(byte[] message) {
        return message;
    }

    public byte[] decode(byte[] bytes) {
        return bytes;
    }

    @Override
    public byte[] decode(ByteBuf byteBuf) {
        if (byteBuf == null) {
            return null;
        }
        int size = byteBuf.readableBytes();
        byte[] bytes = new byte[size];
        byteBuf.readBytes(bytes, 0, size);
        return bytes;
    }

    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }

    static {
        SCHEMA_INFO = new SchemaInfo().setName("Bytes").setType(SchemaType.BYTES).setSchema(new byte[0]);
        INSTANCE = new BytesSchema();
    }
}

