/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.redis;

import io.debezium.DebeziumException;
import io.debezium.engine.ChangeEvent;
import io.debezium.engine.DebeziumEngine;
import io.debezium.server.BaseChangeConsumer;
import io.debezium.util.DelayStrategy;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.inject.Named;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;

@Named(value="redis")
@Dependent
public class RedisStreamChangeConsumer
extends BaseChangeConsumer
implements DebeziumEngine.ChangeConsumer<ChangeEvent<Object, Object>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisStreamChangeConsumer.class);
    private static final String PROP_PREFIX = "debezium.sink.redis.";
    private static final String PROP_ADDRESS = "debezium.sink.redis.address";
    private static final String PROP_USER = "debezium.sink.redis.user";
    private static final String PROP_PASSWORD = "debezium.sink.redis.password";
    private HostAndPort address;
    private Optional<String> user;
    private Optional<String> password;
    @ConfigProperty(name="debezium.sink.redis.batch.size", defaultValue="500")
    Integer batchSize;
    @ConfigProperty(name="debezium.sink.redis.retry.initial.delay.ms", defaultValue="300")
    Integer initialRetryDelay;
    @ConfigProperty(name="debezium.sink.redis.retry.max.delay.ms", defaultValue="10000")
    Integer maxRetryDelay;
    @ConfigProperty(name="debezium.sink.redis.null.key", defaultValue="default")
    String nullKey;
    @ConfigProperty(name="debezium.sink.redis.null.value", defaultValue="default")
    String nullValue;
    private Jedis client = null;

    @PostConstruct
    void connect() {
        Config config = ConfigProvider.getConfig();
        this.address = HostAndPort.from((String)((String)config.getValue(PROP_ADDRESS, String.class)));
        this.user = config.getOptionalValue(PROP_USER, String.class);
        this.password = config.getOptionalValue(PROP_PASSWORD, String.class);
        this.client = new Jedis(this.address);
        if (this.user.isPresent()) {
            this.client.auth(this.user.get(), this.password.get());
        } else if (this.password.isPresent()) {
            this.client.auth(this.password.get());
        } else {
            this.client.ping();
        }
        LOGGER.info("Using Jedis '{}'", (Object)this.client);
    }

    @PreDestroy
    void close() {
        try {
            this.client.close();
        }
        catch (Exception e) {
            LOGGER.warn("Exception while closing Jedis: {}", (Object)this.client, (Object)e);
        }
        finally {
            this.client = null;
        }
    }

    private <T> Stream<List<T>> batches(List<T> source, int length) {
        if (source.isEmpty()) {
            return Stream.empty();
        }
        int size = source.size();
        int fullChunks = (size - 1) / length;
        return IntStream.range(0, fullChunks + 1).mapToObj(n -> source.subList(n * length, n == fullChunks ? size : (n + 1) * length));
    }

    public void handleBatch(List<ChangeEvent<Object, Object>> records, DebeziumEngine.RecordCommitter<ChangeEvent<Object, Object>> committer) throws InterruptedException {
        DelayStrategy delayStrategy = DelayStrategy.exponential((long)this.initialRetryDelay.intValue(), (long)this.maxRetryDelay.intValue());
        LOGGER.trace("Handling a batch of {} records", (Object)records.size());
        this.batches(records, this.batchSize).forEach(batch -> {
            boolean completedSuccessfully = false;
            while (!completedSuccessfully) {
                block13: {
                    if (this.client == null) {
                        try {
                            this.connect();
                            continue;
                        }
                        catch (Exception e) {
                            this.close();
                            LOGGER.error("Can't connect to Redis", (Throwable)e);
                            break block13;
                        }
                    }
                    try {
                        LOGGER.trace("Preparing a Redis Transaction of {} records", (Object)batch.size());
                        Transaction transaction = this.client.multi();
                        for (ChangeEvent record : batch) {
                            String destination = this.streamNameMapper.map(record.destination());
                            String key = record.key() != null ? this.getString(record.key()) : this.nullKey;
                            String value = record.value() != null ? this.getString(record.value()) : this.nullValue;
                            transaction.xadd(destination, StreamEntryID.NEW_ENTRY, Collections.singletonMap(key, value));
                        }
                        transaction.exec();
                        for (ChangeEvent record : batch) {
                            committer.markProcessed((Object)record);
                        }
                        completedSuccessfully = true;
                    }
                    catch (JedisConnectionException jce) {
                        this.close();
                    }
                    catch (JedisDataException jde) {
                        if (jde.getMessage().equals("EXECABORT Transaction discarded because of: OOM command not allowed when used memory > 'maxmemory'.")) {
                            LOGGER.error("Redis runs OOM", (Throwable)jde);
                        }
                        if (jde.getMessage().startsWith("EXECABORT")) {
                            LOGGER.error("Redis transaction error", (Throwable)jde);
                        }
                        if (jde.getMessage().equals("LOADING Redis is loading the dataset in memory")) {
                            LOGGER.error("Redis is starting", (Throwable)jde);
                        }
                        LOGGER.error("Unexpected JedisDataException", (Throwable)jde);
                        throw new DebeziumException((Throwable)jde);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unexpected Exception", (Throwable)e);
                        throw new DebeziumException((Throwable)e);
                    }
                }
                delayStrategy.sleepWhen(!completedSuccessfully);
            }
        });
        committer.markBatchFinished();
    }
}

