/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde;

import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.serde.AbstractKafkaSerDe;
import io.apicurio.registry.serde.ParsedSchema;
import io.apicurio.registry.serde.ParsedSchemaImpl;
import io.apicurio.registry.serde.SchemaLookupResult;
import io.apicurio.registry.serde.SchemaResolver;
import io.apicurio.registry.serde.config.BaseKafkaDeserializerConfig;
import io.apicurio.registry.serde.config.BaseKafkaSerDeConfig;
import io.apicurio.registry.serde.fallback.DefaultFallbackArtifactProvider;
import io.apicurio.registry.serde.fallback.FallbackArtifactProvider;
import io.apicurio.registry.serde.strategy.ArtifactReference;
import io.apicurio.registry.serde.utils.Utils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;

public abstract class AbstractKafkaDeserializer<T, U>
extends AbstractKafkaSerDe<T, U>
implements Deserializer<U> {
    protected FallbackArtifactProvider fallbackArtifactProvider;

    public AbstractKafkaDeserializer() {
    }

    public AbstractKafkaDeserializer(RegistryClient client) {
        super(client);
    }

    public AbstractKafkaDeserializer(SchemaResolver<T, U> schemaResolver) {
        super(schemaResolver);
    }

    public AbstractKafkaDeserializer(RegistryClient client, SchemaResolver<T, U> schemaResolver) {
        super(client, schemaResolver);
    }

    @Override
    protected void configure(BaseKafkaSerDeConfig config, boolean isKey) {
        super.configure(config, isKey);
        BaseKafkaDeserializerConfig deserializerConfig = new BaseKafkaDeserializerConfig(config.originals());
        Object fallbackProvider = deserializerConfig.getFallbackArtifactProvider();
        Utils.instantiate(FallbackArtifactProvider.class, fallbackProvider, this::setFallbackArtifactProvider);
        this.fallbackArtifactProvider.configure(config.originals(), isKey);
        if (this.fallbackArtifactProvider instanceof DefaultFallbackArtifactProvider && !((DefaultFallbackArtifactProvider)this.fallbackArtifactProvider).isConfigured()) {
            this.fallbackArtifactProvider = null;
        }
    }

    public void setFallbackArtifactProvider(FallbackArtifactProvider fallbackArtifactProvider) {
        this.fallbackArtifactProvider = fallbackArtifactProvider;
    }

    protected abstract U readData(ParsedSchema<T> var1, ByteBuffer var2, int var3, int var4);

    protected abstract U readData(Headers var1, ParsedSchema<T> var2, ByteBuffer var3, int var4, int var5);

    public U deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        ByteBuffer buffer = AbstractKafkaDeserializer.getByteBuffer(data);
        ArtifactReference artifactReference = this.getIdHandler().readId(buffer);
        SchemaLookupResult<T> schema = this.resolve(topic, null, data, artifactReference);
        int length = buffer.limit() - 1 - this.getIdHandler().idSize();
        int start = buffer.position() + buffer.arrayOffset();
        ParsedSchemaImpl parsedSchema = new ParsedSchemaImpl().setRawSchema(schema.getRawSchema()).setParsedSchema(schema.getSchema());
        return this.readData(parsedSchema, buffer, start, length);
    }

    public U deserialize(String topic, Headers headers, byte[] data) {
        if (data == null) {
            return null;
        }
        ArtifactReference artifactReference = null;
        if (headers != null && (artifactReference = this.headersHandler.readHeaders(headers)).hasValue()) {
            return this.readData(topic, headers, data, artifactReference);
        }
        if (data[0] == 0) {
            return this.deserialize(topic, data);
        }
        if (headers == null) {
            throw new IllegalStateException("Headers cannot be null");
        }
        return this.readData(topic, headers, data, artifactReference);
    }

    private U readData(String topic, Headers headers, byte[] data, ArtifactReference artifactReference) {
        SchemaLookupResult<T> schema = this.resolve(topic, headers, data, artifactReference);
        ByteBuffer buffer = ByteBuffer.wrap(data);
        int length = buffer.limit();
        int start = buffer.position();
        ParsedSchemaImpl parsedSchema = new ParsedSchemaImpl().setRawSchema(schema.getRawSchema()).setParsedSchema(schema.getSchema());
        return this.readData(headers, parsedSchema, buffer, start, length);
    }

    private SchemaLookupResult<T> resolve(String topic, Headers headers, byte[] data, ArtifactReference artifactReference) {
        try {
            return this.getSchemaResolver().resolveSchemaByArtifactReference(artifactReference);
        }
        catch (RuntimeException e) {
            if (this.fallbackArtifactProvider == null) {
                throw e;
            }
            try {
                ArtifactReference fallbackReference = this.fallbackArtifactProvider.get(topic, headers, data);
                return this.getSchemaResolver().resolveSchemaByArtifactReference(fallbackReference);
            }
            catch (RuntimeException fe) {
                fe.addSuppressed(e);
                throw fe;
            }
        }
    }

    public void close() {
        try {
            this.schemaResolver.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

