/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.stream.impl.Credentials;
import io.pravega.shared.metrics.MetricListener;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ClientConfig
implements Serializable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientConfig.class);
    static final int DEFAULT_MAX_CONNECTIONS_PER_SEGMENT_STORE = 10;
    private static final long serialVersionUID = 1L;
    private final URI controllerURI;
    private final io.pravega.shared.security.auth.Credentials credentials;
    private final String trustStore;
    private final boolean validateHostName;
    private final int maxConnectionsPerSegmentStore;
    private final boolean deriveTlsEnabledFromControllerURI;
    private final boolean enableTlsToController;
    private final boolean enableTlsToSegmentStore;
    private final MetricListener metricListener;

    public boolean isEnableTls() {
        if (this.deriveTlsEnabledFromControllerURI) {
            String scheme = this.controllerURI.getScheme();
            if (scheme == null) {
                return false;
            }
            return scheme.equals("tls") || scheme.equals("ssl") || scheme.equals("pravegas");
        }
        return this.enableTlsToController && this.enableTlsToSegmentStore;
    }

    public boolean isEnableTlsToController() {
        if (this.deriveTlsEnabledFromControllerURI) {
            return this.isEnableTls();
        }
        return this.enableTlsToController;
    }

    public boolean isEnableTlsToSegmentStore() {
        if (this.deriveTlsEnabledFromControllerURI) {
            return this.isEnableTls();
        }
        return this.enableTlsToSegmentStore;
    }

    @ConstructorProperties(value={"controllerURI", "credentials", "trustStore", "validateHostName", "maxConnectionsPerSegmentStore", "deriveTlsEnabledFromControllerURI", "enableTlsToController", "enableTlsToSegmentStore", "metricListener"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    ClientConfig(URI controllerURI, io.pravega.shared.security.auth.Credentials credentials, String trustStore, boolean validateHostName, int maxConnectionsPerSegmentStore, boolean deriveTlsEnabledFromControllerURI, boolean enableTlsToController, boolean enableTlsToSegmentStore, MetricListener metricListener) {
        this.controllerURI = controllerURI;
        this.credentials = credentials;
        this.trustStore = trustStore;
        this.validateHostName = validateHostName;
        this.maxConnectionsPerSegmentStore = maxConnectionsPerSegmentStore;
        this.deriveTlsEnabledFromControllerURI = deriveTlsEnabledFromControllerURI;
        this.enableTlsToController = enableTlsToController;
        this.enableTlsToSegmentStore = enableTlsToSegmentStore;
        this.metricListener = metricListener;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ClientConfigBuilder builder() {
        return new ClientConfigBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClientConfigBuilder toBuilder() {
        return new ClientConfigBuilder().controllerURI(this.controllerURI).credentials(this.credentials).trustStore(this.trustStore).validateHostName(this.validateHostName).maxConnectionsPerSegmentStore(this.maxConnectionsPerSegmentStore).deriveTlsEnabledFromControllerURI(this.deriveTlsEnabledFromControllerURI).enableTlsToController(this.enableTlsToController).enableTlsToSegmentStore(this.enableTlsToSegmentStore).metricListener(this.metricListener);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public URI getControllerURI() {
        return this.controllerURI;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public io.pravega.shared.security.auth.Credentials getCredentials() {
        return this.credentials;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTrustStore() {
        return this.trustStore;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isValidateHostName() {
        return this.validateHostName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxConnectionsPerSegmentStore() {
        return this.maxConnectionsPerSegmentStore;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MetricListener getMetricListener() {
        return this.metricListener;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientConfig)) {
            return false;
        }
        ClientConfig other = (ClientConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        URI this$controllerURI = this.getControllerURI();
        URI other$controllerURI = other.getControllerURI();
        if (this$controllerURI == null ? other$controllerURI != null : !((Object)this$controllerURI).equals(other$controllerURI)) {
            return false;
        }
        io.pravega.shared.security.auth.Credentials this$credentials = this.getCredentials();
        io.pravega.shared.security.auth.Credentials other$credentials = other.getCredentials();
        if (this$credentials == null ? other$credentials != null : !this$credentials.equals(other$credentials)) {
            return false;
        }
        String this$trustStore = this.getTrustStore();
        String other$trustStore = other.getTrustStore();
        if (this$trustStore == null ? other$trustStore != null : !this$trustStore.equals(other$trustStore)) {
            return false;
        }
        if (this.isValidateHostName() != other.isValidateHostName()) {
            return false;
        }
        if (this.getMaxConnectionsPerSegmentStore() != other.getMaxConnectionsPerSegmentStore()) {
            return false;
        }
        if (this.deriveTlsEnabledFromControllerURI != other.deriveTlsEnabledFromControllerURI) {
            return false;
        }
        if (this.isEnableTlsToController() != other.isEnableTlsToController()) {
            return false;
        }
        if (this.isEnableTlsToSegmentStore() != other.isEnableTlsToSegmentStore()) {
            return false;
        }
        MetricListener this$metricListener = this.getMetricListener();
        MetricListener other$metricListener = other.getMetricListener();
        return !(this$metricListener == null ? other$metricListener != null : !this$metricListener.equals(other$metricListener));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $controllerURI = this.getControllerURI();
        result = result * 59 + ($controllerURI == null ? 43 : ((Object)$controllerURI).hashCode());
        io.pravega.shared.security.auth.Credentials $credentials = this.getCredentials();
        result = result * 59 + ($credentials == null ? 43 : $credentials.hashCode());
        String $trustStore = this.getTrustStore();
        result = result * 59 + ($trustStore == null ? 43 : $trustStore.hashCode());
        result = result * 59 + (this.isValidateHostName() ? 79 : 97);
        result = result * 59 + this.getMaxConnectionsPerSegmentStore();
        result = result * 59 + (this.deriveTlsEnabledFromControllerURI ? 79 : 97);
        result = result * 59 + (this.isEnableTlsToController() ? 79 : 97);
        result = result * 59 + (this.isEnableTlsToSegmentStore() ? 79 : 97);
        MetricListener $metricListener = this.getMetricListener();
        result = result * 59 + ($metricListener == null ? 43 : $metricListener.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ClientConfig(controllerURI=" + this.getControllerURI() + ", credentials=" + this.getCredentials() + ", trustStore=" + this.getTrustStore() + ", validateHostName=" + this.isValidateHostName() + ", maxConnectionsPerSegmentStore=" + this.getMaxConnectionsPerSegmentStore() + ", deriveTlsEnabledFromControllerURI=" + this.deriveTlsEnabledFromControllerURI + ", enableTlsToController=" + this.isEnableTlsToController() + ", enableTlsToSegmentStore=" + this.isEnableTlsToSegmentStore() + ", metricListener=" + this.getMetricListener() + ")";
    }

    public static final class ClientConfigBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private URI controllerURI;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private io.pravega.shared.security.auth.Credentials credentials;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String trustStore;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int maxConnectionsPerSegmentStore;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean enableTlsToController;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean enableTlsToSegmentStore;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private MetricListener metricListener;
        private static final String AUTH_PROPS_PREFIX = "pravega.client.auth.";
        private static final String AUTH_METHOD = "method";
        private static final String AUTH_METHOD_LOAD_DYNAMIC = "loadDynamic";
        private static final String AUTH_TOKEN = "token";
        private static final String AUTH_PROPS_PREFIX_ENV = "pravega_client_auth_";
        private boolean validateHostName = true;
        private boolean deriveTlsEnabledFromControllerURI = true;

        private ClientConfigBuilder deriveTlsEnabledFromControllerURI(boolean value) {
            this.deriveTlsEnabledFromControllerURI = value;
            return this;
        }

        public ClientConfigBuilder enableTlsToController(boolean value) {
            this.deriveTlsEnabledFromControllerURI(false);
            this.enableTlsToController = value;
            return this;
        }

        public ClientConfigBuilder enableTlsToSegmentStore(boolean value) {
            this.deriveTlsEnabledFromControllerURI(false);
            this.enableTlsToSegmentStore = value;
            return this;
        }

        public ClientConfig build() {
            if (this.controllerURI == null) {
                this.controllerURI = URI.create("tcp://localhost:9090");
            }
            this.extractCredentials();
            if (this.maxConnectionsPerSegmentStore <= 0) {
                this.maxConnectionsPerSegmentStore = 10;
            }
            return new ClientConfig(this.controllerURI, this.credentials, this.trustStore, this.validateHostName, this.maxConnectionsPerSegmentStore, this.deriveTlsEnabledFromControllerURI, this.enableTlsToController, this.enableTlsToSegmentStore, this.metricListener);
        }

        private void extractCredentials() {
            this.extractCredentials(System.getProperties(), System.getenv());
        }

        @VisibleForTesting
        ClientConfigBuilder extractCredentials(Properties properties, Map<String, String> env) {
            if (this.credentials != null) {
                log.info("Client credentials were extracted using the explicitly supplied credentials object.");
                return this;
            }
            if (properties != null) {
                this.credentials = this.extractCredentialsFromProperties(properties);
                if (this.credentials != null) {
                    log.info("Client credentials were extracted from system properties. {}", (Object)"They weren't explicitly supplied as a Credentials object.");
                    return this;
                }
            }
            if (env != null) {
                this.credentials = this.extractCredentialsFromEnv(env);
                if (this.credentials != null) {
                    log.info("Client credentials were extracted from environment variables. {}", (Object)"They weren't explicitly supplied as a Credentials object or system properties.");
                    return this;
                }
            }
            return this;
        }

        private io.pravega.shared.security.auth.Credentials extractCredentialsFromProperties(Properties properties) {
            Map<String, String> retVal = properties.entrySet().stream().filter(entry -> entry.getKey().toString().startsWith(AUTH_PROPS_PREFIX)).collect(Collectors.toMap(entry -> entry.getKey().toString().substring(AUTH_PROPS_PREFIX.length()), value -> (String)value.getValue()));
            if (retVal.containsKey(AUTH_METHOD)) {
                return this.credentialFromMap(retVal);
            }
            return null;
        }

        private io.pravega.shared.security.auth.Credentials extractCredentialsFromEnv(Map<String, String> env) {
            Map<String, String> retVal = env.entrySet().stream().filter(entry -> ((String)entry.getKey()).toString().startsWith(AUTH_PROPS_PREFIX_ENV)).collect(Collectors.toMap(entry -> ((String)entry.getKey()).toString().replace("_", ".").substring(AUTH_PROPS_PREFIX.length()), value -> (String)value.getValue()));
            if (retVal.containsKey(AUTH_METHOD)) {
                return this.credentialFromMap(retVal);
            }
            return null;
        }

        private io.pravega.shared.security.auth.Credentials credentialFromMap(final Map<String, String> credsMap) {
            String expectedMethod = credsMap.get(AUTH_METHOD);
            if (credsMap.containsKey(AUTH_METHOD_LOAD_DYNAMIC) && Boolean.parseBoolean(credsMap.get(AUTH_METHOD_LOAD_DYNAMIC))) {
                ServiceLoader<io.pravega.shared.security.auth.Credentials> loader = ServiceLoader.load(io.pravega.shared.security.auth.Credentials.class);
                for (io.pravega.shared.security.auth.Credentials creds : loader) {
                    if (!creds.getAuthenticationType().equals(expectedMethod)) continue;
                    return creds;
                }
                ServiceLoader<Credentials> legacyCredentialsLoader = ServiceLoader.load(Credentials.class);
                for (io.pravega.shared.security.auth.Credentials credentials : legacyCredentialsLoader) {
                    if (!credentials.getAuthenticationType().equals(expectedMethod)) continue;
                    return credentials;
                }
                return null;
            }
            return new io.pravega.shared.security.auth.Credentials(){

                public String getAuthenticationType() {
                    return (String)credsMap.get(ClientConfigBuilder.AUTH_METHOD);
                }

                public String getAuthenticationToken() {
                    return (String)credsMap.get(ClientConfigBuilder.AUTH_TOKEN);
                }
            };
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        ClientConfigBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ClientConfigBuilder controllerURI(URI controllerURI) {
            this.controllerURI = controllerURI;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ClientConfigBuilder credentials(io.pravega.shared.security.auth.Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ClientConfigBuilder trustStore(String trustStore) {
            this.trustStore = trustStore;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ClientConfigBuilder validateHostName(boolean validateHostName) {
            this.validateHostName = validateHostName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ClientConfigBuilder maxConnectionsPerSegmentStore(int maxConnectionsPerSegmentStore) {
            this.maxConnectionsPerSegmentStore = maxConnectionsPerSegmentStore;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ClientConfigBuilder metricListener(MetricListener metricListener) {
            this.metricListener = metricListener;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ClientConfig.ClientConfigBuilder(controllerURI=" + this.controllerURI + ", credentials=" + this.credentials + ", trustStore=" + this.trustStore + ", validateHostName=" + this.validateHostName + ", maxConnectionsPerSegmentStore=" + this.maxConnectionsPerSegmentStore + ", deriveTlsEnabledFromControllerURI=" + this.deriveTlsEnabledFromControllerURI + ", enableTlsToController=" + this.enableTlsToController + ", enableTlsToSegmentStore=" + this.enableTlsToSegmentStore + ", metricListener=" + this.metricListener + ")";
        }
    }
}

