/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.InternalApi;
import com.google.api.gax.grpc.ChannelFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

class ChannelPool
extends ManagedChannel {
    private static final Logger LOG = Logger.getLogger(ChannelPool.class.getName());
    private static final int CHANNEL_REFRESH_EXECUTOR_SIZE = 2;
    private static final Duration REFRESH_PERIOD = Duration.ofMinutes((long)50L);
    private static final double JITTER_PERCENTAGE = 0.15;
    private final Object entryWriteLock = new Object();
    private final AtomicReference<ImmutableList<Entry>> entries = new AtomicReference();
    private final AtomicInteger indexTicker = new AtomicInteger();
    private final String authority;
    @Nullable
    private final ScheduledExecutorService channelRefreshExecutorService;
    private final ChannelFactory channelFactory;
    private volatile ScheduledFuture<?> nextScheduledRefresh = null;

    static ChannelPool create(int poolSize, ChannelFactory channelFactory) throws IOException {
        return new ChannelPool(channelFactory, poolSize, null);
    }

    @VisibleForTesting
    static ChannelPool createRefreshing(int poolSize, ChannelFactory channelFactory, ScheduledExecutorService channelRefreshExecutorService) throws IOException {
        return new ChannelPool(channelFactory, poolSize, channelRefreshExecutorService);
    }

    static ChannelPool createRefreshing(int poolSize, ChannelFactory channelFactory) throws IOException {
        return ChannelPool.createRefreshing(poolSize, channelFactory, Executors.newScheduledThreadPool(2));
    }

    private ChannelPool(ChannelFactory channelFactory, int poolSize, @Nullable ScheduledExecutorService channelRefreshExecutorService) throws IOException {
        this.channelFactory = channelFactory;
        ImmutableList.Builder initialListBuilder = ImmutableList.builder();
        for (int i = 0; i < poolSize; ++i) {
            initialListBuilder.add((Object)new Entry(channelFactory.createSingleChannel()));
        }
        this.entries.set((ImmutableList<Entry>)initialListBuilder.build());
        this.authority = ((Entry)this.entries.get().get(0)).channel.authority();
        this.channelRefreshExecutorService = channelRefreshExecutorService;
        if (channelRefreshExecutorService != null) {
            this.nextScheduledRefresh = this.scheduleNextRefresh();
        }
    }

    public String authority() {
        return this.authority;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions) {
        return this.getChannel(this.indexTicker.getAndIncrement()).newCall(methodDescriptor, callOptions);
    }

    Channel getChannel(int affinity) {
        return new AffinityChannel(affinity);
    }

    public ManagedChannel shutdown() {
        List localEntries = (List)this.entries.get();
        for (Entry entry : localEntries) {
            entry.channel.shutdown();
        }
        if (this.nextScheduledRefresh != null) {
            this.nextScheduledRefresh.cancel(true);
        }
        if (this.channelRefreshExecutorService != null) {
            this.channelRefreshExecutorService.shutdownNow();
        }
        return this;
    }

    public boolean isShutdown() {
        List localEntries = (List)this.entries.get();
        for (Entry entry : localEntries) {
            if (entry.channel.isShutdown()) continue;
            return false;
        }
        return this.channelRefreshExecutorService == null || this.channelRefreshExecutorService.isShutdown();
    }

    public boolean isTerminated() {
        List localEntries = (List)this.entries.get();
        for (Entry entry : localEntries) {
            if (entry.channel.isTerminated()) continue;
            return false;
        }
        return this.channelRefreshExecutorService == null || this.channelRefreshExecutorService.isTerminated();
    }

    public ManagedChannel shutdownNow() {
        List localEntries = (List)this.entries.get();
        for (Entry entry : localEntries) {
            entry.channel.shutdownNow();
        }
        if (this.nextScheduledRefresh != null) {
            this.nextScheduledRefresh.cancel(true);
        }
        if (this.channelRefreshExecutorService != null) {
            this.channelRefreshExecutorService.shutdownNow();
        }
        return this;
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long endTimeNanos = System.nanoTime() + unit.toNanos(timeout);
        List localEntries = (List)this.entries.get();
        for (Entry entry : localEntries) {
            long awaitTimeNanos = endTimeNanos - System.nanoTime();
            if (awaitTimeNanos <= 0L) break;
            entry.channel.awaitTermination(awaitTimeNanos, TimeUnit.NANOSECONDS);
        }
        if (this.channelRefreshExecutorService != null) {
            long awaitTimeNanos = endTimeNanos - System.nanoTime();
            this.channelRefreshExecutorService.awaitTermination(awaitTimeNanos, TimeUnit.NANOSECONDS);
        }
        return this.isTerminated();
    }

    private ScheduledFuture<?> scheduleNextRefresh() {
        long delayPeriod = REFRESH_PERIOD.toMillis();
        long jitter = (long)((Math.random() - 0.5) * 0.15 * (double)delayPeriod);
        long delay = jitter + delayPeriod;
        return this.channelRefreshExecutorService.schedule(() -> {
            this.scheduleNextRefresh();
            this.refresh();
        }, delay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InternalApi(value="Visible for testing")
    void refresh() {
        Object object = this.entryWriteLock;
        synchronized (object) {
            ArrayList<Entry> newEntries = new ArrayList<Entry>((Collection)this.entries.get());
            for (int i = 0; i < newEntries.size(); ++i) {
                try {
                    newEntries.set(i, new Entry(this.channelFactory.createSingleChannel()));
                    continue;
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "Failed to refresh channel, leaving old channel", e);
                }
            }
            ImmutableList<Entry> replacedEntries = this.entries.getAndSet((ImmutableList<Entry>)ImmutableList.copyOf(newEntries));
            for (Entry e : replacedEntries) {
                if (newEntries.contains(e)) continue;
                e.requestShutdown();
            }
        }
    }

    Entry getRetainedEntry(int affinity) {
        for (int i = 0; i < 5; ++i) {
            Entry entry = this.getEntry(affinity);
            if (!entry.retain()) continue;
            return entry;
        }
        throw new IllegalStateException("Bug: failed to retain a channel");
    }

    private Entry getEntry(int affinity) {
        List localEntries = (List)this.entries.get();
        int index = Math.abs(affinity % localEntries.size());
        return (Entry)localEntries.get(index);
    }

    static class ReleasingClientCall<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        final Entry entry;

        public ReleasingClientCall(ClientCall<ReqT, RespT> delegate, Entry entry) {
            super(delegate);
            this.entry = entry;
        }

        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
            try {
                super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    public void onClose(Status status, Metadata trailers) {
                        try {
                            super.onClose(status, trailers);
                        }
                        finally {
                            entry.release();
                        }
                    }
                }, headers);
            }
            catch (Exception e) {
                this.entry.release();
            }
        }
    }

    private class AffinityChannel
    extends Channel {
        private final int affinity;

        public AffinityChannel(int affinity) {
            this.affinity = affinity;
        }

        public String authority() {
            return ChannelPool.this.authority;
        }

        public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
            Entry entry = ChannelPool.this.getRetainedEntry(this.affinity);
            return new ReleasingClientCall(entry.channel.newCall(methodDescriptor, callOptions), entry);
        }
    }

    private static class Entry {
        private final ManagedChannel channel;
        private final AtomicInteger outstandingRpcs = new AtomicInteger(0);
        private final AtomicBoolean shutdownRequested = new AtomicBoolean();
        private final AtomicBoolean shutdownInitiated = new AtomicBoolean();

        private Entry(ManagedChannel channel) {
            this.channel = channel;
        }

        private boolean retain() {
            this.outstandingRpcs.incrementAndGet();
            if (this.shutdownRequested.get()) {
                this.release();
                return false;
            }
            return true;
        }

        private void release() {
            int newCount = this.outstandingRpcs.decrementAndGet();
            if (newCount < 0) {
                throw new IllegalStateException("Bug: reference count is negative!: " + newCount);
            }
            if (this.shutdownRequested.get() && this.outstandingRpcs.get() == 0) {
                this.shutdown();
            }
        }

        private void requestShutdown() {
            this.shutdownRequested.set(true);
            if (this.outstandingRpcs.get() == 0) {
                this.shutdown();
            }
        }

        private void shutdown() {
            if (this.shutdownInitiated.compareAndSet(false, true)) {
                this.channel.shutdown();
            }
        }
    }
}

