/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.serializer;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Page;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.implementation.TypeUtil;
import com.azure.core.implementation.UnixTime;
import com.azure.core.implementation.serializer.HttpResponseDecodeData;
import com.azure.core.implementation.serializer.ItemPage;
import com.azure.core.implementation.serializer.MalformedValueException;
import com.azure.core.util.Base64Url;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import reactor.core.publisher.Mono;

final class HttpResponseBodyDecoder {
    HttpResponseBodyDecoder() {
    }

    static Mono<Object> decode(String body, HttpResponse httpResponse, SerializerAdapter serializer, HttpResponseDecodeData decodeData) {
        HttpResponseBodyDecoder.ensureRequestSet(httpResponse);
        ClientLogger logger = new ClientLogger(HttpResponseBodyDecoder.class);
        return Mono.defer(() -> {
            if (HttpResponseBodyDecoder.isErrorStatus(httpResponse, decodeData)) {
                Mono bodyMono = body == null ? httpResponse.getBodyAsString() : Mono.just((Object)body);
                return bodyMono.flatMap(bodyString -> {
                    try {
                        Object decodedErrorEntity = HttpResponseBodyDecoder.deserializeBody(bodyString, decodeData.getUnexpectedException(httpResponse.getStatusCode()).getExceptionBodyType(), null, serializer, SerializerEncoding.fromHeaders(httpResponse.getHeaders()));
                        return Mono.justOrEmpty((Object)decodedErrorEntity);
                    }
                    catch (MalformedValueException | IOException ex) {
                        logger.warning("Failed to deserialize the error entity.", ex);
                        return Mono.empty();
                    }
                });
            }
            if (httpResponse.getRequest().getHttpMethod() == HttpMethod.HEAD) {
                return Mono.empty();
            }
            if (!HttpResponseBodyDecoder.isReturnTypeDecodable(decodeData.getReturnType())) {
                return Mono.empty();
            }
            Mono bodyMono = body == null ? httpResponse.getBodyAsString() : Mono.just((Object)body);
            return bodyMono.flatMap(bodyString -> {
                try {
                    Object decodedSuccessEntity = HttpResponseBodyDecoder.deserializeBody(bodyString, HttpResponseBodyDecoder.extractEntityTypeFromReturnType(decodeData), decodeData.getReturnValueWireType(), serializer, SerializerEncoding.fromHeaders(httpResponse.getHeaders()));
                    return Mono.justOrEmpty((Object)decodedSuccessEntity);
                }
                catch (MalformedValueException e) {
                    return Mono.error((Throwable)new HttpResponseException("HTTP response has a malformed body.", httpResponse, e));
                }
                catch (IOException e) {
                    return Mono.error((Throwable)new HttpResponseException("Deserialization Failed.", httpResponse, e));
                }
            });
        });
    }

    static Type decodedType(HttpResponse httpResponse, HttpResponseDecodeData decodeData) {
        HttpResponseBodyDecoder.ensureRequestSet(httpResponse);
        if (HttpResponseBodyDecoder.isErrorStatus(httpResponse, decodeData)) {
            return decodeData.getUnexpectedException(httpResponse.getStatusCode()).getExceptionBodyType();
        }
        if (httpResponse.getRequest().getHttpMethod() == HttpMethod.HEAD) {
            return null;
        }
        return HttpResponseBodyDecoder.isReturnTypeDecodable(decodeData.getReturnType()) ? HttpResponseBodyDecoder.extractEntityTypeFromReturnType(decodeData) : null;
    }

    static boolean isErrorStatus(HttpResponse httpResponse, HttpResponseDecodeData decodeData) {
        int[] expectedStatuses = decodeData.getExpectedStatusCodes();
        int statusCode = httpResponse.getStatusCode();
        if (expectedStatuses != null) {
            return Arrays.stream(expectedStatuses).noneMatch(expectedCode -> expectedCode == statusCode);
        }
        return statusCode / 100 != 2;
    }

    private static Object deserializeBody(String value, Type resultType, Type wireType, SerializerAdapter serializer, SerializerEncoding encoding) throws IOException {
        if (wireType == null) {
            return serializer.deserialize(value, resultType, encoding);
        }
        if (TypeUtil.isTypeOrSubTypeOf(wireType, Page.class)) {
            return HttpResponseBodyDecoder.deserializePage(value, resultType, wireType, serializer, encoding);
        }
        Type wireResponseType = HttpResponseBodyDecoder.constructWireResponseType(resultType, wireType);
        Object wireResponse = serializer.deserialize(value, wireResponseType, encoding);
        return HttpResponseBodyDecoder.convertToResultType(wireResponse, resultType, wireType);
    }

    private static Type constructWireResponseType(Type resultType, Type wireType) {
        Objects.requireNonNull(wireType);
        Object wireResponseType = resultType;
        if (resultType == byte[].class) {
            if (wireType == Base64Url.class) {
                wireResponseType = Base64Url.class;
            }
        } else if (resultType == OffsetDateTime.class) {
            if (wireType == DateTimeRfc1123.class) {
                wireResponseType = DateTimeRfc1123.class;
            } else if (wireType == UnixTime.class) {
                wireResponseType = UnixTime.class;
            }
        } else if (TypeUtil.isTypeOrSubTypeOf(resultType, List.class)) {
            Type resultElementType = TypeUtil.getTypeArgument(resultType);
            Type wireResponseElementType = HttpResponseBodyDecoder.constructWireResponseType(resultElementType, wireType);
            wireResponseType = TypeUtil.createParameterizedType((Class)((ParameterizedType)resultType).getRawType(), wireResponseElementType);
        } else if (TypeUtil.isTypeOrSubTypeOf(resultType, Map.class)) {
            Type[] typeArguments = TypeUtil.getTypeArguments(resultType);
            Type resultValueType = typeArguments[1];
            Type wireResponseValueType = HttpResponseBodyDecoder.constructWireResponseType(resultValueType, wireType);
            wireResponseType = TypeUtil.createParameterizedType((Class)((ParameterizedType)resultType).getRawType(), typeArguments[0], wireResponseValueType);
        }
        return wireResponseType;
    }

    private static Object deserializePage(String value, Type resultType, Type wireType, SerializerAdapter serializer, SerializerEncoding encoding) throws IOException {
        Type wireResponseType = wireType == Page.class ? TypeUtil.createParameterizedType(ItemPage.class, resultType) : wireType;
        return serializer.deserialize(value, wireResponseType, encoding);
    }

    private static Object convertToResultType(Object wireResponse, Type resultType, Type wireType) {
        Object result = wireResponse;
        if (resultType == byte[].class) {
            if (wireType == Base64Url.class) {
                result = ((Base64Url)wireResponse).decodedBytes();
            }
        } else if (resultType == OffsetDateTime.class) {
            if (wireType == DateTimeRfc1123.class) {
                result = ((DateTimeRfc1123)wireResponse).getDateTime();
            } else if (wireType == UnixTime.class) {
                result = ((UnixTime)wireResponse).getDateTime();
            }
        } else if (TypeUtil.isTypeOrSubTypeOf(resultType, List.class)) {
            Type resultElementType = TypeUtil.getTypeArgument(resultType);
            List wireResponseList = (List)wireResponse;
            int wireResponseListSize = wireResponseList.size();
            for (int i = 0; i < wireResponseListSize; ++i) {
                Object resultElement;
                Object wireResponseElement = wireResponseList.get(i);
                if (wireResponseElement == (resultElement = HttpResponseBodyDecoder.convertToResultType(wireResponseElement, resultElementType, wireType))) continue;
                wireResponseList.set(i, resultElement);
            }
            result = wireResponseList;
        } else if (TypeUtil.isTypeOrSubTypeOf(resultType, Map.class)) {
            Type resultValueType = TypeUtil.getTypeArguments(resultType)[1];
            Map wireResponseMap = (Map)wireResponse;
            Set wireResponseEntries = wireResponseMap.entrySet();
            for (Map.Entry wireResponseEntry : wireResponseEntries) {
                Object resultValue;
                Object wireResponseValue = wireResponseEntry.getValue();
                if (wireResponseValue == (resultValue = HttpResponseBodyDecoder.convertToResultType(wireResponseValue, resultValueType, wireType))) continue;
                wireResponseMap.put((String)wireResponseEntry.getKey(), resultValue);
            }
            result = wireResponseMap;
        }
        return result;
    }

    private static Type extractEntityTypeFromReturnType(HttpResponseDecodeData decodeData) {
        Type token = decodeData.getReturnType();
        if (TypeUtil.isTypeOrSubTypeOf(token, Mono.class)) {
            token = TypeUtil.getTypeArgument(token);
        }
        if (TypeUtil.isTypeOrSubTypeOf(token, Response.class)) {
            token = TypeUtil.getRestResponseBodyType(token);
        }
        return token;
    }

    private static boolean isReturnTypeDecodable(Type returnType) {
        ParameterizedType parameterizedType;
        if (returnType == null) {
            return false;
        }
        if (TypeUtil.isTypeOrSubTypeOf(returnType, Mono.class)) {
            returnType = TypeUtil.getTypeArgument(returnType);
        }
        if (TypeUtil.isTypeOrSubTypeOf(returnType, ResponseBase.class) && (parameterizedType = (ParameterizedType)TypeUtil.getSuperType(returnType, ResponseBase.class)).getActualTypeArguments().length == 2) {
            returnType = parameterizedType.getActualTypeArguments()[1];
        }
        return !FluxUtil.isFluxByteBuffer(returnType) && !TypeUtil.isTypeOrSubTypeOf(returnType, byte[].class) && !TypeUtil.isTypeOrSubTypeOf(returnType, Void.TYPE) && !TypeUtil.isTypeOrSubTypeOf(returnType, Void.class);
    }

    private static void ensureRequestSet(HttpResponse httpResponse) {
        Objects.requireNonNull(httpResponse.getRequest());
        Objects.requireNonNull(httpResponse.getRequest().getHttpMethod());
    }
}

