/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.Response;
import com.azure.core.implementation.TypeUtil;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

public final class FluxUtil {
    private static final int DEFAULT_CHUNK_SIZE = 65536;

    public static boolean isFluxByteBuffer(Type entityType) {
        if (TypeUtil.isTypeOrSubTypeOf(entityType, Flux.class)) {
            Type innerType = TypeUtil.getTypeArguments(entityType)[0];
            return TypeUtil.isTypeOrSubTypeOf(innerType, ByteBuffer.class);
        }
        return false;
    }

    public static Mono<byte[]> collectBytesInByteBufferStream(Flux<ByteBuffer> stream) {
        return stream.collect(ByteArrayOutputStream::new, FluxUtil::accept).map(ByteArrayOutputStream::toByteArray);
    }

    private static void accept(ByteArrayOutputStream byteOutputStream, ByteBuffer byteBuffer) {
        try {
            byteOutputStream.write(FluxUtil.byteBufferToArray(byteBuffer));
        }
        catch (IOException e) {
            throw new RuntimeException("Error occurred writing ByteBuffer to ByteArrayOutputStream.", e);
        }
    }

    public static byte[] byteBufferToArray(ByteBuffer byteBuffer) {
        int length = byteBuffer.remaining();
        byte[] byteArray = new byte[length];
        byteBuffer.get(byteArray);
        return byteArray;
    }

    public static Flux<ByteBuffer> toFluxByteBuffer(InputStream inputStream) {
        return FluxUtil.toFluxByteBuffer(inputStream, 4096);
    }

    public static Flux<ByteBuffer> toFluxByteBuffer(InputStream inputStream, int chunkSize) {
        if (chunkSize <= 0) {
            return Flux.error((Throwable)new IllegalArgumentException("'chunkSize' must be greater than 0."));
        }
        if (inputStream == null) {
            return Flux.empty();
        }
        return Flux.generate(() -> inputStream, (stream, sink) -> {
            byte[] buffer = new byte[chunkSize];
            try {
                int readCount;
                for (int offset = 0; offset < chunkSize; offset += readCount) {
                    readCount = inputStream.read(buffer, offset, chunkSize - offset);
                    if (readCount != -1) continue;
                    if (offset > 0) {
                        sink.next((Object)ByteBuffer.wrap(buffer, 0, offset));
                    }
                    sink.complete();
                    return stream;
                }
                sink.next((Object)ByteBuffer.wrap(buffer));
            }
            catch (IOException ex) {
                sink.error((Throwable)ex);
            }
            return stream;
        }).filter(Buffer::hasRemaining);
    }

    public static <T> Mono<T> withContext(Function<Context, Mono<T>> serviceCall) {
        return FluxUtil.withContext(serviceCall, Collections.emptyMap());
    }

    public static <T> Mono<T> withContext(Function<Context, Mono<T>> serviceCall, Map<String, String> contextAttributes) {
        return Mono.subscriberContext().map(context -> {
            Map<Object, Object> keyValues = context.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (!CoreUtils.isNullOrEmpty(contextAttributes)) {
                contextAttributes.forEach(keyValues::putIfAbsent);
            }
            return CoreUtils.isNullOrEmpty(keyValues) ? Context.NONE : Context.of(keyValues);
        }).flatMap(serviceCall);
    }

    public static <T> Mono<T> toMono(Response<T> response) {
        return Mono.justOrEmpty(response.getValue());
    }

    public static <T> Mono<T> monoError(ClientLogger logger, RuntimeException ex) {
        return Mono.error((Throwable)logger.logExceptionAsError(Exceptions.propagate((Throwable)ex)));
    }

    public static <T> Flux<T> fluxError(ClientLogger logger, RuntimeException ex) {
        return Flux.error((Throwable)logger.logExceptionAsError(Exceptions.propagate((Throwable)ex)));
    }

    public static <T> PagedFlux<T> pagedFluxError(ClientLogger logger, RuntimeException ex) {
        return new PagedFlux(() -> FluxUtil.monoError(logger, ex));
    }

    public static <T> Flux<T> fluxContext(Function<Context, Flux<T>> serviceCall) {
        return Mono.subscriberContext().map(FluxUtil::toAzureContext).flatMapMany(serviceCall);
    }

    private static Context toAzureContext(reactor.util.context.Context context) {
        Map<Object, Object> keyValues = context.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return CoreUtils.isNullOrEmpty(keyValues) ? Context.NONE : Context.of(keyValues);
    }

    public static reactor.util.context.Context toReactorContext(Context context) {
        if (context == null) {
            return reactor.util.context.Context.empty();
        }
        Map<Object, Object> contextValues = context.getValues().entrySet().stream().filter(kvp -> kvp.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return CoreUtils.isNullOrEmpty(contextValues) ? reactor.util.context.Context.empty() : reactor.util.context.Context.of(contextValues);
    }

    public static Mono<Void> writeFile(Flux<ByteBuffer> content, AsynchronousFileChannel outFile) {
        return FluxUtil.writeFile(content, outFile, 0L);
    }

    public static Mono<Void> writeFile(Flux<ByteBuffer> content, final AsynchronousFileChannel outFile, final long position) {
        return Mono.create(emitter -> content.subscribe((Subscriber)new Subscriber<ByteBuffer>(){
            volatile boolean isWriting = false;
            volatile boolean isCompleted = false;
            volatile Subscription subscription;
            volatile long pos = position;
            final CompletionHandler onWriteCompleted = new CompletionHandler<Integer, Object>(){

                @Override
                public void completed(Integer bytesWritten, Object attachment) {
                    isWriting = false;
                    if (isCompleted) {
                        emitter.success();
                    }
                    pos += (long)bytesWritten.intValue();
                    subscription.request(1L);
                }

                @Override
                public void failed(Throwable exc, Object attachment) {
                    subscription.cancel();
                    emitter.error(exc);
                }
            };

            public void onSubscribe(Subscription s) {
                this.subscription = s;
                s.request(1L);
            }

            public void onNext(ByteBuffer bytes) {
                this.isWriting = true;
                outFile.write(bytes, this.pos, null, this.onWriteCompleted);
            }

            public void onError(Throwable throwable) {
                this.subscription.cancel();
                emitter.error(throwable);
            }

            public void onComplete() {
                this.isCompleted = true;
                if (!this.isWriting) {
                    emitter.success();
                }
            }
        }));
    }

    public static Flux<ByteBuffer> readFile(AsynchronousFileChannel fileChannel, int chunkSize, long offset, long length) {
        return new FileReadFlux(fileChannel, chunkSize, offset, length);
    }

    public static Flux<ByteBuffer> readFile(AsynchronousFileChannel fileChannel, long offset, long length) {
        return FluxUtil.readFile(fileChannel, 65536, offset, length);
    }

    public static Flux<ByteBuffer> readFile(AsynchronousFileChannel fileChannel) {
        try {
            long size = fileChannel.size();
            return FluxUtil.readFile(fileChannel, 65536, 0L, size);
        }
        catch (IOException e) {
            return Flux.error((Throwable)new RuntimeException("Failed to read the file.", e));
        }
    }

    private FluxUtil() {
    }

    private static final class FileReadFlux
    extends Flux<ByteBuffer> {
        private final AsynchronousFileChannel fileChannel;
        private final int chunkSize;
        private final long offset;
        private final long length;

        FileReadFlux(AsynchronousFileChannel fileChannel, int chunkSize, long offset, long length) {
            this.fileChannel = fileChannel;
            this.chunkSize = chunkSize;
            this.offset = offset;
            this.length = length;
        }

        public void subscribe(CoreSubscriber<? super ByteBuffer> actual) {
            FileReadSubscription subscription = new FileReadSubscription((Subscriber<? super ByteBuffer>)actual, this.fileChannel, this.chunkSize, this.offset, this.length);
            actual.onSubscribe((Subscription)subscription);
        }

        static final class FileReadSubscription
        implements Subscription,
        CompletionHandler<Integer, ByteBuffer> {
            private static final int NOT_SET = -1;
            private static final long serialVersionUID = -6831808726875304256L;
            private final Subscriber<? super ByteBuffer> subscriber;
            private volatile long position;
            private final AsynchronousFileChannel fileChannel;
            private final int chunkSize;
            private final long offset;
            private final long length;
            private volatile boolean done;
            private Throwable error;
            private volatile ByteBuffer next;
            private volatile boolean cancelled;
            volatile int wip;
            static final AtomicIntegerFieldUpdater<FileReadSubscription> WIP = AtomicIntegerFieldUpdater.newUpdater(FileReadSubscription.class, "wip");
            volatile long requested;
            static final AtomicLongFieldUpdater<FileReadSubscription> REQUESTED = AtomicLongFieldUpdater.newUpdater(FileReadSubscription.class, "requested");

            FileReadSubscription(Subscriber<? super ByteBuffer> subscriber, AsynchronousFileChannel fileChannel, int chunkSize, long offset, long length) {
                this.subscriber = subscriber;
                this.fileChannel = fileChannel;
                this.chunkSize = chunkSize;
                this.offset = offset;
                this.length = length;
                this.position = -1L;
            }

            public void request(long n) {
                if (Operators.validate((long)n)) {
                    Operators.addCap(REQUESTED, (Object)this, (long)n);
                    this.drain();
                }
            }

            public void cancel() {
                this.cancelled = true;
            }

            @Override
            public void completed(Integer bytesRead, ByteBuffer buffer) {
                if (!this.cancelled) {
                    if (bytesRead == -1) {
                        this.done = true;
                    } else {
                        long position2;
                        long pos = this.position;
                        int bytesWanted = Math.min(bytesRead, this.maxRequired(pos));
                        this.position = position2 = pos + (long)bytesWanted;
                        buffer.position(bytesWanted);
                        buffer.flip();
                        this.next = buffer;
                        if (position2 >= this.offset + this.length) {
                            this.done = true;
                        }
                    }
                    this.drain();
                }
            }

            @Override
            public void failed(Throwable exc, ByteBuffer attachment) {
                if (!this.cancelled) {
                    this.error = exc;
                    this.done = true;
                    this.drain();
                }
            }

            private void drain() {
                if (WIP.getAndIncrement(this) != 0) {
                    return;
                }
                if (this.position == -1L) {
                    this.position = this.offset;
                    this.doRead();
                }
                int missed = 1;
                do {
                    if (this.cancelled) {
                        return;
                    }
                    if (REQUESTED.get(this) <= 0L) continue;
                    boolean emitted = false;
                    boolean d = this.done;
                    ByteBuffer bb = this.next;
                    if (bb != null) {
                        this.next = null;
                        this.subscriber.onNext((Object)bb);
                        emitted = true;
                    }
                    if (d) {
                        if (this.error != null) {
                            this.subscriber.onError(this.error);
                        } else {
                            this.subscriber.onComplete();
                        }
                        return;
                    }
                    if (!emitted) continue;
                    Operators.produced(REQUESTED, (Object)this, (long)1L);
                    this.doRead();
                } while ((missed = WIP.addAndGet(this, -missed)) != 0);
            }

            private void doRead() {
                long pos = this.position;
                ByteBuffer innerBuf = ByteBuffer.allocate(Math.min(this.chunkSize, this.maxRequired(pos)));
                this.fileChannel.read(innerBuf, pos, innerBuf, this);
            }

            private int maxRequired(long pos) {
                long maxRequired = this.offset + this.length - pos;
                if (maxRequired <= 0L) {
                    return 0;
                }
                int m = (int)maxRequired;
                if (m < 0) {
                    return Integer.MAX_VALUE;
                }
                return m;
            }
        }
    }
}

