/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.protocol.netty;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.shared.protocol.netty.ReplyProcessor;
import io.pravega.shared.protocol.netty.WireCommands;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FailingReplyProcessor
implements ReplyProcessor {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FailingReplyProcessor.class);

    @Override
    public void hello(WireCommands.Hello hello) {
        if (hello.getLowVersion() > 11 || hello.getHighVersion() < 5) {
            log.error("Incompatible wire protocol versions {}", (Object)hello);
        } else {
            log.info("Received hello: {}", (Object)hello);
        }
    }

    @Override
    public void operationUnsupported(WireCommands.OperationUnsupported operationUnsupported) {
        throw new UnsupportedOperationException("Operation '" + operationUnsupported.getOperationName() + "' is not supported on the target SegmentStore.");
    }

    @Override
    public void wrongHost(WireCommands.WrongHost wrongHost) {
        throw new IllegalStateException("Wrong host. Segment: " + wrongHost.segment + " is on " + wrongHost.correctHost);
    }

    @Override
    public void segmentIsSealed(WireCommands.SegmentIsSealed segmentIsSealed) {
        throw new IllegalStateException("Segment is sealed: " + segmentIsSealed.segment);
    }

    @Override
    public void segmentIsTruncated(WireCommands.SegmentIsTruncated segmentIsTruncated) {
        throw new IllegalStateException("Segment is truncated: " + segmentIsTruncated.segment + " at offset " + segmentIsTruncated.startOffset);
    }

    @Override
    public void segmentAlreadyExists(WireCommands.SegmentAlreadyExists segmentAlreadyExists) {
        throw new IllegalStateException("Segment already exists: " + segmentAlreadyExists.segment);
    }

    @Override
    public void noSuchSegment(WireCommands.NoSuchSegment noSuchSegment) {
        throw new IllegalStateException("No such segment: " + noSuchSegment.segment);
    }

    @Override
    public void invalidEventNumber(WireCommands.InvalidEventNumber invalidEventNumber) {
        throw new IllegalStateException("Invalid event number: " + invalidEventNumber);
    }

    @Override
    public void appendSetup(WireCommands.AppendSetup appendSetup) {
        throw new IllegalStateException("Unexpected operation: " + appendSetup);
    }

    @Override
    public void dataAppended(WireCommands.DataAppended dataAppended) {
        throw new IllegalStateException("Unexpected operation: " + dataAppended);
    }

    @Override
    public void conditionalCheckFailed(WireCommands.ConditionalCheckFailed dataNotAppended) {
        throw new IllegalStateException("Conditional check failed for event: " + dataNotAppended.eventNumber);
    }

    @Override
    public void segmentRead(WireCommands.SegmentRead data) {
        throw new IllegalStateException("Unexpected operation: " + data);
    }

    @Override
    public void segmentAttributeUpdated(WireCommands.SegmentAttributeUpdated segmentAttributeUpdated) {
        throw new IllegalStateException("Unexpected operation: " + segmentAttributeUpdated);
    }

    @Override
    public void segmentAttribute(WireCommands.SegmentAttribute segmentAttribute) {
        throw new IllegalStateException("Unexpected operation: " + segmentAttribute);
    }

    @Override
    public void streamSegmentInfo(WireCommands.StreamSegmentInfo streamInfo) {
        throw new IllegalStateException("Unexpected operation: " + streamInfo);
    }

    @Override
    public void segmentCreated(WireCommands.SegmentCreated streamsSegmentCreated) {
        throw new IllegalStateException("Unexpected operation: " + streamsSegmentCreated);
    }

    @Override
    public void segmentsMerged(WireCommands.SegmentsMerged segmentsMerged) {
        throw new IllegalStateException("Unexpected operation: " + segmentsMerged);
    }

    @Override
    public void segmentSealed(WireCommands.SegmentSealed segmentSealed) {
        throw new IllegalStateException("Unexpected operation: " + segmentSealed);
    }

    @Override
    public void segmentTruncated(WireCommands.SegmentTruncated segmentTruncated) {
        throw new IllegalStateException("Unexpected operation: " + segmentTruncated);
    }

    @Override
    public void segmentDeleted(WireCommands.SegmentDeleted segmentDeleted) {
        throw new IllegalStateException("Unexpected operation: " + segmentDeleted);
    }

    @Override
    public void authTokenCheckFailed(WireCommands.AuthTokenCheckFailed authFailed) {
        throw new IllegalStateException("Unexpected operation: " + authFailed);
    }

    @Override
    public void tableEntriesUpdated(WireCommands.TableEntriesUpdated tableEntriesUpdated) {
        throw new IllegalStateException("Unexpected operation: " + tableEntriesUpdated);
    }

    @Override
    public void tableKeysRemoved(WireCommands.TableKeysRemoved tableKeysRemoved) {
        throw new IllegalStateException("Unexpected operation: " + tableKeysRemoved);
    }

    @Override
    public void tableRead(WireCommands.TableRead tableRead) {
        throw new IllegalStateException("Unexpected operation: " + tableRead);
    }

    @Override
    public void tableSegmentNotEmpty(WireCommands.TableSegmentNotEmpty tableSegmentNotEmpty) {
        throw new IllegalStateException("Unexpected operation: " + tableSegmentNotEmpty);
    }

    @Override
    public void segmentPolicyUpdated(WireCommands.SegmentPolicyUpdated segment) {
        throw new IllegalStateException("Unexpected operation: " + segment);
    }

    @Override
    public void keepAlive(WireCommands.KeepAlive keepAlive) {
        log.trace("KeepAlive received");
    }

    @Override
    public void tableKeyDoesNotExist(WireCommands.TableKeyDoesNotExist tableKeyDoesNotExist) {
        throw new IllegalStateException("Unexpected operation: " + tableKeyDoesNotExist);
    }

    @Override
    public void tableKeyBadVersion(WireCommands.TableKeyBadVersion tableKeyBadVersion) {
        throw new IllegalStateException("Unexpected operation: " + tableKeyBadVersion);
    }

    @Override
    public void tableKeysRead(WireCommands.TableKeysRead tableKeysRead) {
        throw new IllegalStateException("Unexpected operation: " + tableKeysRead);
    }

    @Override
    public void tableEntriesRead(WireCommands.TableEntriesRead tableEntriesRead) {
        throw new IllegalStateException("Unexpected operation: " + tableEntriesRead);
    }

    @Override
    public void tableEntriesDeltaRead(WireCommands.TableEntriesDeltaRead tableEntriesDeltaRead) {
        throw new IllegalStateException("Unexpected operation: " + tableEntriesDeltaRead);
    }

    @Override
    public void errorMessage(WireCommands.ErrorMessage errorMessage) {
        throw new IllegalStateException("Unexpected operation: " + errorMessage);
    }
}

