/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.pravega;

import io.debezium.engine.ChangeEvent;
import io.debezium.engine.DebeziumEngine;
import io.debezium.server.BaseChangeConsumer;
import io.debezium.server.pravega.PravegaSink;
import io.pravega.client.ClientConfig;
import io.pravega.client.EventStreamClientFactory;
import io.pravega.client.stream.EventStreamWriter;
import io.pravega.client.stream.EventWriterConfig;
import io.pravega.client.stream.Serializer;
import io.pravega.client.stream.Transaction;
import io.pravega.client.stream.TransactionalEventStreamWriter;
import io.pravega.client.stream.TxnFailedException;
import io.pravega.client.stream.impl.ByteArraySerializer;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.inject.Named;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="pravega")
@Dependent
public class PravegaChangeConsumer
extends BaseChangeConsumer
implements DebeziumEngine.ChangeConsumer<ChangeEvent<Object, Object>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PravegaChangeConsumer.class);
    private static final String PROP_PREFIX = "debezium.sink.pravega.";
    private static final String PROP_CONTROLLER = "debezium.sink.pravega.controller.uri";
    private static final String PROP_SCOPE = "debezium.sink.pravega.scope";
    private static final String PROP_TXN = "debezium.sink.pravega.transaction";
    @ConfigProperty(name="debezium.sink.pravega.controller.uri", defaultValue="tcp://localhost:9090")
    URI controllerUri;
    private String scope;
    @ConfigProperty(name="debezium.sink.pravega.transaction", defaultValue="false")
    boolean txn;
    private ClientConfig clientConfig;
    private EventStreamClientFactory factory;
    private EventWriterConfig writerConfig;

    @PostConstruct
    void constructor() {
        this.scope = (String)ConfigProvider.getConfig().getValue(PROP_SCOPE, String.class);
        this.clientConfig = ClientConfig.builder().controllerURI(this.controllerUri).build();
        LOGGER.debug("Creating client factory for scope {} with controller {}", (Object)this.scope, (Object)this.controllerUri);
        this.factory = EventStreamClientFactory.withScope((String)this.scope, (ClientConfig)this.clientConfig);
        this.writerConfig = EventWriterConfig.builder().build();
    }

    @PreDestroy
    void destructor() {
        LOGGER.debug("Closing client factory");
        this.factory.close();
    }

    public void handleBatch(List<ChangeEvent<Object, Object>> records, DebeziumEngine.RecordCommitter<ChangeEvent<Object, Object>> committer) throws InterruptedException {
        try (PravegaSink impl = this.txn ? new PravegaTxnSinkImpl() : new PravegaSinkImpl();){
            impl.handleBatch(records, committer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    class PravegaTxnSinkImpl
    implements PravegaSink {
        private final Map<String, TransactionalEventStreamWriter<byte[]>> writers = new HashMap<String, TransactionalEventStreamWriter<byte[]>>();
        private final Map<String, Transaction<byte[]>> txns = new HashMap<String, Transaction<byte[]>>();

        PravegaTxnSinkImpl() {
        }

        public void handleBatch(List<ChangeEvent<Object, Object>> records, DebeziumEngine.RecordCommitter<ChangeEvent<Object, Object>> committer) throws InterruptedException {
            for (ChangeEvent<Object, Object> changeEvent : records) {
                String streamName = PravegaChangeConsumer.this.streamNameMapper.map(changeEvent.destination());
                Transaction txn = this.txns.computeIfAbsent(streamName, stream -> this.createTxn((String)stream));
                try {
                    if (changeEvent.key() != null) {
                        txn.writeEvent(PravegaChangeConsumer.this.getString(changeEvent.key()), (Object)PravegaChangeConsumer.this.getBytes(changeEvent.value()));
                    } else {
                        txn.writeEvent((Object)PravegaChangeConsumer.this.getBytes(changeEvent.value()));
                    }
                }
                catch (TxnFailedException e) {
                    throw new RuntimeException(e);
                }
                committer.markProcessed(changeEvent);
            }
            this.txns.values().forEach(t -> {
                try {
                    t.commit();
                }
                catch (TxnFailedException e) {
                    throw new RuntimeException(e);
                }
            });
            committer.markBatchFinished();
            this.txns.clear();
        }

        private Transaction<byte[]> createTxn(String stream) {
            TransactionalEventStreamWriter writer = this.writers.computeIfAbsent(stream, s -> this.createWriter((String)s));
            LOGGER.debug("Creating transaction for stream {}", (Object)stream);
            return writer.beginTxn();
        }

        private TransactionalEventStreamWriter<byte[]> createWriter(String stream) {
            LOGGER.debug("Creating writer for stream {}", (Object)stream);
            return PravegaChangeConsumer.this.factory.createTransactionalEventWriter(stream, (Serializer)new ByteArraySerializer(), PravegaChangeConsumer.this.writerConfig);
        }

        @Override
        public void close() throws Exception {
            LOGGER.debug("Closing {} writer(s)", (Object)this.writers.size());
            this.writers.values().forEach(TransactionalEventStreamWriter::close);
        }
    }

    class PravegaSinkImpl
    implements PravegaSink {
        private final Map<String, EventStreamWriter<byte[]>> writers = new HashMap<String, EventStreamWriter<byte[]>>();

        PravegaSinkImpl() {
        }

        public void handleBatch(List<ChangeEvent<Object, Object>> records, DebeziumEngine.RecordCommitter<ChangeEvent<Object, Object>> committer) throws InterruptedException {
            for (ChangeEvent<Object, Object> changeEvent : records) {
                String streamName = PravegaChangeConsumer.this.streamNameMapper.map(changeEvent.destination());
                EventStreamWriter writer = this.writers.computeIfAbsent(streamName, stream -> this.createWriter((String)stream));
                if (changeEvent.key() != null) {
                    writer.writeEvent(PravegaChangeConsumer.this.getString(changeEvent.key()), (Object)PravegaChangeConsumer.this.getBytes(changeEvent.value()));
                } else {
                    writer.writeEvent((Object)PravegaChangeConsumer.this.getBytes(changeEvent.value()));
                }
                committer.markProcessed(changeEvent);
            }
            committer.markBatchFinished();
        }

        private EventStreamWriter<byte[]> createWriter(String stream) {
            LOGGER.debug("Creating writer for stream {}", (Object)stream);
            return PravegaChangeConsumer.this.factory.createEventWriter(stream, (Serializer)new ByteArraySerializer(), PravegaChangeConsumer.this.writerConfig);
        }

        @Override
        public void close() throws Exception {
            LOGGER.debug("Closing {} writer(s)", (Object)this.writers.size());
            this.writers.values().forEach(EventStreamWriter::close);
        }
    }
}

