/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.exception.AmqpResponseCode;
import java.util.Map;
import java.util.function.Function;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.message.Message;

public class RequestResponseUtils {
    public static final AmqpResponseCode UNDEFINED_STATUS_CODE = AmqpResponseCode.UNUSED;
    public static final String UNDEFINED_STATUS_DESCRIPTION = "";
    public static final String UNDEFINED_ERROR_CONDITION = "";
    private static final String STATUS_CODE = "statusCode";
    private static final String STATUS_DESCRIPTION = "statusDescription";
    private static final String ERROR_CONDITION = "errorCondition";
    private static final String LEGACY_STATUS_CODE = "status-code";
    private static final String LEGACY_STATUS_DESCRIPTION = "status-description";
    private static final String LEGACY_ERROR_CONDITION = "error-condition";

    public static boolean isSuccessful(Message message) {
        AmqpResponseCode statusCode = RequestResponseUtils.getStatusCode(message);
        return statusCode == AmqpResponseCode.OK || statusCode == AmqpResponseCode.ACCEPTED;
    }

    public static AmqpResponseCode getStatusCode(Message message) {
        int value;
        Map properties = message.getApplicationProperties().getValue();
        if (properties == null) {
            return UNDEFINED_STATUS_CODE;
        }
        if (properties.containsKey(STATUS_CODE)) {
            value = (Integer)properties.get(STATUS_CODE);
        } else if (properties.containsKey(LEGACY_STATUS_CODE)) {
            value = (Integer)properties.get(LEGACY_STATUS_CODE);
        } else {
            return UNDEFINED_STATUS_CODE;
        }
        AmqpResponseCode statusCode = AmqpResponseCode.fromValue(value);
        return statusCode != null ? statusCode : UNDEFINED_STATUS_CODE;
    }

    public static String getStatusDescription(Message message) {
        Map properties = message.getApplicationProperties().getValue();
        if (properties == null) {
            return "";
        }
        if (properties.containsKey(STATUS_DESCRIPTION)) {
            return String.valueOf(properties.get(STATUS_DESCRIPTION));
        }
        if (properties.containsKey(LEGACY_STATUS_DESCRIPTION)) {
            return String.valueOf(properties.get(LEGACY_STATUS_DESCRIPTION));
        }
        return "";
    }

    public static String getErrorCondition(Message message) {
        Map properties = message.getApplicationProperties().getValue();
        Function<Object, String> getCondition = errorCondition -> {
            if (errorCondition instanceof Symbol) {
                return ((Symbol)errorCondition).toString();
            }
            return String.valueOf(errorCondition);
        };
        if (properties == null) {
            return "";
        }
        if (properties.containsKey(ERROR_CONDITION)) {
            return getCondition.apply(properties.get(ERROR_CONDITION));
        }
        if (properties.containsKey(LEGACY_ERROR_CONDITION)) {
            return getCondition.apply(properties.get(LEGACY_ERROR_CONDITION));
        }
        return "";
    }
}

