/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.builtins.BigIntPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.cast.JSToIntegerNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.intl.InitializeNumberFormatNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSBigInt;
import com.oracle.truffle.js.runtime.builtins.JSNumberFormat;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class BigIntPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<BigIntPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new BigIntPrototypeBuiltins();

    protected BigIntPrototypeBuiltins() {
        super("BigInt.prototype", BigIntPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, BigIntPrototype builtinEnum) {
        switch (builtinEnum) {
            case toLocaleString: {
                if (context.isOptionIntl402()) {
                    return BigIntPrototypeBuiltinsFactory.JSBigIntToLocaleStringIntlNodeGen.create(context, builtin, BigIntPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
                }
                return BigIntPrototypeBuiltinsFactory.JSBigIntToLocaleStringNodeGen.create(context, builtin, BigIntPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case toString: {
                return BigIntPrototypeBuiltinsFactory.JSBigIntToStringNodeGen.create(context, builtin, BigIntPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case valueOf: {
                return BigIntPrototypeBuiltinsFactory.JSBigIntValueOfNodeGen.create(context, builtin, BigIntPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class JSBigIntValueOfNode
    extends JSBigIntOperation {
        public JSBigIntValueOfNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected BigInt valueOfBigInt(BigInt thisObj) {
            return thisObj;
        }

        @Specialization(guards={"isJSBigInt(thisObj)"})
        protected BigInt valueOf(DynamicObject thisObj) {
            return JSBigInt.valueOf(thisObj);
        }

        @Fallback
        protected void valueOf(Object thisObj) {
            throw Errors.createTypeError("BigInt.prototype.valueOf requires that 'this' be a BigInt");
        }
    }

    public static abstract class JSBigIntToLocaleStringNode
    extends JSBigIntOperation {
        public JSBigIntToLocaleStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected String toLocaleStringBigInt(BigInt thisObj) {
            return JSBigIntToLocaleStringNode.toLocaleStringImpl(thisObj);
        }

        @Specialization(guards={"isJSBigInt(thisObj)"})
        protected String toLocaleStringJSBigInt(DynamicObject thisObj) {
            return JSBigIntToLocaleStringNode.toLocaleStringImpl(this.getBigIntValue(thisObj));
        }

        private static String toLocaleStringImpl(BigInt bi) {
            return bi.toString();
        }

        @Fallback
        protected String failForNonBigInts(Object thisObject) {
            throw this.noBigIntFailure(thisObject);
        }
    }

    public static abstract class JSBigIntToLocaleStringIntlNode
    extends JSBigIntOperation {
        @Node.Child
        InitializeNumberFormatNode initNumberFormatNode;

        public JSBigIntToLocaleStringIntlNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.initNumberFormatNode = InitializeNumberFormatNode.createInitalizeNumberFormatNode(context);
        }

        @CompilerDirectives.TruffleBoundary
        private DynamicObject createNumberFormat(Object locales, Object options) {
            DynamicObject numberFormatObj = JSNumberFormat.create(this.getContext());
            this.initNumberFormatNode.executeInit(numberFormatObj, locales, options);
            return numberFormatObj;
        }

        @Specialization
        protected String bigIntToLocaleString(BigInt thisObj, Object locales, Object options) {
            DynamicObject numberFormatObj = this.createNumberFormat(locales, options);
            return JSNumberFormat.format(numberFormatObj, thisObj);
        }

        @Specialization(guards={"isJSBigInt(thisObj)"})
        protected String jsBigIntToLocaleString(DynamicObject thisObj, Object locales, Object options) {
            DynamicObject numberFormatObj = this.createNumberFormat(locales, options);
            return JSNumberFormat.format(numberFormatObj, this.getBigIntValue(thisObj));
        }

        @Fallback
        protected String failForNonBigInts(Object notANumber, Object locales, Object options) {
            throw this.noBigIntFailure(notANumber);
        }
    }

    public static abstract class JSBigIntToStringNode
    extends JSBigIntOperation {
        private final BranchProfile radixErrorBranch = BranchProfile.create();

        public JSBigIntToStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected boolean isRadix10(Object radix) {
            return radix == Undefined.instance || radix instanceof Integer && (Integer)radix == 10;
        }

        @Specialization(guards={"isUndefined(radix)"})
        protected String toStringBigIntRadix10(BigInt thisObj, Object radix) {
            return this.toStringImpl(thisObj, 10);
        }

        @Specialization(guards={"!isUndefined(radix)"})
        protected String toStringBigInt(BigInt thisObj, Object radix) {
            return this.toStringImpl(thisObj, radix);
        }

        @Specialization(guards={"isJSBigInt(thisObj)", "isUndefined(radix)"})
        protected String toStringRadix10(DynamicObject thisObj, Object radix) {
            return this.toStringImpl(JSBigInt.valueOf(thisObj), 10);
        }

        @Specialization(guards={"isJSBigInt(thisObj)", "!isUndefined(radix)"})
        protected String toString(DynamicObject thisObj, Object radix) {
            return this.toStringImpl(JSBigInt.valueOf(thisObj), radix);
        }

        @Fallback
        protected void toStringNoBigInt(Object thisObj, Object radix) {
            throw Errors.createTypeError("BigInt.prototype.toString requires that 'this' be a BigInt");
        }

        private String toStringImpl(BigInt numberVal, Object radix) {
            int radixVal = this.toInteger(radix);
            if (radixVal < 2 || radixVal > 36) {
                this.radixErrorBranch.enter();
                throw Errors.createRangeError("toString() expects radix in range 2-36");
            }
            return numberVal.toString(radixVal);
        }
    }

    public static abstract class JSBigIntOperation
    extends JSBuiltinNode {
        @Node.Child
        private JSToIntegerNode toIntegerNode;

        public JSBigIntOperation(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        protected JSException noBigIntFailure(Object value) {
            throw Errors.createTypeError(String.format("%s is not a BigInt", JSRuntime.safeToString(value)));
        }

        protected BigInt getBigIntValue(DynamicObject obj) {
            return JSBigInt.valueOf(obj);
        }

        protected int toInteger(Object target) {
            if (this.toIntegerNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toIntegerNode = (JSToIntegerNode)this.insert(JSToIntegerNode.create());
            }
            return this.toIntegerNode.executeInt(target);
        }
    }

    public static enum BigIntPrototype implements BuiltinEnum<BigIntPrototype>
    {
        toLocaleString(0),
        toString(0),
        valueOf(0);

        private final int length;

        private BigIntPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

