/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSTargetableNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;

public class GetMethodNode
extends JSTargetableNode {
    @Node.Child
    private JavaScriptNode targetNode;
    @Node.Child
    private PropertyGetNode cacheNode;
    @Node.Child
    private IsCallableNode isCallableNode;
    private final ConditionProfile undefinedOrNull = ConditionProfile.createBinaryProfile();
    private final BranchProfile notCallableBranch = BranchProfile.create();

    protected GetMethodNode(JSContext context, JavaScriptNode target, Object propertyKey) {
        this.targetNode = target;
        this.cacheNode = PropertyGetNode.create(propertyKey, false, context);
        this.isCallableNode = IsCallableNode.create();
    }

    public static GetMethodNode create(JSContext ctx, JavaScriptNode target, Object key) {
        return new GetMethodNode(ctx, target, key);
    }

    @Override
    public Object executeWithTarget(VirtualFrame frame, Object target) {
        return this.executeWithTarget(target);
    }

    public Object executeWithTarget(Object target) {
        Object method = this.cacheNode.getValue(target);
        if (this.isCallableNode.executeBoolean(method)) {
            return method;
        }
        if (this.undefinedOrNull.profile(method == Undefined.instance || method == Null.instance)) {
            return Undefined.instance;
        }
        this.notCallableBranch.enter();
        throw Errors.createTypeErrorNotAFunction(method, this);
    }

    @Override
    public Object evaluateTarget(VirtualFrame frame) {
        return this.targetNode.execute(frame);
    }

    @Override
    public JavaScriptNode getTarget() {
        return this.targetNode;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.executeWithTarget(this.evaluateTarget(frame));
    }

    final JSContext getContext() {
        return this.cacheNode.getContext();
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return new GetMethodNode(this.getContext(), GetMethodNode.cloneUninitialized(this.targetNode), this.cacheNode.getKey());
    }
}

