/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.access.JSProxyCallNodeGen;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.truffleinterop.JSInteropUtil;

@NodeInfo(cost=NodeCost.NONE)
@ImportStatic(value={JSProxy.class, JSArguments.class})
public abstract class JSProxyCallNode
extends JavaScriptBaseNode {
    private final JSContext context;
    @Node.Child
    private GetMethodNode trapGetter;
    @Node.Child
    private JSFunctionCallNode callNode;
    @Node.Child
    private JSFunctionCallNode callTrapNode;
    protected final boolean isNew;
    protected final boolean isNewTarget;
    private final ConditionProfile callableProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile pxTrapFunProfile = ConditionProfile.createBinaryProfile();

    protected JSProxyCallNode(JSContext context, boolean isNew, boolean isNewTarget) {
        this.callNode = isNewTarget ? JSFunctionCallNode.createNewTarget() : (isNew ? JSFunctionCallNode.createNew() : JSFunctionCallNode.createCall());
        this.callTrapNode = isNewTarget || isNew ? JSFunctionCallNode.createCall() : this.callNode;
        this.trapGetter = GetMethodNode.create(context, null, isNewTarget || isNew ? "construct" : "apply");
        this.context = context;
        this.isNew = isNew;
        this.isNewTarget = isNewTarget;
    }

    public abstract Object execute(Object[] var1);

    public static JSProxyCallNode create(JSContext context, boolean isNew, boolean isNewTarget) {
        return JSProxyCallNodeGen.create(context, isNew, isNewTarget);
    }

    @Specialization(guards={"!isNew", "!isNewTarget"})
    protected Object doCall(Object[] arguments) {
        Object thisObj = JSArguments.getThisObject(arguments);
        Object function = JSArguments.getFunctionObject(arguments);
        assert (JSProxy.isProxy(function));
        DynamicObject proxy = (DynamicObject)function;
        if (!this.callableProfile.profile(JSRuntime.isCallableProxy(proxy))) {
            throw Errors.createTypeErrorNotAFunction(function, this);
        }
        DynamicObject pxHandler = JSProxy.getHandlerChecked(proxy);
        Object pxTarget = JSProxy.getTarget(proxy);
        Object pxTrapFun = this.trapGetter.executeWithTarget(pxHandler);
        Object[] proxyArguments = JSArguments.extractUserArguments(arguments);
        if (this.pxTrapFunProfile.profile(pxTrapFun == Undefined.instance)) {
            return this.callNode.executeCall(JSArguments.create(thisObj, pxTarget, proxyArguments));
        }
        Object[] trapArgs = new Object[]{pxTarget, thisObj, JSArray.createConstant(this.context, proxyArguments)};
        return this.callTrapNode.executeCall(JSArguments.create(pxHandler, pxTrapFun, trapArgs));
    }

    @Specialization(guards={"isNew || isNewTarget"})
    protected Object doConstruct(Object[] arguments) {
        Object function = JSArguments.getFunctionObject(arguments);
        assert (JSProxy.isProxy(function));
        DynamicObject proxy = (DynamicObject)function;
        if (!this.callableProfile.profile(JSRuntime.isConstructorProxy(proxy))) {
            throw Errors.createTypeErrorNotAFunction(function, this);
        }
        DynamicObject pxHandler = JSProxy.getHandlerChecked(proxy);
        Object pxTarget = JSProxy.getTarget(proxy);
        Object pxTrapFun = this.trapGetter.executeWithTarget(pxHandler);
        Object newTarget = this.isNewTarget ? JSArguments.getNewTarget(arguments) : proxy;
        Object[] constructorArguments = JSArguments.extractUserArguments(arguments, this.isNewTarget ? 1 : 0);
        if (this.pxTrapFunProfile.profile(pxTrapFun == Undefined.instance)) {
            if (!JSObject.isJSObject(pxTarget)) {
                return JSInteropUtil.construct(pxTarget, constructorArguments);
            }
            return this.callNode.executeCall(this.isNewTarget ? JSArguments.createWithNewTarget(JSFunction.CONSTRUCT, pxTarget, newTarget, constructorArguments) : JSArguments.create(JSFunction.CONSTRUCT, pxTarget, constructorArguments));
        }
        Object[] trapArgs = new Object[]{pxTarget, JSArray.createConstant(this.context, constructorArguments), newTarget};
        Object result = this.callTrapNode.executeCall(JSArguments.create(pxHandler, pxTrapFun, trapArgs));
        if (!JSRuntime.isObject(result)) {
            throw Errors.createTypeErrorNotAnObject(result, this);
        }
        return result;
    }
}

