/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameUtil;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.ReadNode;
import com.oracle.truffle.js.nodes.access.JSReadFrameSlotNode;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import java.util.ArrayList;

public abstract class LazyReadFrameSlotNode
extends JavaScriptNode
implements ReadNode {
    protected final Object identifier;

    public LazyReadFrameSlotNode(Object identifier) {
        this.identifier = identifier;
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    public static LazyReadFrameSlotNode create(Object identifier) {
        return new LazyReadFrameSlotUninitNode(identifier);
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return this.copy();
    }

    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class LazyReadFrameSlotUninitNode
    extends LazyReadFrameSlotNode {
        LazyReadFrameSlotUninitNode(Object identifier) {
            super(identifier);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            VirtualFrame outerFrame = frame;
            int frameLevel = 0;
            while (true) {
                VirtualFrame outerScope = outerFrame;
                ArrayList<FrameSlot> parentSlotList = new ArrayList<FrameSlot>();
                int scopeLevel = 0;
                while (true) {
                    FrameSlot slot;
                    if ((slot = outerScope.getFrameDescriptor().findFrameSlot(this.identifier)) != null) {
                        FrameSlot[] parentSlots = parentSlotList.toArray(ScopeFrameNode.EMPTY_FRAME_SLOT_ARRAY);
                        JSReadFrameSlotNode resolved = JSReadFrameSlotNode.create(slot, ScopeFrameNode.create(frameLevel, scopeLevel, parentSlots), JSFrameUtil.hasTemporalDeadZone(slot));
                        return ((JSReadFrameSlotNode)this.replace(resolved)).execute(frame);
                    }
                    FrameSlot parentSlot = outerScope.getFrameDescriptor().findFrameSlot(ScopeFrameNode.PARENT_SCOPE_IDENTIFIER);
                    if (parentSlot == null) break;
                    outerScope = (Frame)FrameUtil.getObjectSafe((Frame)outerScope, (FrameSlot)parentSlot);
                    parentSlotList.add(parentSlot);
                    ++scopeLevel;
                }
                outerFrame = JSArguments.getEnclosingFrame(outerFrame.getArguments());
                if (outerFrame == JSFrameUtil.NULL_MATERIALIZED_FRAME) break;
                ++frameLevel;
            }
            throw new RuntimeException("frame slot not found");
        }
    }
}

