/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.GlobalObjectNode;
import com.oracle.truffle.js.nodes.access.HasPropertyCacheNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class WithTargetNode
extends JavaScriptNode {
    @Node.Child
    private JavaScriptNode withVariable;
    @Node.Child
    private HasPropertyCacheNode withObjectHasProperty;
    @Node.Child
    private HasPropertyCacheNode globalObjectHasProperty;
    @Node.Child
    private PropertyGetNode withObjectGetUnscopables;
    @Node.Child
    private PropertyGetNode unscopablesGetProperty;
    @Node.Child
    private JSToBooleanNode toBoolean;
    private final JSContext context;

    private WithTargetNode(JSContext context, String propertyName, JavaScriptNode withVariable) {
        this.withVariable = withVariable;
        this.context = context;
        this.withObjectHasProperty = HasPropertyCacheNode.create(propertyName, context);
        this.globalObjectHasProperty = HasPropertyCacheNode.create(propertyName, context);
        this.withObjectGetUnscopables = PropertyGetNode.create(Symbol.SYMBOL_UNSCOPABLES, false, context);
        this.unscopablesGetProperty = PropertyGetNode.create(propertyName, false, context);
        this.toBoolean = JSToBooleanNode.create();
    }

    public static JavaScriptNode create(JSContext context, String propertyName, JavaScriptNode withVariable) {
        return new WithTargetNode(context, propertyName, withVariable);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object target = this.withVariable.execute(frame);
        if (this.withObjectHasProperty.hasProperty(target) && this.isPropertyScopable(target)) {
            return target;
        }
        if (this.context.isOptionNashornCompatibilityMode() && this.hasNoSuchProperty(target, false) && !this.globalObjectHasProperty.hasProperty(GlobalObjectNode.getGlobalObject(this.context))) {
            return target;
        }
        return Undefined.instance;
    }

    private boolean isPropertyScopable(Object target) {
        if (this.context.getEcmaScriptVersion() >= 6) {
            if (JSObject.isJSObject(target)) {
                boolean blocked;
                Object unscopables = this.withObjectGetUnscopables.getValue(target);
                if (JSRuntime.isObject(unscopables) && (blocked = this.toBoolean.executeBoolean(this.unscopablesGetProperty.getValue(unscopables)))) {
                    return false;
                }
            } else {
                return true;
            }
        }
        return true;
    }

    private boolean hasNoSuchProperty(Object thisTruffleObj, boolean isMethod) {
        if (JSRuntime.isObject(thisTruffleObj)) {
            DynamicObject thisObj = (DynamicObject)thisTruffleObj;
            if (!isMethod && !this.context.getNoSuchPropertyUnusedAssumption().isValid() && JSObject.hasOwnProperty(thisObj, "__noSuchProperty__") || isMethod && !this.context.getNoSuchMethodUnusedAssumption().isValid() && JSObject.hasOwnProperty(thisObj, "__noSuchMethod__")) {
                return WithTargetNode.hasNoSuchPropertyImpl(thisObj, isMethod);
            }
        }
        return false;
    }

    private static boolean hasNoSuchPropertyImpl(DynamicObject thisObj, boolean isMethod) {
        assert (JSRuntime.isObject(thisObj));
        Object function = JSObject.get(thisObj, (Object)(isMethod ? "__noSuchMethod__" : "__noSuchProperty__"));
        return JSFunction.isJSFunction(function);
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return new WithTargetNode(this.context, (String)this.withObjectHasProperty.getKey(), WithTargetNode.cloneUninitialized(this.withVariable));
    }
}

