/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.control.AbstractBlockNode;
import com.oracle.truffle.js.nodes.control.SequenceNode;

public final class ExprBlockNode
extends AbstractBlockNode
implements SequenceNode {
    ExprBlockNode(JavaScriptNode[] statements) {
        super(statements);
    }

    public static JavaScriptNode createExprBlock(JavaScriptNode[] statements) {
        return ExprBlockNode.filterStatements(statements, true);
    }

    @Override
    @ExplodeLoop
    public boolean executeBoolean(VirtualFrame frame) throws UnexpectedResultException {
        JavaScriptNode[] stmts = this.statements;
        int last = stmts.length - 1;
        for (int i = 0; i < last; ++i) {
            this.executeVoid(frame, stmts[i], i, 0);
        }
        return this.executeBoolean(frame, stmts[last], last, 0);
    }

    @Override
    @ExplodeLoop
    public int executeInt(VirtualFrame frame) throws UnexpectedResultException {
        JavaScriptNode[] stmts = this.statements;
        int last = stmts.length - 1;
        for (int i = 0; i < last; ++i) {
            this.executeVoid(frame, stmts[i], i, 0);
        }
        return this.executeInt(frame, stmts[last], last, 0);
    }

    @Override
    @ExplodeLoop
    public double executeDouble(VirtualFrame frame) throws UnexpectedResultException {
        JavaScriptNode[] stmts = this.statements;
        int last = stmts.length - 1;
        for (int i = 0; i < last; ++i) {
            this.executeVoid(frame, stmts[i], i, 0);
        }
        return this.executeDouble(frame, stmts[last], last, 0);
    }

    public boolean executeBoolean(VirtualFrame frame, JavaScriptNode node, int index, int argument) throws UnexpectedResultException {
        return node.executeBoolean(frame);
    }

    public int executeInt(VirtualFrame frame, JavaScriptNode node, int index, int argument) throws UnexpectedResultException {
        return node.executeInt(frame);
    }

    public double executeDouble(VirtualFrame frame, JavaScriptNode node, int index, int argument) throws UnexpectedResultException {
        return node.executeDouble(frame);
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return new ExprBlockNode(ExprBlockNode.cloneUninitialized(this.getStatements()));
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return this.getStatements()[this.getStatements().length - 1].isResultAlwaysOfType(clazz);
    }
}

