/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.interop.ExportValueNodeGen;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.LargeInteger;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.truffleinterop.InteropAsyncFunction;
import com.oracle.truffle.js.runtime.truffleinterop.InteropBoundFunction;

@ImportStatic(value={JSTruffleOptions.class, JSFunction.class})
@GenerateUncached
public abstract class ExportValueNode
extends JavaScriptBaseNode {
    ExportValueNode() {
    }

    public final Object execute(Object value) {
        return this.execute(value, Undefined.instance, false);
    }

    public abstract Object execute(Object var1, Object var2, boolean var3);

    @Specialization(guards={"isJSFunction(function)", "!bindFunctions", "!InteropCompletePromises || !isAsyncFunction(function)"})
    protected static DynamicObject doFunctionNoBind(DynamicObject function, Object thiz, boolean bindFunctions) {
        return function;
    }

    @Specialization(guards={"isJSFunction(function)", "bindFunctions", "isUndefined(thiz)", "!InteropCompletePromises || !isAsyncFunction(function)"})
    protected static DynamicObject doFunctionUndefinedThis(DynamicObject function, Object thiz, boolean bindFunctions) {
        return function;
    }

    @Specialization(guards={"isJSFunction(function)", "bindFunctions", "!isUndefined(thiz)", "!isBoundJSFunction(function)", "!InteropCompletePromises || !isAsyncFunction(function)"})
    protected static TruffleObject doBindUnboundFunction(DynamicObject function, Object thiz, boolean bindFunctions) {
        return new InteropBoundFunction(function, thiz);
    }

    @Specialization(guards={"isJSFunction(function)", "bindFunctions", "isBoundJSFunction(function)", "!InteropCompletePromises || !isAsyncFunction(function)"})
    protected static DynamicObject doBoundFunction(DynamicObject function, Object thiz, boolean bindFunctions) {
        return function;
    }

    @Specialization(guards={"isJSFunction(function)", "InteropCompletePromises", "isAsyncFunction(function)"})
    protected static TruffleObject doAsyncFunction(DynamicObject function, Object thiz, boolean bindFunctions) {
        return new InteropAsyncFunction(function);
    }

    @Specialization
    protected static double doLargeInteger(LargeInteger value, Object thiz, boolean bindFunctions) {
        return value.doubleValue();
    }

    @Specialization(guards={"!isJSFunction(value)"})
    protected static DynamicObject doObject(DynamicObject value, Object thiz, boolean bindFunctions) {
        return value;
    }

    @Specialization
    protected static int doInt(int value, Object thiz, boolean bindFunctions) {
        return value;
    }

    @Specialization
    protected static long doLong(long value, Object thiz, boolean bindFunctions) {
        return value;
    }

    @Specialization
    protected static double doDouble(double value, Object thiz, boolean bindFunctions) {
        return value;
    }

    @Specialization
    protected static boolean doBoolean(boolean value, Object thiz, boolean bindFunctions) {
        return value;
    }

    @Specialization
    protected static BigInt doBigInt(BigInt value, Object thiz, boolean bindFunctions) {
        return value;
    }

    @Specialization
    protected static String doString(String value, Object thiz, boolean bindFunctions) {
        return value;
    }

    @Specialization(guards={"!isJSFunction(value)"}, replaces={"doObject"})
    protected static TruffleObject doTruffleObject(TruffleObject value, Object thiz, boolean bindFunctions) {
        return value;
    }

    @CompilerDirectives.TruffleBoundary
    @Fallback
    protected static final Object doOther(Object value, Object thiz, boolean bindFunctions) {
        throw Errors.createTypeErrorFormat("Cannot convert to TruffleObject: %s", value == null ? null : value.getClass().getSimpleName());
    }

    public static ExportValueNode create() {
        return ExportValueNodeGen.create();
    }
}

