/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.intl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.JSHasPropertyNode;
import com.oracle.truffle.js.nodes.array.JSGetLengthNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.intl.JSToCanonicalizedLocaleListNode;
import com.oracle.truffle.js.nodes.unary.TypeOfNode;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSToCanonicalizedLocaleListNode.class)
public final class JSToCanonicalizedLocaleListNodeGen
extends JSToCanonicalizedLocaleListNode
implements Introspection.Provider {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private int state_;
    @Node.Child
    private OtherTypeData otherType_cache;
    @Node.Child
    private ForeignTypeData foreignType_cache;

    private JSToCanonicalizedLocaleListNodeGen(JSContext context) {
        super(context);
    }

    @Override
    public String[] executeLanguageTags(Object arg0Value) {
        int state = this.state_;
        if ((state & 1) != 0 && JSTypesGen.isImplicitString((state & 0x3C0) >>> 6, arg0Value)) {
            String arg0Value_ = JSTypesGen.asImplicitString((state & 0x3C0) >>> 6, arg0Value);
            return this.doRawString(arg0Value_);
        }
        if ((state & 0xE) != 0 && JSTypes.isDynamicObject(arg0Value)) {
            DynamicObject arg0Value_ = (DynamicObject)arg0Value;
            if ((state & 2) != 0 && JSGuards.isJSString(arg0Value_)) {
                return this.doString(arg0Value_);
            }
            if ((state & 4) != 0 && JSGuards.isJSNull(arg0Value_)) {
                return this.doNull(arg0Value_);
            }
            if ((state & 8) != 0 && JSGuards.isUndefined(arg0Value_)) {
                return this.doUndefined(arg0Value_);
            }
        }
        if ((state & 0x30) != 0) {
            ForeignTypeData s6_;
            OtherTypeData s5_;
            if (!((state & 0x10) == 0 || (s5_ = this.otherType_cache) == null || JSGuards.isForeignObject(arg0Value) || JSGuards.isString(arg0Value) || JSGuards.isJSString(arg0Value) || JSGuards.isUndefined(arg0Value) || JSGuards.isJSNull(arg0Value))) {
                return this.doOtherType(arg0Value, s5_.toObjectNode_, s5_.getLengthNode_, s5_.hasPropertyNode_, s5_.typeOfNode_, s5_.toStringNode_);
            }
            if ((state & 0x20) != 0 && (s6_ = this.foreignType_cache) != null && JSGuards.isForeignObject(arg0Value)) {
                return this.doForeignType(arg0Value, s6_.interop_, s6_.typeOfNode_, s6_.toStringNode_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private String[] executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            int stringCast0 = JSTypesGen.specializeImplicitString(arg0Value);
            if (stringCast0 != 0) {
                String arg0Value_ = JSTypesGen.asImplicitString(stringCast0, arg0Value);
                state |= stringCast0 << 6;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                String[] stringArray = this.doRawString(arg0Value_);
                return stringArray;
            }
            if (JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                if (JSGuards.isJSString(arg0Value_)) {
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    String[] stringArray = this.doString(arg0Value_);
                    return stringArray;
                }
                if (JSGuards.isJSNull(arg0Value_)) {
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    String[] stringArray = this.doNull(arg0Value_);
                    return stringArray;
                }
                if (JSGuards.isUndefined(arg0Value_)) {
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    String[] stringArray = this.doUndefined(arg0Value_);
                    return stringArray;
                }
            }
            if (!(JSGuards.isForeignObject(arg0Value) || JSGuards.isString(arg0Value) || JSGuards.isJSString(arg0Value) || JSGuards.isUndefined(arg0Value) || JSGuards.isJSNull(arg0Value))) {
                OtherTypeData s5_ = (OtherTypeData)super.insert((Node)new OtherTypeData());
                s5_.toObjectNode_ = s5_.insertAccessor(JSToObjectNode.createToObject(this.context));
                s5_.getLengthNode_ = s5_.insertAccessor(JSGetLengthNode.create(this.context));
                s5_.hasPropertyNode_ = s5_.insertAccessor(JSHasPropertyNode.create());
                s5_.typeOfNode_ = s5_.insertAccessor(TypeOfNode.create());
                s5_.toStringNode_ = s5_.insertAccessor(JSToStringNode.create());
                this.otherType_cache = s5_;
                this.state_ = state |= 0x10;
                lock.unlock();
                hasLock = false;
                String[] stringArray = this.doOtherType(arg0Value, s5_.toObjectNode_, s5_.getLengthNode_, s5_.hasPropertyNode_, s5_.typeOfNode_, s5_.toStringNode_);
                return stringArray;
            }
            if (JSGuards.isForeignObject(arg0Value)) {
                ForeignTypeData s6_ = (ForeignTypeData)super.insert((Node)new ForeignTypeData());
                s6_.interop_ = (InteropLibrary)s6_.insertAccessor(INTEROP_LIBRARY_.createDispatched(1));
                s6_.typeOfNode_ = s6_.insertAccessor(TypeOfNode.create());
                s6_.toStringNode_ = s6_.insertAccessor(JSToStringNode.create());
                this.foreignType_cache = s6_;
                this.state_ = state |= 0x20;
                lock.unlock();
                hasLock = false;
                String[] stringArray = this.doForeignType(arg0Value, s6_.interop_, s6_.typeOfNode_, s6_.toStringNode_);
                return stringArray;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0x3F) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x3F & (state & 0x3F) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<JavaScriptBaseNode>> cached;
        Object[] data = new Object[7];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doRawString";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doString";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doNull";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doUndefined";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doOtherType";
        if ((state & 0x10) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<JavaScriptBaseNode>>();
            OtherTypeData s5_ = this.otherType_cache;
            if (s5_ != null) {
                cached.add(Arrays.asList(new JavaScriptBaseNode[]{s5_.toObjectNode_, s5_.getLengthNode_, s5_.hasPropertyNode_, s5_.typeOfNode_, s5_.toStringNode_}));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[5] = s;
        s = new Object[3];
        s[0] = "doForeignType";
        if ((state & 0x20) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            ForeignTypeData s6_ = this.foreignType_cache;
            if (s6_ != null) {
                cached.add(Arrays.asList(new Node[]{s6_.interop_, s6_.typeOfNode_, s6_.toStringNode_}));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[6] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSToCanonicalizedLocaleListNode create(JSContext context) {
        return new JSToCanonicalizedLocaleListNodeGen(context);
    }

    @GeneratedBy(value=JSToCanonicalizedLocaleListNode.class)
    private static final class ForeignTypeData
    extends Node {
        @Node.Child
        InteropLibrary interop_;
        @Node.Child
        TypeOfNode typeOfNode_;
        @Node.Child
        JSToStringNode toStringNode_;

        ForeignTypeData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=JSToCanonicalizedLocaleListNode.class)
    private static final class OtherTypeData
    extends Node {
        @Node.Child
        JSToObjectNode toObjectNode_;
        @Node.Child
        JSGetLengthNode getLengthNode_;
        @Node.Child
        JSHasPropertyNode hasPropertyNode_;
        @Node.Child
        TypeOfNode typeOfNode_;
        @Node.Child
        JSToStringNode toStringNode_;

        OtherTypeData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

