/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.TruffleStackTrace;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.JavaScriptFunctionCallNode;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.UserScriptException;
import com.oracle.truffle.js.runtime.builtins.JSError;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class GraalJSException
extends RuntimeException
implements TruffleException {
    private static final long serialVersionUID = -6624166672101791072L;
    private static final JSStackTraceElement[] EMPTY_STACK_TRACE = new JSStackTraceElement[0];
    private JSStackTraceElement[] jsStackTrace;
    private Object location;
    private int stackTraceLimit;
    private static final String DYNAMIC_FUNCTION_NAME = "anonymous";

    protected GraalJSException(String message, Throwable cause, Node node, int stackTraceLimit) {
        super(message, cause);
        this.location = node;
        this.stackTraceLimit = stackTraceLimit;
        this.jsStackTrace = stackTraceLimit == 0 ? EMPTY_STACK_TRACE : null;
    }

    protected GraalJSException(String message, Node node, int stackTraceLimit) {
        super(message);
        this.location = node;
        this.stackTraceLimit = stackTraceLimit;
        this.jsStackTrace = stackTraceLimit == 0 ? EMPTY_STACK_TRACE : null;
    }

    protected GraalJSException(String message, SourceSection location, int stackTraceLimit) {
        super(message);
        this.location = location;
        this.stackTraceLimit = stackTraceLimit;
        this.jsStackTrace = stackTraceLimit == 0 ? EMPTY_STACK_TRACE : null;
    }

    protected static <T extends GraalJSException> T fillInStackTrace(T exception, DynamicObject skipFramesUpTo, boolean capture) {
        exception.fillInStackTrace(skipFramesUpTo, capture);
        return exception;
    }

    protected final GraalJSException fillInStackTrace(DynamicObject skipFramesUpTo, boolean capture) {
        assert (capture || skipFramesUpTo == Undefined.instance);
        assert (this.jsStackTrace == (this.stackTraceLimit == 0 ? EMPTY_STACK_TRACE : null));
        if ((capture || JSTruffleOptions.EagerStackTrace) && this.stackTraceLimit > 0) {
            this.jsStackTrace = this.getJSStackTrace(skipFramesUpTo);
        }
        return this;
    }

    public Node getLocation() {
        return this.location instanceof Node ? (Node)this.location : null;
    }

    public SourceSection getSourceLocation() {
        if (this.location instanceof SourceSection) {
            return (SourceSection)this.location;
        }
        return super.getSourceLocation();
    }

    public Object getExceptionObject() {
        Object error = this.getErrorObject();
        return error == null ? null : JSRuntime.exportValue(error);
    }

    public int getStackTraceElementLimit() {
        if (this.stackTraceLimit <= 0) {
            return 0;
        }
        return -1;
    }

    public abstract Object getErrorObject();

    public abstract Object getErrorObjectEager(JSContext var1);

    @Override
    @CompilerDirectives.TruffleBoundary
    public final Throwable fillInStackTrace() {
        if (JSTruffleOptions.FillExceptionStack) {
            return super.fillInStackTrace();
        }
        return null;
    }

    public JSStackTraceElement[] getJSStackTrace() {
        if (this.jsStackTrace != null) {
            return this.jsStackTrace;
        }
        this.jsStackTrace = this.materializeJSStackTrace();
        return this.jsStackTrace;
    }

    @CompilerDirectives.TruffleBoundary
    private JSStackTraceElement[] materializeJSStackTrace() {
        return this.getJSStackTrace(Undefined.instance);
    }

    @CompilerDirectives.TruffleBoundary
    private JSStackTraceElement[] getJSStackTrace(DynamicObject skipUpTo) {
        TruffleStackTraceElement element;
        assert (this.stackTraceLimit > 0);
        boolean nashornMode = JavaScriptLanguage.getCurrentJSRealm().getContext().isOptionNashornCompatibilityMode();
        DynamicObject skipFramesUpTo = nashornMode ? Undefined.instance : skipUpTo;
        List stackTrace = TruffleStackTrace.getStackTrace((Throwable)this);
        if (stackTrace == null) {
            return EMPTY_STACK_TRACE;
        }
        FrameVisitorImpl visitor = new FrameVisitorImpl(this.getLocation(), this.stackTraceLimit, skipFramesUpTo, nashornMode);
        Iterator iterator = stackTrace.iterator();
        while (iterator.hasNext() && visitor.visitFrame(element = (TruffleStackTraceElement)iterator.next())) {
        }
        return visitor.getStackTrace().toArray(EMPTY_STACK_TRACE);
    }

    public void setJSStackTrace(JSStackTraceElement[] jsStackTrace) {
        this.jsStackTrace = jsStackTrace;
    }

    @CompilerDirectives.TruffleBoundary
    public static JSStackTraceElement[] getJSStackTrace(Node originatingNode) {
        return UserScriptException.createCapture("", originatingNode, JSTruffleOptions.StackTraceLimit, Undefined.instance).getJSStackTrace();
    }

    private static JSStackTraceElement processJSFrame(RootNode rootNode, Node node, Object thisObj, DynamicObject functionObj, boolean inStrictMode, boolean inNashornMode) {
        Node callNode = node;
        while (callNode.getSourceSection() == null) {
            callNode = callNode.getParent();
        }
        SourceSection callNodeSourceSection = callNode.getSourceSection();
        Source source = callNodeSourceSection.getSource();
        String fileName = GraalJSException.getFileName(source);
        String functionName = JSFunction.isBuiltin(functionObj) ? JSFunction.getName(functionObj) : rootNode.getName();
        boolean eval = false;
        if (GraalJSException.isEvalSource(source)) {
            functionName = "eval";
            eval = true;
        } else if (functionName == null || GraalJSException.isInternalFunctionName(functionName)) {
            functionName = "";
        }
        SourceSection targetSourceSection = null;
        if (!inNashornMode && callNode instanceof JavaScriptFunctionCallNode) {
            Node target = ((JavaScriptFunctionCallNode)callNode).getTarget();
            targetSourceSection = target == null ? null : target.getSourceSection();
        }
        boolean global = GraalJSException.isGlobalObject(thisObj, JSFunction.getRealm(functionObj));
        return new JSStackTraceElement(fileName, functionName, callNodeSourceSection, thisObj, functionObj, targetSourceSection, inStrictMode, eval, global, inNashornMode);
    }

    private static boolean isEvalSource(Source source) {
        return source != null && source.getName().startsWith("eval at ");
    }

    private static boolean isInternalFunctionName(String functionName) {
        return functionName.length() >= 1 && functionName.charAt(0) == ':';
    }

    private static boolean isGlobalObject(Object object, JSRealm realm) {
        return JSObject.isJSObject(object) && realm != null && realm.getGlobalObject() == object;
    }

    private static JSStackTraceElement processForeignFrame(Node node, boolean strict, boolean inNashornMode) {
        RootNode rootNode = node.getRootNode();
        SourceSection sourceSection = rootNode.getSourceSection();
        if (sourceSection == null) {
            return null;
        }
        String fileName = GraalJSException.getFileName(sourceSection.getSource());
        String functionName = rootNode.getName();
        Object thisObj = null;
        Object functionObj = null;
        return new JSStackTraceElement(fileName, functionName, sourceSection, thisObj, functionObj, null, strict, false, false, inNashornMode);
    }

    private static String getPrimitiveConstructorName(Object thisObj) {
        assert (JSRuntime.isJSPrimitive(thisObj));
        if (thisObj instanceof Boolean) {
            return "Boolean";
        }
        if (JSRuntime.isNumber(thisObj)) {
            return "Number";
        }
        if (JSRuntime.isString(thisObj)) {
            return "String";
        }
        if (thisObj instanceof Symbol) {
            return "Symbol";
        }
        return null;
    }

    private static int sourceSectionOffset(SourceSection callNodeSourceSection, SourceSection targetSourceSection) {
        int index;
        String targetCode;
        int index2;
        int offset = 0;
        String code = callNodeSourceSection.getCharacters().toString();
        if (targetSourceSection != null && (index2 = code.indexOf(targetCode = targetSourceSection.getCharacters().toString())) != -1) {
            offset += (index2 += targetCode.length());
            code = code.substring(index2);
        }
        if ((index = code.indexOf(40)) != -1) {
            int i;
            for (i = --index; i >= 0 && Character.isWhitespace(code.charAt(i)); --i) {
            }
            if (i >= 0 && Character.isJavaIdentifierPart(code.charAt(i))) {
                while (--i >= 0 && Character.isJavaIdentifierPart(code.charAt(i))) {
                }
                index = i;
            }
            offset += index + 1;
        }
        return offset;
    }

    private static String getFileName(Source source) {
        return source != null ? source.getName() : "<unknown>";
    }

    public void printJSStackTrace() {
        System.err.println(this.getMessage());
        for (JSStackTraceElement jsste : this.jsStackTrace) {
            System.err.println(jsste);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static void printJSStackTrace(Node originatingNode) {
        JSStackTraceElement[] jsstes;
        for (JSStackTraceElement jsste : jsstes = GraalJSException.getJSStackTrace(originatingNode)) {
            System.err.println(jsste);
        }
    }

    public static final class JSStackTraceElement {
        private final String fileName;
        private final String functionName;
        private final SourceSection sourceSection;
        private final Object thisObj;
        private final Object functionObj;
        private final SourceSection targetSourceSection;
        private final boolean strict;
        private final boolean eval;
        private final boolean global;
        private final boolean inNashornMode;

        private JSStackTraceElement(String fileName, String functionName, SourceSection sourceSection, Object thisObj, Object functionObj, SourceSection targetSourceSection, boolean strict, boolean eval, boolean global, boolean inNashornMode) {
            CompilerAsserts.neverPartOfCompilation();
            this.fileName = fileName;
            this.functionName = functionName;
            this.sourceSection = sourceSection;
            this.thisObj = thisObj;
            this.functionObj = functionObj;
            this.targetSourceSection = targetSourceSection;
            this.strict = strict;
            this.eval = eval;
            this.global = global;
            this.inNashornMode = inNashornMode;
        }

        @CompilerDirectives.TruffleBoundary
        public String getFileName() {
            if (this.fileName.startsWith("eval at ")) {
                return "<eval>";
            }
            return this.fileName;
        }

        public String getClassName() {
            return this.getTypeName(false);
        }

        public String getTypeName() {
            return this.getTypeName(true);
        }

        @CompilerDirectives.TruffleBoundary
        public String getTypeName(boolean checkGlobal) {
            if (this.inNashornMode) {
                return "<" + this.fileName + ">";
            }
            if (checkGlobal && this.global) {
                return "global";
            }
            Object thisObject = this.getThis();
            if (thisObject == JSFunction.CONSTRUCT) {
                return this.getFunctionName();
            }
            if (!JSRuntime.isNullOrUndefined(thisObject) && !this.global) {
                if (JSObject.isDynamicObject(thisObject)) {
                    return JSRuntime.getConstructorName((DynamicObject)thisObject);
                }
                if (JSRuntime.isJSPrimitive(thisObject)) {
                    return GraalJSException.getPrimitiveConstructorName(thisObject);
                }
            }
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        public String getFunctionName() {
            String dynamicName;
            if (!(!JSFunction.isJSFunction(this.functionObj) || (dynamicName = JSStackTraceElement.findFunctionName((DynamicObject)this.functionObj)) == null || dynamicName.isEmpty() || this.isEval() && dynamicName.equals(GraalJSException.DYNAMIC_FUNCTION_NAME) && JSObject.getJSContext((DynamicObject)this.functionObj).isOptionV8CompatibilityMode())) {
                return dynamicName;
            }
            return this.functionName;
        }

        private static String findFunctionName(DynamicObject functionObj) {
            Object name;
            assert (JSFunction.isJSFunction(functionObj));
            PropertyDescriptor desc = JSObject.getOwnProperty(functionObj, "name");
            if (desc != null && desc.isDataDescriptor() && JSRuntime.isString(name = desc.getValue())) {
                return JSRuntime.javaToString(name);
            }
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        public String getMethodName() {
            return this.getMethodName(JavaScriptLanguage.getCurrentJSRealm().getContext());
        }

        @CompilerDirectives.TruffleBoundary
        public String getMethodName(JSContext context) {
            String name;
            if (context.isOptionNashornCompatibilityMode()) {
                return JSError.correctMethodName(this.functionName, context);
            }
            if (JSRuntime.isNullOrUndefined(this.thisObj) || !JSObject.isJSObject(this.thisObj)) {
                return null;
            }
            if (!JSFunction.isJSFunction(this.functionObj)) {
                return null;
            }
            DynamicObject receiver = (DynamicObject)this.thisObj;
            DynamicObject function = (DynamicObject)this.functionObj;
            if (this.functionName != null && !this.functionName.isEmpty() && (name = JSStackTraceElement.findMethodPropertyNameByFunctionName(receiver, this.functionName, function)) != null) {
                return name;
            }
            return JSStackTraceElement.findMethodPropertyName(receiver, function);
        }

        private static String findMethodPropertyNameByFunctionName(DynamicObject receiver, String functionName, DynamicObject functionObj) {
            String propertyName = functionName;
            boolean accessor = false;
            if (propertyName.startsWith("get ") || propertyName.startsWith("set ")) {
                propertyName = propertyName.substring(4);
                accessor = true;
            }
            if (propertyName.isEmpty()) {
                return null;
            }
            DynamicObject current = receiver;
            while (current != Null.instance && !JSProxy.isProxy(current)) {
                PropertyDescriptor desc = JSObject.getOwnProperty(current, propertyName);
                if (desc != null) {
                    if (desc.isAccessorDescriptor() != accessor || desc.getValue() != functionObj && desc.getGet() != functionObj && desc.getSet() != functionObj) break;
                    return propertyName;
                }
                current = JSObject.getPrototype(current);
            }
            return null;
        }

        private static String findMethodPropertyName(DynamicObject receiver, DynamicObject functionObj) {
            String name = null;
            DynamicObject current = receiver;
            while (current != Null.instance && !JSProxy.isProxy(current)) {
                for (String key : JSObject.enumerableOwnNames(current)) {
                    PropertyDescriptor desc = JSObject.getOwnProperty(current, key);
                    if (desc.getValue() != functionObj && desc.getGet() != functionObj && desc.getSet() != functionObj) continue;
                    if (name == null) {
                        name = key;
                        continue;
                    }
                    return null;
                }
                current = JSObject.getPrototype(current);
            }
            return name;
        }

        @CompilerDirectives.TruffleBoundary
        public int getLineNumber() {
            if (this.sourceSection == null) {
                return -1;
            }
            int lineNumber = this.sourceSection.getStartLine();
            if (!this.inNashornMode && this.targetSourceSection != null) {
                int offset = GraalJSException.sourceSectionOffset(this.sourceSection, this.targetSourceSection);
                CharSequence chars = this.sourceSection.getCharacters();
                for (int pos = 0; pos < offset; ++pos) {
                    if (chars.charAt(pos) != '\n') continue;
                    ++lineNumber;
                }
            }
            return lineNumber;
        }

        @CompilerDirectives.TruffleBoundary
        public String getLine() {
            int lineNumber = this.getLineNumber();
            if (this.sourceSection == null || this.sourceSection.getSource() == null || lineNumber <= 0) {
                return "<unknown>";
            }
            return this.sourceSection.getSource().getCharacters(lineNumber).toString();
        }

        @CompilerDirectives.TruffleBoundary
        public int getColumnNumber() {
            if (this.sourceSection == null) {
                return -1;
            }
            int columnNumber = this.sourceSection.getStartColumn();
            if (!this.inNashornMode && this.targetSourceSection != null) {
                int offset = GraalJSException.sourceSectionOffset(this.sourceSection, this.targetSourceSection);
                CharSequence chars = this.sourceSection.getCharacters();
                for (int pos = 0; pos < offset; ++pos) {
                    if (chars.charAt(pos) == '\n') {
                        columnNumber = 1;
                        continue;
                    }
                    ++columnNumber;
                }
            }
            return columnNumber;
        }

        public int getPosition() {
            return this.sourceSection != null ? this.sourceSection.getCharIndex() : -1;
        }

        public Object getThis() {
            return this.thisObj;
        }

        @CompilerDirectives.TruffleBoundary
        public Object getThisOrGlobal() {
            if (this.thisObj == Undefined.instance && JSFunction.isJSFunction(this.functionObj) && !JSFunction.isStrict((DynamicObject)this.functionObj)) {
                return JSFunction.getRealm((DynamicObject)this.functionObj).getGlobalObject();
            }
            return this.thisObj == JSFunction.CONSTRUCT ? Undefined.instance : this.thisObj;
        }

        public Object getFunction() {
            return this.functionObj;
        }

        public boolean isStrict() {
            return this.strict;
        }

        @CompilerDirectives.TruffleBoundary
        public boolean isConstructor() {
            if (this.thisObj == JSFunction.CONSTRUCT) {
                return true;
            }
            if (!JSRuntime.isNullOrUndefined(this.thisObj) && JSObject.isJSObject(this.thisObj)) {
                Object constructor = JSRuntime.getDataProperty((DynamicObject)this.thisObj, "constructor");
                return constructor != null && constructor == this.functionObj;
            }
            return false;
        }

        public boolean isEval() {
            return this.eval;
        }

        @CompilerDirectives.TruffleBoundary
        public String getEvalOrigin() {
            if (this.fileName.startsWith("<")) {
                return null;
            }
            return this.fileName;
        }

        @CompilerDirectives.TruffleBoundary
        public String toString() {
            boolean includeMethodName;
            JSContext context = JavaScriptLanguage.getCurrentJSRealm().getContext();
            StringBuilder builder = new StringBuilder();
            String className = this.getClassName();
            String methodName = JSError.correctMethodName(this.getFunctionName(), context);
            if (methodName == null || methodName.isEmpty()) {
                String name = this.getMethodName(context);
                methodName = name == null ? JSError.getAnonymousFunctionNameStackTrace(context) : name;
            }
            boolean bl = includeMethodName = className != null || !JSError.getAnonymousFunctionNameStackTrace(context).equals(methodName);
            if (includeMethodName) {
                if (className != null) {
                    if (className.equals(methodName)) {
                        if (this.isConstructor()) {
                            builder.append("new ");
                        }
                    } else {
                        builder.append(className).append('.');
                    }
                }
                builder.append(methodName);
                builder.append(" (");
            }
            if (JSFunction.isBuiltinSourceSection(this.sourceSection)) {
                builder.append("native");
            } else {
                String evalOrigin = this.getEvalOrigin();
                String sourceName = evalOrigin != null ? evalOrigin : this.getFileName();
                builder.append(sourceName);
                if (this.eval) {
                    builder.append(", <anonymous>");
                }
                builder.append(":");
                builder.append(this.getLineNumber());
                builder.append(":");
                builder.append(this.getColumnNumber());
            }
            if (includeMethodName) {
                builder.append(")");
            }
            return builder.toString();
        }
    }

    private static final class FrameVisitorImpl {
        private static final int STACK_FRAME_SKIP = 0;
        private static final int STACK_FRAME_JS = 1;
        private static final int STACK_FRAME_FOREIGN = 2;
        private final List<JSStackTraceElement> stackTrace = new ArrayList<JSStackTraceElement>();
        private final Node originatingNode;
        private final int stackTraceLimit;
        private final DynamicObject skipFramesUpTo;
        private final boolean inNashornMode;
        private boolean inStrictMode;
        private boolean skippingFrames;
        private boolean first = true;

        FrameVisitorImpl(Node originatingNode, int stackTraceLimit, DynamicObject skipFramesUpTo, boolean nashornMode) {
            this.originatingNode = originatingNode;
            this.stackTraceLimit = stackTraceLimit;
            this.skipFramesUpTo = skipFramesUpTo;
            this.skippingFrames = skipFramesUpTo != Undefined.instance;
            this.inNashornMode = nashornMode;
        }

        private int stackFrameType(Node callNode) {
            if (callNode == null) {
                return 0;
            }
            SourceSection sourceSection = callNode.getEncapsulatingSourceSection();
            if (sourceSection == null) {
                return 0;
            }
            if (JSFunction.isBuiltinSourceSection(sourceSection)) {
                return this.inNashornMode ? 0 : 1;
            }
            if (sourceSection.getSource().isInternal() || !sourceSection.isAvailable()) {
                return 0;
            }
            if (JSRuntime.isJSRootNode(callNode.getRootNode())) {
                return 1;
            }
            return 2;
        }

        private static RootNode rootNode(TruffleStackTraceElement element) {
            RootCallTarget callTarget = element.getTarget();
            return callTarget instanceof RootCallTarget ? callTarget.getRootNode() : null;
        }

        public boolean visitFrame(TruffleStackTraceElement element) {
            Node callNode = element.getLocation();
            if (this.first) {
                this.first = false;
                if (JSRuntime.isJSRootNode(FrameVisitorImpl.rootNode(element))) {
                    callNode = this.originatingNode;
                }
            }
            if (callNode == null) {
                callNode = FrameVisitorImpl.rootNode(element);
            }
            if (callNode != null) {
                switch (this.stackFrameType(callNode)) {
                    case 1: {
                        Object[] arguments;
                        RootNode rootNode = callNode.getRootNode();
                        assert (JSRuntime.isJSRootNode(rootNode));
                        if (JSRuntime.isJSFunctionRootNode(rootNode)) {
                            arguments = element.getFrame().getArguments();
                        } else {
                            if (!((JavaScriptRootNode)rootNode).isResumption()) break;
                            Frame frame = (Frame)element.getFrame().getArguments()[0];
                            arguments = frame.getArguments();
                        }
                        Object thisObj = JSArguments.getThisObject(arguments);
                        Object functionObj = JSArguments.getFunctionObject(arguments);
                        if (!JSFunction.isJSFunction(functionObj)) break;
                        DynamicObject function = (DynamicObject)functionObj;
                        JSFunctionData functionData = JSFunction.getFunctionData(function);
                        if (functionData.isBuiltin()) {
                            if (JSFunction.isStrictBuiltin(function)) {
                                this.inStrictMode = true;
                            }
                        } else if (functionData.isStrict()) {
                            this.inStrictMode = true;
                        }
                        if (this.skippingFrames && function == this.skipFramesUpTo) {
                            this.skippingFrames = false;
                            return true;
                        }
                        JSRealm realm = JSFunction.getRealm(function);
                        if (JSFunction.isBuiltinThatShouldNotAppearInStackTrace(realm, function)) {
                            return true;
                        }
                        if (this.skippingFrames) break;
                        if (functionData.isAsync() && !functionData.isGenerator() && JSRuntime.isJSFunctionRootNode(rootNode)) {
                            return true;
                        }
                        this.stackTrace.add(GraalJSException.processJSFrame(rootNode, callNode, thisObj, function, this.inStrictMode, this.inNashornMode));
                        break;
                    }
                    case 2: {
                        JSStackTraceElement elem;
                        if (this.skippingFrames || (elem = GraalJSException.processForeignFrame(callNode, this.inStrictMode, this.inNashornMode)) == null) break;
                        this.stackTrace.add(elem);
                    }
                }
            }
            return this.stackTrace.size() < this.stackTraceLimit;
        }

        public List<JSStackTraceElement> getStackTrace() {
            return this.stackTrace;
        }
    }
}

