/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array;

import com.oracle.truffle.js.runtime.array.ByteArrayAccess;

abstract class NormalByteArrayAccess
extends ByteArrayAccess {
    NormalByteArrayAccess() {
    }

    private static int makeInt16(byte b0, byte b1) {
        return b1 << 8 | b0 & 0xFF;
    }

    private static int makeInt32(byte b0, byte b1, byte b2, byte b3) {
        return b3 << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | b0 & 0xFF;
    }

    private static long makeInt64(byte b0, byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7) {
        return (long)b7 << 56 | ((long)b6 & 0xFFL) << 48 | ((long)b5 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b3 & 0xFFL) << 24 | ((long)b2 & 0xFFL) << 16 | ((long)b1 & 0xFFL) << 8 | (long)b0 & 0xFFL;
    }

    @Override
    public final int getInt8(byte[] buffer, int offset, int index, int bytesPerElement) {
        int byteIndex = offset + index * bytesPerElement;
        return buffer[byteIndex];
    }

    @Override
    public final int getInt16(byte[] buffer, int offset, int index, int bytesPerElement) {
        int byteIndex = offset + index * bytesPerElement;
        return NormalByteArrayAccess.makeInt16(buffer[byteIndex + this.b(0, 2)], buffer[byteIndex + this.b(1, 2)]);
    }

    @Override
    public final int getInt32(byte[] buffer, int offset, int index, int bytesPerElement) {
        int byteIndex = offset + index * bytesPerElement;
        return NormalByteArrayAccess.makeInt32(buffer[byteIndex + this.b(0, 4)], buffer[byteIndex + this.b(1, 4)], buffer[byteIndex + this.b(2, 4)], buffer[byteIndex + this.b(3, 4)]);
    }

    @Override
    public final float getFloat(byte[] buffer, int offset, int index, int bytesPerElement) {
        return Float.intBitsToFloat(this.getInt32(buffer, offset, index, bytesPerElement));
    }

    @Override
    public final double getDouble(byte[] buffer, int offset, int index, int bytesPerElement) {
        int byteIndex = offset + index * bytesPerElement;
        return Double.longBitsToDouble(NormalByteArrayAccess.makeInt64(buffer[byteIndex + this.b(0, 8)], buffer[byteIndex + this.b(1, 8)], buffer[byteIndex + this.b(2, 8)], buffer[byteIndex + this.b(3, 8)], buffer[byteIndex + this.b(4, 8)], buffer[byteIndex + this.b(5, 8)], buffer[byteIndex + this.b(6, 8)], buffer[byteIndex + this.b(7, 8)]));
    }

    @Override
    public long getInt64(byte[] buffer, int offset, int index, int bytesPerElement) {
        int byteIndex = offset + index * bytesPerElement;
        return NormalByteArrayAccess.makeInt64(buffer[byteIndex + this.b(0, 8)], buffer[byteIndex + this.b(1, 8)], buffer[byteIndex + this.b(2, 8)], buffer[byteIndex + this.b(3, 8)], buffer[byteIndex + this.b(4, 8)], buffer[byteIndex + this.b(5, 8)], buffer[byteIndex + this.b(6, 8)], buffer[byteIndex + this.b(7, 8)]);
    }

    @Override
    public final void putInt8(byte[] buffer, int offset, int index, int bytesPerElement, int value) {
        int byteIndex = offset + index * bytesPerElement;
        buffer[byteIndex] = (byte)value;
    }

    @Override
    public final void putInt16(byte[] buffer, int offset, int index, int bytesPerElement, int value) {
        int byteIndex = offset + index * bytesPerElement;
        buffer[byteIndex + this.b((int)0, (int)2)] = (byte)value;
        buffer[byteIndex + this.b((int)1, (int)2)] = (byte)(value >> 8);
    }

    @Override
    public final void putInt32(byte[] buffer, int offset, int index, int bytesPerElement, int value) {
        int byteIndex = offset + index * bytesPerElement;
        buffer[byteIndex + this.b((int)0, (int)4)] = (byte)value;
        buffer[byteIndex + this.b((int)1, (int)4)] = (byte)(value >> 8);
        buffer[byteIndex + this.b((int)2, (int)4)] = (byte)(value >> 16);
        buffer[byteIndex + this.b((int)3, (int)4)] = (byte)(value >> 24);
    }

    @Override
    public final void putInt64(byte[] buffer, int offset, int index, int bytesPerElement, long value) {
        int byteIndex = offset + index * bytesPerElement;
        buffer[byteIndex + this.b((int)0, (int)8)] = (byte)value;
        buffer[byteIndex + this.b((int)1, (int)8)] = (byte)(value >> 8);
        buffer[byteIndex + this.b((int)2, (int)8)] = (byte)(value >> 16);
        buffer[byteIndex + this.b((int)3, (int)8)] = (byte)(value >> 24);
        buffer[byteIndex + this.b((int)4, (int)8)] = (byte)(value >> 32);
        buffer[byteIndex + this.b((int)5, (int)8)] = (byte)(value >> 40);
        buffer[byteIndex + this.b((int)6, (int)8)] = (byte)(value >> 48);
        buffer[byteIndex + this.b((int)7, (int)8)] = (byte)(value >> 56);
    }

    @Override
    public final void putFloat(byte[] buffer, int offset, int index, int bytesPerElement, float value) {
        this.putInt32(buffer, offset, index, bytesPerElement, Float.floatToIntBits(value));
    }

    @Override
    public final void putDouble(byte[] buffer, int offset, int index, int bytesPerElement, double value) {
        this.putInt64(buffer, offset, index, bytesPerElement, Double.doubleToRawLongBits(value));
    }

    protected abstract int b(int var1, int var2);
}

