/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.nashorn.regexp.joni;

import com.oracle.truffle.regex.nashorn.regexp.joni.EncodingHelper;
import com.oracle.truffle.regex.nashorn.regexp.joni.Option;
import com.oracle.truffle.regex.nashorn.regexp.joni.Regex;
import com.oracle.truffle.regex.nashorn.regexp.joni.Region;
import com.oracle.truffle.regex.nashorn.regexp.joni.SearchAlgorithm;
import com.oracle.truffle.regex.nashorn.regexp.joni.encoding.IntHolder;

public abstract class Matcher
extends IntHolder {
    protected final Regex regex;
    private final String chars;
    protected final int str;
    protected final int end;
    protected int msaStart;
    protected int msaOptions;
    protected final Region msaRegion;
    protected int msaBestLen;
    protected int msaBestS;
    protected int msaBegin;
    protected int msaEnd;
    int low;
    int high;

    public Matcher(Regex regex, String chars, int p, int end) {
        this.regex = regex;
        this.chars = chars;
        this.str = p;
        this.end = end;
        this.msaRegion = regex.numMem == 0 ? null : new Region(regex.numMem + 1);
    }

    protected abstract int matchAt(int var1, int var2);

    public final Region getRegion() {
        return this.msaRegion;
    }

    public final Region getEagerRegion() {
        return this.msaRegion != null ? this.msaRegion : new Region(this.regex.numMem + 1);
    }

    public final int getBegin() {
        return this.msaBegin;
    }

    public final int getEnd() {
        return this.msaEnd;
    }

    public final char charAt(int pos) {
        return this.chars.charAt(pos);
    }

    protected final void msaInit(int option, int start) {
        this.msaOptions = option;
        this.msaStart = start;
        this.msaBestLen = -1;
    }

    public final int match(int at, int range, int option) {
        this.msaInit(option, at);
        return this.matchAt(range, at);
    }

    private final boolean isNewLineAt(int p, int e) {
        return p >= this.str && p < e && EncodingHelper.isNewLine(this.charAt(p));
    }

    protected final boolean isNewLineAt(int p) {
        return this.isNewLineAt(p, this.end);
    }

    protected final boolean isWordAt(int p) {
        return p >= this.str && p < this.end && EncodingHelper.isWord(this.charAt(p));
    }

    private boolean forwardSearchRange(int string, int e, int s, int range, IntHolder lowPrev) {
        int pprev = -1;
        int p = s;
        if (this.regex.dMin > 0) {
            p += this.regex.dMin;
        }
        block4: while ((p = this.regex.searchAlgorithm.search(this.regex, this.chars, p, e, range)) != -1 && p < range) {
            if (p - this.regex.dMin < s) {
                pprev = p++;
                continue;
            }
            if (this.regex.subAnchor != 0) {
                switch (this.regex.subAnchor) {
                    case 2: {
                        int prev;
                        if (p == string || this.isNewLineAt(prev = EncodingHelper.prevCharHead(pprev != -1 ? pprev : string, p), e)) break;
                        pprev = p++;
                        continue block4;
                    }
                    case 32: {
                        if (p == e || this.isNewLineAt(p, e)) break;
                        pprev = p++;
                        continue block4;
                    }
                }
            }
            if (this.regex.dMax == 0) {
                this.low = p;
                if (lowPrev != null) {
                    lowPrev.value = this.low > s ? EncodingHelper.prevCharHead(s, p) : EncodingHelper.prevCharHead(pprev != -1 ? pprev : string, p);
                }
            } else if (this.regex.dMax != Integer.MAX_VALUE) {
                this.low = p - this.regex.dMax;
                if (this.low > s) {
                    this.low = EncodingHelper.rightAdjustCharHeadWithPrev(this.low, lowPrev);
                    if (lowPrev != null && lowPrev.value == -1) {
                        lowPrev.value = EncodingHelper.prevCharHead(pprev != -1 ? pprev : s, this.low);
                    }
                } else if (lowPrev != null) {
                    lowPrev.value = EncodingHelper.prevCharHead(pprev != -1 ? pprev : string, this.low);
                }
            }
            this.high = p - this.regex.dMin;
            return true;
        }
        return false;
    }

    private boolean backwardSearchRange(int string, int e, int s, int range, int adjrange) {
        int r = range;
        r += this.regex.dMin;
        int p = s;
        block4: while ((p = this.regex.searchAlgorithm.searchBackward(this.regex, this.chars, r, adjrange, e, p, s, r)) != -1) {
            if (this.regex.subAnchor != 0) {
                switch (this.regex.subAnchor) {
                    case 2: {
                        int prev;
                        if (p == string || this.isNewLineAt(prev = EncodingHelper.prevCharHead(string, p), e)) break;
                        p = prev;
                        continue block4;
                    }
                    case 32: {
                        if (p == e || this.isNewLineAt(p, e)) break;
                        if ((p = EncodingHelper.prevCharHead(adjrange, p)) != -1) continue block4;
                        return false;
                    }
                }
            }
            if (this.regex.dMax != Integer.MAX_VALUE) {
                this.low = p - this.regex.dMax;
                this.high = p - this.regex.dMin;
            }
            return true;
        }
        return false;
    }

    private boolean matchCheck(int upperRange, int s) {
        return this.matchAt(this.end, s) != -1 && !Option.isFindLongest(this.regex.options);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int search(int startp, int rangep, int option) {
        int start = startp;
        int range = rangep;
        int origStart = start;
        int origRange = range;
        if (start > this.end || start < this.str) {
            return -1;
        }
        if (this.regex.anchor != 0 && this.str < this.end) {
            int minSemiEnd;
            int maxSemiEnd;
            if ((this.regex.anchor & 4) != 0) {
                range = range > start ? start + 1 : start;
            } else if ((this.regex.anchor & 1) != 0) {
                if (range > start) {
                    if (start != this.str) {
                        return -1;
                    }
                    range = this.str + 1;
                } else {
                    if (range > this.str) return -1;
                    start = this.str;
                    range = this.str;
                }
            } else if ((this.regex.anchor & 8) != 0) {
                maxSemiEnd = this.end;
                minSemiEnd = maxSemiEnd;
                if (this.endBuf(start, range, minSemiEnd, maxSemiEnd)) {
                    return -1;
                }
            } else if ((this.regex.anchor & 0x10) != 0) {
                int preEnd = EncodingHelper.stepBack(this.str, this.end, 1);
                maxSemiEnd = this.end;
                if (this.isNewLineAt(preEnd, this.end) ? (minSemiEnd = preEnd) > this.str && start <= minSemiEnd && this.endBuf(start, range, minSemiEnd, maxSemiEnd) : this.endBuf(start, range, minSemiEnd = this.end, maxSemiEnd)) {
                    return -1;
                }
            } else if ((this.regex.anchor & 0x8000) != 0) {
                range = range > start ? start + 1 : start;
            }
        } else if (this.str == this.end) {
            if (this.regex.thresholdLength != 0) return -1;
            int s = start = this.str;
            this.msaInit(option, start);
            if (!this.matchCheck(this.end, s)) return this.mismatch();
            return this.match(s);
        }
        this.msaInit(option, origStart);
        int s = start;
        if (range > start) {
            if (this.regex.searchAlgorithm != SearchAlgorithm.NONE) {
                int schRange = range;
                if (this.regex.dMax != 0) {
                    if (this.regex.dMax == Integer.MAX_VALUE) {
                        schRange = this.end;
                    } else if ((schRange += this.regex.dMax) > this.end) {
                        schRange = this.end;
                    }
                }
                if (this.end - start < this.regex.thresholdLength) {
                    return this.mismatch();
                }
                if (this.regex.dMax != Integer.MAX_VALUE) {
                    do {
                        if (!this.forwardSearchRange(this.str, this.end, s, schRange, this)) {
                            return this.mismatch();
                        }
                        if (s < this.low) {
                            s = this.low;
                        }
                        while (s <= this.high) {
                            if (this.matchCheck(origRange, s)) {
                                return this.match(s);
                            }
                            ++s;
                        }
                    } while (s < range);
                }
                if (!this.forwardSearchRange(this.str, this.end, s, schRange, null)) {
                    return this.mismatch();
                }
                if ((this.regex.anchor & 0x4000) != 0) {
                    do {
                        if (!this.matchCheck(origRange, s)) continue;
                        return this.match(s);
                    } while (++s < range);
                    return this.mismatch();
                }
            }
            do {
                if (!this.matchCheck(origRange, s)) continue;
                return this.match(s);
            } while (++s < range);
            if (s != range || !this.matchCheck(origRange, s)) return this.mismatch();
            return this.match(s);
        }
        if (this.regex.searchAlgorithm != SearchAlgorithm.NONE) {
            int schStart;
            int adjrange = range < this.end ? range : this.end;
            if (this.regex.dMax != Integer.MAX_VALUE && this.end - range >= this.regex.thresholdLength) {
                do {
                    if ((schStart = s + this.regex.dMax) > this.end) {
                        schStart = this.end;
                    }
                    if (!this.backwardSearchRange(this.str, this.end, schStart, range, adjrange)) {
                        return this.mismatch();
                    }
                    if (s > this.high) {
                        s = this.high;
                    }
                    while (s != -1 && s >= this.low) {
                        if (this.matchCheck(origStart, s)) {
                            return this.match(s);
                        }
                        --s;
                    }
                } while (s >= range);
                return this.mismatch();
            }
            if (this.end - range < this.regex.thresholdLength) {
                return this.mismatch();
            }
            schStart = s;
            if (this.regex.dMax != 0) {
                if (this.regex.dMax == Integer.MAX_VALUE) {
                    schStart = this.end;
                } else if ((schStart += this.regex.dMax) > this.end) {
                    schStart = this.end;
                }
            }
            if (!this.backwardSearchRange(this.str, this.end, schStart, range, adjrange)) {
                return this.mismatch();
            }
        }
        do {
            if (!this.matchCheck(origStart, s)) continue;
            return this.match(s);
        } while (--s >= range);
        return this.mismatch();
    }

    private boolean endBuf(int startp, int rangep, int minSemiEnd, int maxSemiEnd) {
        int start = startp;
        int range = rangep;
        if (maxSemiEnd - this.str < this.regex.anchorDmin) {
            return true;
        }
        if (range > start) {
            if (minSemiEnd - start > this.regex.anchorDmax && (start = minSemiEnd - this.regex.anchorDmax) >= this.end) {
                start = EncodingHelper.prevCharHead(this.str, this.end);
            }
            if (maxSemiEnd - (range - 1) < this.regex.anchorDmin) {
                range = maxSemiEnd - this.regex.anchorDmin + 1;
            }
            if (start >= range) {
                return true;
            }
        } else {
            if (minSemiEnd - range > this.regex.anchorDmax) {
                range = minSemiEnd - this.regex.anchorDmax;
            }
            if (maxSemiEnd - start < this.regex.anchorDmin) {
                start = maxSemiEnd - this.regex.anchorDmin;
            }
            if (range > start) {
                return true;
            }
        }
        return false;
    }

    private int match(int s) {
        return s - this.str;
    }

    private int mismatch() {
        if (this.msaBestLen >= 0) {
            int s = this.msaBestS;
            return this.match(s);
        }
        return -1;
    }
}

