/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.proton.transport.ws.impl;

import com.microsoft.azure.proton.transport.ws.impl.Base64;
import com.microsoft.azure.proton.transport.ws.impl.Utils;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;

public class WebSocketUpgrade {
    private static final String RFC_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private static final char QUESTION_MARK = '?';
    private static final char SLASH = '/';
    private final String query;
    private final String host;
    private final String path;
    private final String port;
    private final String protocol;
    private final Map<String, String> additionalHeaders;
    private volatile String webSocketKey = "";

    public WebSocketUpgrade(String hostName, String webSocketPath, String webSocketQuery, int webSocketPort, String webSocketProtocol, Map<String, String> additionalHeaders) {
        this.host = hostName;
        this.path = webSocketPath.isEmpty() || webSocketPath.charAt(0) == '/' ? webSocketPath : '/' + webSocketPath;
        this.query = webSocketQuery.isEmpty() || webSocketQuery.charAt(0) == '?' ? webSocketQuery : '?' + webSocketQuery;
        this.port = webSocketPort == 0 ? "" : String.valueOf(webSocketPort);
        this.protocol = webSocketProtocol;
        this.additionalHeaders = additionalHeaders;
    }

    private String createWebSocketKey() {
        byte[] key = new byte[16];
        for (int i = 0; i < 16; ++i) {
            key[i] = (byte)(Utils.getSecureRandom().nextDouble() * 256.0);
        }
        return Base64.encodeBase64StringLocal(key).trim();
    }

    public String createUpgradeRequest() {
        if (this.host.isEmpty()) {
            throw new InvalidParameterException("host header has no value");
        }
        if (this.protocol.isEmpty()) {
            throw new InvalidParameterException("protocol header has no value");
        }
        this.webSocketKey = this.createWebSocketKey();
        String endOfLine = "\r\n";
        StringBuilder stringBuilder = new StringBuilder().append("GET https://").append(this.host).append(this.path).append(this.query).append(" HTTP/1.1").append("\r\n").append("Connection: Upgrade,Keep-Alive").append("\r\n").append("Upgrade: websocket").append("\r\n").append("Sec-WebSocket-Version: 13").append("\r\n").append("Sec-WebSocket-Key: ").append(this.webSocketKey).append("\r\n").append("Sec-WebSocket-Protocol: ").append(this.protocol).append("\r\n").append("Host: ").append(this.host).append("\r\n");
        if (this.additionalHeaders != null) {
            for (Map.Entry<String, String> entry : this.additionalHeaders.entrySet()) {
                stringBuilder.append(entry.getKey()).append(": ").append(entry.getValue()).append("\r\n");
            }
        }
        stringBuilder.append("\r\n");
        return stringBuilder.toString();
    }

    public Boolean validateUpgradeReply(byte[] responseBytes) {
        String httpString = new String(responseBytes, StandardCharsets.UTF_8);
        boolean isStatusLineOk = false;
        boolean isUpgradeHeaderOk = false;
        boolean isConnectionHeaderOk = false;
        boolean isProtocolHeaderOk = false;
        boolean isAcceptHeaderOk = false;
        Scanner scanner = new Scanner(httpString);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            String lowercase = line.toLowerCase(Locale.ROOT);
            if (lowercase.contains("http/1.1") && line.contains("101") && lowercase.contains("switching protocols")) {
                isStatusLineOk = true;
                continue;
            }
            if (lowercase.contains("upgrade") && lowercase.contains("websocket")) {
                isUpgradeHeaderOk = true;
                continue;
            }
            if (lowercase.contains("connection") && lowercase.contains("upgrade")) {
                isConnectionHeaderOk = true;
                continue;
            }
            if (lowercase.contains("sec-websocket-protocol") && lowercase.contains(this.protocol.toLowerCase(Locale.ROOT))) {
                isProtocolHeaderOk = true;
                continue;
            }
            if (!lowercase.contains("sec-websocket-accept")) continue;
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                break;
            }
            byte[] bytes = (this.webSocketKey + RFC_GUID).getBytes(StandardCharsets.ISO_8859_1);
            String expectedKey = Base64.encodeBase64StringLocal(messageDigest.digest(bytes)).trim();
            if (!line.contains(expectedKey)) continue;
            isAcceptHeaderOk = true;
        }
        scanner.close();
        return isStatusLineOk && isUpgradeHeaderOk && isConnectionHeaderOk && isProtocolHeaderOk && isAcceptHeaderOk;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WebSocketUpgrade [host=").append(this.host).append(", path=").append(this.path).append(", port=").append(this.port).append(", protocol=").append(this.protocol).append(", webSocketKey=").append(this.webSocketKey);
        if (this.additionalHeaders != null && !this.additionalHeaders.isEmpty()) {
            builder.append(", additionalHeaders=");
            for (Map.Entry<String, String> entry : this.additionalHeaders.entrySet()) {
                builder.append(entry.getKey()).append(":").append(entry.getValue()).append(", ");
            }
            int lastIndex = builder.lastIndexOf(", ");
            builder.delete(lastIndex, lastIndex + 2);
        }
        builder.append("]");
        return builder.toString();
    }
}

