/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;

public final class CollectionHelpers {
    public static <T> int binarySearch(List<? extends T> list, Function<? super T, Integer> comparator) {
        return CollectionHelpers.binarySearch(list, comparator, false);
    }

    private static <T> int binarySearch(List<? extends T> list, Function<? super T, Integer> comparator, boolean findGreatestLowerBound) {
        int start = 0;
        int end = list.size() - 1;
        while (start <= end) {
            int midIndex = start + end >>> 1;
            T midElement = list.get(midIndex);
            int compareResult = comparator.apply(midElement);
            if (compareResult < 0) {
                end = midIndex - 1;
                continue;
            }
            if (compareResult > 0) {
                if (findGreatestLowerBound) {
                    Object next;
                    Object t = next = list.size() > midIndex + 1 ? (Object)list.get(midIndex + 1) : null;
                    if (next == null || comparator.apply(next) < 0) {
                        return midIndex;
                    }
                }
                start = midIndex + 1;
                continue;
            }
            return midIndex;
        }
        return -1;
    }

    public static <T> int findGreatestLowerBound(List<? extends T> list, Function<? super T, Integer> comparator) {
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0, (Object)"supplied list is empty");
        return CollectionHelpers.binarySearch(list, comparator, true);
    }

    public static <T> Collection<T> filterOut(Collection<T> collection, Collection<T> toExclude) {
        return collection.stream().filter(o -> !toExclude.contains(o)).collect(Collectors.toList());
    }

    public static <T> Set<T> joinSets(Set<T> set1, Set<T> set2) {
        return new NonConvertedSetView<T>(set1, set2);
    }

    public static <OutputType, Type1, Type2> Set<OutputType> joinSets(Set<Type1> set1, Function<Type1, OutputType> converter1, Set<Type2> set2, Function<Type2, OutputType> converter2) {
        return new ConvertedSetView<OutputType, Type1, Type2>(set1, converter1, set2, converter2);
    }

    public static <OutputType, Type1, Type2> Collection<OutputType> joinCollections(Collection<Type1> c1, Function<Type1, OutputType> converter1, Collection<Type2> c2, Function<Type2, OutputType> converter2) {
        return new ConvertedSetView<OutputType, Type1, Type2>(c1, converter1, c2, converter2);
    }

    private static class ConvertedIterator<InputType, OutputType>
    implements Iterator<OutputType> {
        private final Iterator<InputType> iterator;
        private final Function<InputType, OutputType> converter;

        @Override
        public final boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public final OutputType next() {
            return this.converter.apply(this.iterator.next());
        }

        @Override
        public final void remove() {
            this.iterator.remove();
        }

        @ConstructorProperties(value={"iterator", "converter"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ConvertedIterator(Iterator<InputType> iterator, Function<InputType, OutputType> converter) {
            this.iterator = iterator;
            this.converter = converter;
        }
    }

    private static class NonConvertedSetView<T>
    extends SetView<T, T, T> {
        NonConvertedSetView(Collection<T> set1, Collection<T> set2) {
            super(set1, set2);
        }

        @Override
        public boolean contains(Object o) {
            return this.set1.contains(o) || this.set2.contains(o);
        }

        @Override
        public Iterator<T> iterator() {
            return Iterators.unmodifiableIterator((Iterator)Iterators.concat(this.set1.iterator(), this.set2.iterator()));
        }
    }

    private static class ConvertedSetView<OutputType, Type1, Type2>
    extends SetView<OutputType, Type1, Type2> {
        private final Function<Type1, OutputType> converter1;
        private final Function<Type2, OutputType> converter2;

        ConvertedSetView(Collection<Type1> set1, Function<Type1, OutputType> converter1, Collection<Type2> set2, Function<Type2, OutputType> converter2) {
            super(set1, set2);
            this.converter1 = (Function)Preconditions.checkNotNull(converter1, (Object)"converter1");
            this.converter2 = (Function)Preconditions.checkNotNull(converter2, (Object)"converter2");
        }

        @Override
        public boolean contains(Object o) {
            return Iterators.contains(this.iterator(), (Object)o);
        }

        @Override
        public Iterator<OutputType> iterator() {
            return Iterators.unmodifiableIterator((Iterator)Iterators.concat(new ConvertedIterator(this.set1.iterator(), this.converter1), new ConvertedIterator(this.set2.iterator(), this.converter2)));
        }
    }

    private static abstract class SetView<OutputType, Type1, Type2>
    extends AbstractSet<OutputType> {
        protected final Collection<Type1> set1;
        protected final Collection<Type2> set2;

        SetView(Collection<Type1> set1, Collection<Type2> set2) {
            this.set1 = (Collection)Preconditions.checkNotNull(set1, (Object)"set1");
            this.set2 = (Collection)Preconditions.checkNotNull(set2, (Object)"set2");
        }

        @Override
        public int size() {
            return this.set1.size() + this.set2.size();
        }

        @Override
        public boolean isEmpty() {
            return this.set1.isEmpty() && this.set2.isEmpty();
        }

        @Override
        public boolean add(OutputType t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends OutputType> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

