/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.AccountLimits;
import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonUtils;

public class AccountTier {
    private final int memory;
    private final int storage;
    private final int streams;
    private final int consumers;
    private final AccountLimits limits;

    AccountTier(String json) {
        this.memory = JsonUtils.readInt(json, ApiConstants.MEMORY_RE, 0);
        this.storage = JsonUtils.readInt(json, ApiConstants.STORAGE_RE, 0);
        this.streams = JsonUtils.readInt(json, ApiConstants.STREAMS_RE, 0);
        this.consumers = JsonUtils.readInt(json, ApiConstants.CONSUMERS_RE, 0);
        this.limits = new AccountLimits(JsonUtils.getJsonObject("limits", json));
    }

    public int getMemory() {
        return this.memory;
    }

    public int getStorage() {
        return this.storage;
    }

    public int getStreams() {
        return this.streams;
    }

    public int getConsumers() {
        return this.consumers;
    }

    public AccountLimits getLimits() {
        return this.limits;
    }
}

