/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server;

import io.debezium.engine.DebeziumEngine;
import io.debezium.server.events.ConnectorCompletedEvent;
import io.debezium.server.events.ConnectorStartedEvent;
import io.debezium.server.events.ConnectorStoppedEvent;
import io.debezium.server.events.TaskStartedEvent;
import io.debezium.server.events.TaskStoppedEvent;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.Liveness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Liveness
@ApplicationScoped
public class ConnectorLifecycle
implements HealthCheck,
DebeziumEngine.ConnectorCallback,
DebeziumEngine.CompletionCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectorLifecycle.class);
    private volatile boolean live = false;
    @Inject
    Event<ConnectorStartedEvent> connectorStartedEvent;
    @Inject
    Event<ConnectorStoppedEvent> connectorStoppedEvent;
    @Inject
    Event<TaskStartedEvent> taskStartedEvent;
    @Inject
    Event<TaskStoppedEvent> taskStoppedEvent;
    @Inject
    Event<ConnectorCompletedEvent> connectorCompletedEvent;

    public void connectorStarted() {
        LOGGER.debug("Connector started");
        this.connectorStartedEvent.fire((Object)new ConnectorStartedEvent());
    }

    public void connectorStopped() {
        LOGGER.debug("Connector stopped");
        this.connectorStoppedEvent.fire((Object)new ConnectorStoppedEvent());
    }

    public void taskStarted() {
        LOGGER.debug("Task started");
        this.taskStartedEvent.fire((Object)new TaskStartedEvent());
        this.live = true;
    }

    public void taskStopped() {
        LOGGER.debug("Task stopped");
        this.taskStoppedEvent.fire((Object)new TaskStoppedEvent());
    }

    public void handle(boolean success, String message, Throwable error) {
        String logMessage = String.format("Connector completed: success = '%s', message = '%s', error = '%s'", success, message, error);
        if (success) {
            LOGGER.info(logMessage);
        } else {
            LOGGER.error(logMessage);
        }
        this.connectorCompletedEvent.fire((Object)new ConnectorCompletedEvent(success, message, error));
        this.live = false;
    }

    public HealthCheckResponse call() {
        LOGGER.trace("Healthcheck called - live = '{}'", (Object)this.live);
        return HealthCheckResponse.named((String)"debezium").status(this.live).build();
    }
}

