/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.redis;

import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.engine.ChangeEvent;
import io.debezium.engine.DebeziumEngine;
import io.debezium.server.BaseChangeConsumer;
import io.debezium.server.redis.RedisStreamChangeConsumerConfig;
import io.debezium.storage.redis.RedisClient;
import io.debezium.storage.redis.RedisClientConnectionException;
import io.debezium.storage.redis.RedisConnection;
import io.debezium.util.DelayStrategy;
import io.debezium.util.IoUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.inject.Named;
import org.eclipse.microprofile.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="redis")
@Dependent
public class RedisStreamChangeConsumer
extends BaseChangeConsumer
implements DebeziumEngine.ChangeConsumer<ChangeEvent<Object, Object>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisStreamChangeConsumer.class);
    private static final String DEBEZIUM_REDIS_SINK_CLIENT_NAME = "debezium:redis:sink";
    private static final String EXTENDED_MESSAGE_KEY_KEY = "key";
    private static final String EXTENDED_MESSAGE_VALUE_KEY = "value";
    private static final String INFO_MEMORY = "memory";
    private static final String INFO_MEMORY_SECTION_MAXMEMORY = "maxmemory";
    private static final String INFO_MEMORY_SECTION_USEDMEMORY = "used_memory";
    private RedisClient client;
    private BiFunction<String, String, Map<String, String>> recordMapFunction;
    private Supplier<Boolean> isMemoryOk;
    private RedisStreamChangeConsumerConfig config;

    @PostConstruct
    void connect() {
        Configuration configuration = Configuration.from((Map)this.getConfigSubset(ConfigProvider.getConfig(), ""));
        this.config = new RedisStreamChangeConsumerConfig(configuration);
        String messageFormat = this.config.getMessageFormat();
        if ("extended".equals(messageFormat)) {
            this.recordMapFunction = (key, value) -> {
                LinkedHashMap<String, String> recordMap = new LinkedHashMap<String, String>(2);
                recordMap.put(EXTENDED_MESSAGE_KEY_KEY, (String)key);
                recordMap.put(EXTENDED_MESSAGE_VALUE_KEY, (String)value);
                return recordMap;
            };
        } else if ("compact".equals(messageFormat)) {
            this.recordMapFunction = Collections::singletonMap;
        }
        int memoryThreshold = this.config.getMemoryThreshold();
        this.isMemoryOk = memoryThreshold > 0 ? () -> this.isMemoryOk(memoryThreshold) : () -> true;
        RedisConnection redisConnection = new RedisConnection(this.config.getAddress(), this.config.getUser(), this.config.getPassword(), this.config.getConnectionTimeout().intValue(), this.config.getSocketTimeout().intValue(), this.config.isSslEnabled());
        this.client = redisConnection.getRedisClient(DEBEZIUM_REDIS_SINK_CLIENT_NAME, this.config.isWaitEnabled(), this.config.getWaitTimeout(), this.config.isWaitRetryEnabled(), this.config.getWaitRetryDelay());
    }

    @PreDestroy
    void close() {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Exception while closing Jedis: {}", (Object)this.client, (Object)e);
        }
        finally {
            this.client = null;
        }
    }

    private <T> Stream<List<T>> batches(List<T> source, int length) {
        if (source.isEmpty()) {
            return Stream.empty();
        }
        int size = source.size();
        int fullChunks = (size - 1) / length;
        return IntStream.range(0, fullChunks + 1).mapToObj(n -> source.subList(n * length, n == fullChunks ? size : (n + 1) * length));
    }

    public void handleBatch(List<ChangeEvent<Object, Object>> records, DebeziumEngine.RecordCommitter<ChangeEvent<Object, Object>> committer) throws InterruptedException {
        DelayStrategy delayStrategy = DelayStrategy.exponential((Duration)Duration.ofMillis(this.config.getInitialRetryDelay().intValue()), (Duration)Duration.ofMillis(this.config.getMaxRetryDelay().intValue()));
        LOGGER.trace("Handling a batch of {} records", (Object)records.size());
        this.batches(records, this.config.getBatchSize()).forEach(arg_0 -> this.lambda$handleBatch$4(committer, delayStrategy, arg_0));
        committer.markBatchFinished();
    }

    private boolean canHandleBatch() {
        return this.isMemoryOk.get();
    }

    private boolean isMemoryOk(int memoryThreshold) {
        long usedMemory;
        long percentage;
        String memory = this.client.info(INFO_MEMORY);
        HashMap infoMemory = new HashMap();
        try {
            IoUtil.readLines((InputStream)new ByteArrayInputStream(memory.getBytes(StandardCharsets.UTF_8)), line -> {
                String[] pair = line.split(":");
                if (pair.length == 2) {
                    infoMemory.put(pair[0], pair[1]);
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Cannot parse Redis info memory {}", (Object)memory, (Object)e);
            return true;
        }
        long maxMemory = Long.parseLong((String)infoMemory.get(INFO_MEMORY_SECTION_MAXMEMORY));
        if (maxMemory > 0L && (percentage = 100L * (usedMemory = Long.parseLong((String)infoMemory.get(INFO_MEMORY_SECTION_USEDMEMORY))) / maxMemory) >= (long)memoryThreshold) {
            LOGGER.warn("Used memory percentage of {}% is higher than configured threshold of {}%", (Object)percentage, (Object)memoryThreshold);
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$handleBatch$4(DebeziumEngine.RecordCommitter committer, DelayStrategy delayStrategy, List batch) {
        completedSuccessfully = false;
        clonedBatch = batch.stream().collect(Collectors.toList());
        while (!completedSuccessfully) {
            if (this.client == null) {
                try {
                    this.connect();
                    continue;
                }
                catch (Exception e) {
                    this.close();
                    RedisStreamChangeConsumer.LOGGER.error("Can't connect to Redis", (Throwable)e);
                }
            } else if (this.canHandleBatch()) {
                try {
                    RedisStreamChangeConsumer.LOGGER.trace("Preparing a Redis Pipeline of {} records", (Object)clonedBatch.size());
                    recordsMap = new ArrayList<AbstractMap.SimpleEntry<String, Map<String, String>>>(clonedBatch.size());
                    for (ChangeEvent record : clonedBatch) {
                        destination = this.streamNameMapper.map(record.destination());
                        key = record.key() != null ? this.getString(record.key()) : this.config.getNullKey();
                        value = record.value() != null ? this.getString(record.value()) : this.config.getNullValue();
                        recordMap = this.recordMapFunction.apply(key, value);
                        recordsMap.add(new AbstractMap.SimpleEntry<String, Map<String, String>>(destination, recordMap));
                    }
                    responses = this.client.xadd(recordsMap);
                    processedRecords = new ArrayList<ChangeEvent>();
                    index = 0;
                    totalOOMResponses = 0;
                    for (String message : responses) {
                        if (message.contains("OOM command not allowed when used memory > 'maxmemory'")) {
                            ++totalOOMResponses;
                        } else {
                            currentRecord = (ChangeEvent)clonedBatch.get(index);
                            committer.markProcessed((Object)currentRecord);
                            processedRecords.add(currentRecord);
                        }
                        ++index;
                    }
                    clonedBatch.removeAll(processedRecords);
                    if (totalOOMResponses > 0) {
                        RedisStreamChangeConsumer.LOGGER.warn("Redis runs OOM, {} command(s) failed", (Object)totalOOMResponses);
                    }
                    if (clonedBatch.size() != 0) ** GOTO lbl53
                    completedSuccessfully = true;
                }
                catch (RedisClientConnectionException jce) {
                    RedisStreamChangeConsumer.LOGGER.error("Connection error", (Throwable)jce);
                    this.close();
                }
                catch (Exception e) {
                    RedisStreamChangeConsumer.LOGGER.error("Unexpected Exception", (Throwable)e);
                    throw new DebeziumException((Throwable)e);
                }
            } else {
                RedisStreamChangeConsumer.LOGGER.warn("Stopped consuming records!");
            }
lbl53:
            // 5 sources

            delayStrategy.sleepWhen(completedSuccessfully == false);
        }
    }
}

