/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.regex.AbstractConstantKeysObject;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import com.oracle.truffle.regex.util.TruffleReadOnlyKeysArray;

public final class RegexFlags
extends AbstractConstantKeysObject
implements JsonConvertible {
    private static final TruffleReadOnlyKeysArray KEYS = new TruffleReadOnlyKeysArray("source", "ignoreCase", "multiline", "sticky", "global", "unicode", "dotAll");
    private static final int NONE = 0;
    private static final int IGNORE_CASE = 1;
    private static final int MULTILINE = 2;
    private static final int STICKY = 4;
    private static final int GLOBAL = 8;
    private static final int UNICODE = 16;
    private static final int DOT_ALL = 32;
    public static final RegexFlags DEFAULT = new RegexFlags("", false, false, false, false, false, false);
    private final String source;
    private final int value;

    private RegexFlags(String source, boolean ignoreCase, boolean multiline, boolean global, boolean sticky, boolean unicode, boolean dotAll) {
        this.source = source;
        this.value = (ignoreCase ? 1 : 0) | (multiline ? 2 : 0) | (sticky ? 4 : 0) | (global ? 8 : 0) | (unicode ? 16 : 0) | (dotAll ? 32 : 0);
    }

    @CompilerDirectives.TruffleBoundary
    public static RegexFlags parseFlags(String source) throws RegexSyntaxException {
        if (source.isEmpty()) {
            return DEFAULT;
        }
        boolean ignoreCase = false;
        boolean multiline = false;
        boolean global = false;
        boolean sticky = false;
        boolean unicode = false;
        boolean dotAll = false;
        for (int i = 0; i < source.length(); ++i) {
            boolean repeated;
            char ch = source.charAt(i);
            switch (ch) {
                case 'i': {
                    repeated = ignoreCase;
                    ignoreCase = true;
                    break;
                }
                case 'm': {
                    repeated = multiline;
                    multiline = true;
                    break;
                }
                case 'g': {
                    repeated = global;
                    global = true;
                    break;
                }
                case 'y': {
                    repeated = sticky;
                    sticky = true;
                    break;
                }
                case 'u': {
                    repeated = unicode;
                    unicode = true;
                    break;
                }
                case 's': {
                    repeated = dotAll;
                    dotAll = true;
                    break;
                }
                default: {
                    throw new RegexSyntaxException(source, "unsupported regex flag: " + ch);
                }
            }
            if (!repeated) continue;
            throw new RegexSyntaxException(source, "repeated regex flag: " + ch);
        }
        return new RegexFlags(source, ignoreCase, multiline, global, sticky, unicode, dotAll);
    }

    public String getSource() {
        return this.source;
    }

    public boolean isIgnoreCase() {
        return this.isSet(1);
    }

    public boolean isMultiline() {
        return this.isSet(2);
    }

    public boolean isSticky() {
        return this.isSet(4);
    }

    public boolean isGlobal() {
        return this.isSet(8);
    }

    public boolean isUnicode() {
        return this.isSet(16);
    }

    public boolean isDotAll() {
        return this.isSet(32);
    }

    public boolean isNone() {
        return this.value == 0;
    }

    private boolean isSet(int flag) {
        return (this.value & flag) != 0;
    }

    public String toString() {
        return this.source;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof RegexFlags && this.value == ((RegexFlags)obj).value;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.obj(Json.prop("ignoreCase", this.isIgnoreCase()), Json.prop("multiline", this.isMultiline()), Json.prop("global", this.isGlobal()), Json.prop("sticky", this.isSticky()), Json.prop("unicode", this.isUnicode()), Json.prop("dotAll", this.isDotAll()));
    }

    @Override
    public TruffleReadOnlyKeysArray getKeys() {
        return KEYS;
    }

    @Override
    public Object readMemberImpl(String symbol) throws UnknownIdentifierException {
        switch (symbol) {
            case "source": {
                return this.getSource();
            }
            case "ignoreCase": {
                return this.isIgnoreCase();
            }
            case "multiline": {
                return this.isMultiline();
            }
            case "sticky": {
                return this.isSticky();
            }
            case "global": {
                return this.isGlobal();
            }
            case "unicode": {
                return this.isUnicode();
            }
            case "dotAll": {
                return this.isDotAll();
            }
        }
        CompilerDirectives.transferToInterpreter();
        throw UnknownIdentifierException.create((String)symbol);
    }
}

