/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.dfa;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.regex.tregex.dfa.DFAGenerator;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFACaptureGroupTrackingData;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorNode;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonArray;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonObject;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import java.util.Arrays;

public final class DFACaptureGroupPartialTransition
implements JsonConvertible {
    public static final int FINAL_STATE_RESULT_INDEX = 0;
    public static final byte[] EMPTY_REORDER_SWAPS = new byte[0];
    public static final byte[] EMPTY_ARRAY_COPIES = new byte[0];
    public static final byte[][] EMPTY_INDEX_UPDATES = new byte[0][];
    public static final byte[][] EMPTY_INDEX_CLEARS = new byte[0][];
    private static final DFACaptureGroupPartialTransition EMPTY_INSTANCE = new DFACaptureGroupPartialTransition(0, EMPTY_REORDER_SWAPS, EMPTY_ARRAY_COPIES, EMPTY_INDEX_UPDATES, EMPTY_INDEX_CLEARS, 0);
    private final int id;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final byte[] reorderSwaps;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final byte[] arrayCopies;
    @CompilerDirectives.CompilationFinal(dimensions=2)
    private final byte[][] indexUpdates;
    @CompilerDirectives.CompilationFinal(dimensions=2)
    private final byte[][] indexClears;
    private final byte preReorderFinalStateResultIndex;

    private DFACaptureGroupPartialTransition(int id, byte[] reorderSwaps, byte[] arrayCopies, byte[][] indexUpdates, byte[][] indexClears, byte preReorderFinalStateResultIndex) {
        this.id = id;
        this.reorderSwaps = reorderSwaps;
        this.arrayCopies = arrayCopies;
        this.indexUpdates = indexUpdates;
        this.indexClears = indexClears;
        this.preReorderFinalStateResultIndex = preReorderFinalStateResultIndex;
    }

    public static DFACaptureGroupPartialTransition create(DFAGenerator dfaGen, byte[] reorderSwaps, byte[] arrayCopies, byte[][] indexUpdates, byte[][] indexClears, byte preReorderFinalStateResultIndex) {
        assert ((reorderSwaps.length & 1) == 0) : "reorderSwaps must have an even number of elements";
        if (reorderSwaps.length == 0 && arrayCopies.length == 0 && indexUpdates.length == 0 && indexClears.length == 0 && preReorderFinalStateResultIndex == 0) {
            return DFACaptureGroupPartialTransition.getEmptyInstance();
        }
        return new DFACaptureGroupPartialTransition(dfaGen.getCgPartialTransitionIDCounter().inc(), reorderSwaps, arrayCopies, indexUpdates, indexClears, preReorderFinalStateResultIndex);
    }

    public static DFACaptureGroupPartialTransition getEmptyInstance() {
        return EMPTY_INSTANCE;
    }

    public int getId() {
        return this.id;
    }

    public boolean doesReorderResults() {
        return this.reorderSwaps.length > 0;
    }

    public byte[] getArrayCopies() {
        return this.arrayCopies;
    }

    public void apply(TRegexDFAExecutorNode executor, DFACaptureGroupTrackingData d, int currentIndex) {
        if (executor.recordExecution()) {
            executor.getDebugRecorder().recordCGPartialTransition(currentIndex, this.id);
        }
        CompilerAsserts.partialEvaluationConstant((Object)this);
        this.applyReorder(d.currentResultOrder);
        this.applyArrayCopy(d.results, d.currentResultOrder, d.currentResult.length);
        this.applyIndexUpdate(d.results, d.currentResultOrder, currentIndex);
        this.applyIndexClear(d.results, d.currentResultOrder);
    }

    public void applyPreFinalStateTransition(TRegexDFAExecutorNode executor, DFACaptureGroupTrackingData d, boolean searching, int currentIndex) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        if (!searching) {
            this.apply(executor, d, currentIndex);
            return;
        }
        if (executor.recordExecution()) {
            executor.getDebugRecorder().recordCGPartialTransition(currentIndex, this.id);
        }
        d.exportResult(this.preReorderFinalStateResultIndex);
        this.applyFinalStateTransition(executor, d, true, currentIndex);
    }

    public void applyFinalStateTransition(TRegexDFAExecutorNode executor, DFACaptureGroupTrackingData d, boolean searching, int currentIndex) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        if (!searching) {
            this.apply(executor, d, currentIndex);
            return;
        }
        if (executor.recordExecution()) {
            executor.getDebugRecorder().recordCGPartialTransition(currentIndex, this.id);
        }
        assert (this.arrayCopies.length == 0);
        assert (this.indexUpdates.length <= 1);
        assert (this.indexClears.length <= 1);
        if (this.indexUpdates.length == 1) {
            assert (this.indexUpdates[0][0] == 0);
            this.applyFinalStateTransitionIndexUpdates(d, currentIndex);
        }
        if (this.indexClears.length == 1) {
            assert (this.indexClears[0][0] == 0);
            this.applyFinalStateTransitionIndexClears(d);
        }
    }

    @ExplodeLoop
    private void applyFinalStateTransitionIndexUpdates(DFACaptureGroupTrackingData d, int currentIndex) {
        for (int i = 1; i < this.indexUpdates[0].length; ++i) {
            int targetIndex = Byte.toUnsignedInt(this.indexUpdates[0][i]);
            d.currentResult[targetIndex] = currentIndex;
        }
    }

    @ExplodeLoop
    private void applyFinalStateTransitionIndexClears(DFACaptureGroupTrackingData d) {
        for (int i = 1; i < this.indexClears[0].length; ++i) {
            int targetIndex = Byte.toUnsignedInt(this.indexClears[0][i]);
            d.currentResult[targetIndex] = 0;
        }
    }

    @ExplodeLoop
    private void applyReorder(int[] currentResultOrder) {
        for (int i = 0; i < this.reorderSwaps.length; i += 2) {
            int source = Byte.toUnsignedInt(this.reorderSwaps[i]);
            int target = Byte.toUnsignedInt(this.reorderSwaps[i + 1]);
            int tmp = currentResultOrder[source];
            currentResultOrder[source] = currentResultOrder[target];
            currentResultOrder[target] = tmp;
        }
    }

    @ExplodeLoop
    private void applyArrayCopy(int[] results, int[] currentResultOrder, int length) {
        for (int i = 0; i < this.arrayCopies.length; i += 2) {
            int source = Byte.toUnsignedInt(this.arrayCopies[i]);
            int target = Byte.toUnsignedInt(this.arrayCopies[i + 1]);
            System.arraycopy(results, currentResultOrder[source], results, currentResultOrder[target], length);
        }
    }

    @ExplodeLoop
    private void applyIndexUpdate(int[] results, int[] currentResultOrder, int currentIndex) {
        for (byte[] indexUpdate : this.indexUpdates) {
            assert (indexUpdate.length > 1);
            int targetArray = Byte.toUnsignedInt(indexUpdate[0]);
            for (int i = 1; i < indexUpdate.length; ++i) {
                int targetIndex = Byte.toUnsignedInt(indexUpdate[i]);
                results[currentResultOrder[targetArray] + targetIndex] = currentIndex;
            }
        }
    }

    @ExplodeLoop
    private void applyIndexClear(int[] results, int[] currentResultOrder) {
        for (byte[] indexClear : this.indexClears) {
            assert (indexClear.length > 1);
            int targetArray = Byte.toUnsignedInt(indexClear[0]);
            for (int i = 1; i < indexClear.length; ++i) {
                int targetIndex = Byte.toUnsignedInt(indexClear[i]);
                results[currentResultOrder[targetArray] + targetIndex] = 0;
            }
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DFACaptureGroupPartialTransition)) {
            return false;
        }
        DFACaptureGroupPartialTransition o = (DFACaptureGroupPartialTransition)obj;
        return Arrays.equals(this.reorderSwaps, o.reorderSwaps) && Arrays.equals(this.arrayCopies, o.arrayCopies) && Arrays.deepEquals((Object[])this.indexUpdates, (Object[])o.indexUpdates) && Arrays.deepEquals((Object[])this.indexClears, (Object[])o.indexClears);
    }

    public int hashCode() {
        int prime = 31;
        int result = Arrays.hashCode(this.reorderSwaps);
        result = 31 * result + Arrays.hashCode(this.arrayCopies);
        result = 31 * result + Arrays.deepHashCode((Object[])this.indexUpdates);
        result = 31 * result + Arrays.deepHashCode((Object[])this.indexClears);
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        StringBuilder sb = new StringBuilder("DfaCGTransition");
        if (this.reorderSwaps.length > 0) {
            sb.append(System.lineSeparator()).append("reorderSwaps: ").append(Arrays.toString(this.reorderSwaps));
        }
        if (this.arrayCopies.length > 0) {
            sb.append(System.lineSeparator()).append("arrayCopies: ");
            for (int i = 0; i < this.arrayCopies.length; i += 2) {
                int source = Byte.toUnsignedInt(this.arrayCopies[i]);
                int target = Byte.toUnsignedInt(this.arrayCopies[i + 1]);
                sb.append(System.lineSeparator()).append("    ").append(source).append(" -> ").append(target);
            }
        }
        DFACaptureGroupPartialTransition.indexManipulationsToString(sb, this.indexUpdates, "indexUpdates");
        DFACaptureGroupPartialTransition.indexManipulationsToString(sb, this.indexClears, "indexClears");
        return sb.toString();
    }

    @CompilerDirectives.TruffleBoundary
    private static void indexManipulationsToString(StringBuilder sb, byte[][] indexManipulations, String name) {
        if (indexManipulations.length > 0) {
            sb.append(System.lineSeparator()).append(name).append(": ");
            for (byte[] indexManipulation : indexManipulations) {
                int targetArray = Byte.toUnsignedInt(indexManipulation[0]);
                sb.append(System.lineSeparator()).append("    ").append(targetArray).append(" <- [");
                for (int i = 1; i < indexManipulation.length; ++i) {
                    if (i > 1) {
                        sb.append(", ");
                    }
                    sb.append(Byte.toUnsignedInt(indexManipulation[i]));
                }
                sb.append("]");
            }
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        JsonObject json = Json.obj(Json.prop("id", this.id), Json.prop("reorderSwaps", Json.arrayUnsigned(this.reorderSwaps)));
        JsonArray copies = Json.array(new JsonConvertible[0]);
        for (int i = 0; i < this.arrayCopies.length; i += 2) {
            int source = Byte.toUnsignedInt(this.arrayCopies[i]);
            int target = Byte.toUnsignedInt(this.arrayCopies[i + 1]);
            copies.append(Json.obj(Json.prop("source", source), Json.prop("target", target)));
        }
        json.append(Json.prop("arrayCopies", copies));
        for (byte[] indexUpdate : this.indexUpdates) {
            json.append(DFACaptureGroupPartialTransition.indexManipulationToProp("indexUpdates", indexUpdate, true));
        }
        for (byte[] indexClear : this.indexClears) {
            json.append(DFACaptureGroupPartialTransition.indexManipulationToProp("indexClears", indexClear, true));
        }
        return json;
    }

    @CompilerDirectives.TruffleBoundary
    static JsonObject.JsonObjectProperty indexManipulationToProp(String name, byte[] values, boolean hasTarget) {
        return Json.prop(name, Json.obj(Json.prop("target", hasTarget ? Byte.toUnsignedInt(values[0]) : 0), Json.prop("groupStarts", DFACaptureGroupPartialTransition.groupEntriesToJsonArray(values, hasTarget)), Json.prop("groupEnds", DFACaptureGroupPartialTransition.groupExitsToJsonArray(values, hasTarget))));
    }

    @CompilerDirectives.TruffleBoundary
    private static JsonArray groupEntriesToJsonArray(byte[] gbArray, boolean hasTarget) {
        return DFACaptureGroupPartialTransition.groupBoundariesToJsonArray(gbArray, true, hasTarget);
    }

    @CompilerDirectives.TruffleBoundary
    private static JsonArray groupExitsToJsonArray(byte[] gbArray, boolean hasTarget) {
        return DFACaptureGroupPartialTransition.groupBoundariesToJsonArray(gbArray, false, hasTarget);
    }

    @CompilerDirectives.TruffleBoundary
    private static JsonArray groupBoundariesToJsonArray(byte[] gbArray, boolean entries, boolean hasTarget) {
        int i;
        JsonArray array = Json.array(new JsonConvertible[0]);
        int n = i = hasTarget ? 1 : 0;
        while (i < gbArray.length) {
            int intValue = Byte.toUnsignedInt(gbArray[i]);
            if ((intValue & 1) == (entries ? 0 : 1)) {
                array.append(Json.val(intValue / 2));
            }
            ++i;
        }
        return array;
    }
}

