/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.amqp.implementation.ConnectionOptions;
import com.azure.core.amqp.implementation.ReactorProvider;
import com.azure.core.amqp.implementation.handler.ConnectionHandler;
import com.azure.core.amqp.implementation.handler.ReceiveLinkHandler;
import com.azure.core.amqp.implementation.handler.SendLinkHandler;
import com.azure.core.amqp.implementation.handler.SessionHandler;
import com.azure.core.amqp.implementation.handler.WebSocketsConnectionHandler;
import com.azure.core.amqp.implementation.handler.WebSocketsProxyConnectionHandler;
import com.azure.core.util.logging.ClientLogger;
import java.time.Duration;
import java.util.Locale;
import java.util.Objects;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.engine.SslPeerDetails;

public class ReactorHandlerProvider {
    private static final ClientLogger LOGGER = new ClientLogger(ReactorHandlerProvider.class);
    private final ReactorProvider provider;

    public ReactorHandlerProvider(ReactorProvider provider) {
        this.provider = Objects.requireNonNull(provider, "'provider' cannot be null.");
    }

    public ConnectionHandler createConnectionHandler(String connectionId, ConnectionOptions options) {
        Objects.requireNonNull(connectionId, "'connectionId' cannot be null.");
        Objects.requireNonNull(options, "'options' cannot be null.");
        if (options.getTransportType() == AmqpTransportType.AMQP) {
            SslPeerDetails peerDetails = Proton.sslPeerDetails((String)options.getHostname(), (int)options.getPort());
            return new ConnectionHandler(connectionId, options, peerDetails);
        }
        if (options.getTransportType() != AmqpTransportType.AMQP_WEB_SOCKETS) {
            throw LOGGER.logExceptionAsWarning((RuntimeException)new IllegalArgumentException(String.format(Locale.US, "This transport type '%s' is not supported.", new Object[]{options.getTransportType()})));
        }
        boolean isCustomEndpointConfigured = !options.getFullyQualifiedNamespace().equals(options.getHostname());
        boolean isUserProxyConfigured = options.getProxyOptions() != null && options.getProxyOptions().isProxyAddressConfigured();
        boolean isSystemProxyConfigured = WebSocketsProxyConnectionHandler.shouldUseProxy(options.getFullyQualifiedNamespace(), options.getPort());
        if (isCustomEndpointConfigured && (isUserProxyConfigured || isSystemProxyConfigured)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Unable to proxy connection to custom endpoint. Custom endpoint: %s. Proxy settings: %s. Namespace: %s", options.getHostname(), options.getProxyOptions().getProxyAddress(), options.getFullyQualifiedNamespace())));
        }
        if (isUserProxyConfigured) {
            LOGGER.info("Using user configured proxy to connect to: '{}:{}'. Proxy: {}", new Object[]{options.getFullyQualifiedNamespace(), options.getPort(), options.getProxyOptions().getProxyAddress()});
            SslPeerDetails peerDetails = Proton.sslPeerDetails((String)options.getHostname(), (int)options.getPort());
            return new WebSocketsProxyConnectionHandler(connectionId, options, options.getProxyOptions(), peerDetails);
        }
        if (isSystemProxyConfigured) {
            LOGGER.info("System default proxy configured for hostname:port '{}:{}'. Using proxy.", new Object[]{options.getFullyQualifiedNamespace(), options.getPort()});
            SslPeerDetails peerDetails = Proton.sslPeerDetails((String)options.getHostname(), (int)options.getPort());
            return new WebSocketsProxyConnectionHandler(connectionId, options, ProxyOptions.SYSTEM_DEFAULTS, peerDetails);
        }
        SslPeerDetails peerDetails = isCustomEndpointConfigured ? Proton.sslPeerDetails((String)options.getHostname(), (int)options.getPort()) : Proton.sslPeerDetails((String)options.getFullyQualifiedNamespace(), (int)options.getPort());
        return new WebSocketsConnectionHandler(connectionId, options, peerDetails);
    }

    public SessionHandler createSessionHandler(String connectionId, String hostname, String sessionName, Duration openTimeout) {
        return new SessionHandler(connectionId, hostname, sessionName, this.provider.getReactorDispatcher(), openTimeout);
    }

    public SendLinkHandler createSendLinkHandler(String connectionId, String hostname, String senderName, String entityPath) {
        return new SendLinkHandler(connectionId, hostname, senderName, entityPath);
    }

    public ReceiveLinkHandler createReceiveLinkHandler(String connectionId, String hostname, String receiverName, String entityPath) {
        return new ReceiveLinkHandler(connectionId, hostname, receiverName, entityPath);
    }
}

