/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation.handler;

import com.azure.core.amqp.implementation.ConnectionOptions;
import com.azure.core.amqp.implementation.handler.ConnectionHandler;
import com.microsoft.azure.proton.transport.ws.impl.WebSocketImpl;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.SslPeerDetails;
import org.apache.qpid.proton.engine.impl.TransportInternal;
import org.apache.qpid.proton.engine.impl.TransportLayer;

public class WebSocketsConnectionHandler
extends ConnectionHandler {
    public static final int HTTPS_PORT = 443;
    static final int MAX_FRAME_SIZE = 4096;
    private static final String SOCKET_PATH = "/$servicebus/websocket";
    private static final String PROTOCOL = "AMQPWSB10";

    public WebSocketsConnectionHandler(String connectionId, ConnectionOptions connectionOptions, SslPeerDetails peerDetails) {
        super(connectionId, connectionOptions, peerDetails);
    }

    @Override
    protected void addTransportLayers(Event event, TransportInternal transport) {
        String hostName = event.getConnection().getHostname();
        this.logger.info("Adding web socket layer");
        WebSocketImpl webSocket = new WebSocketImpl();
        webSocket.configure(hostName, SOCKET_PATH, "", 0, PROTOCOL, null, null);
        transport.addTransportLayer((TransportLayer)webSocket);
        this.logger.atVerbose().addKeyValue("hostName", hostName).log("Adding web sockets transport layer.");
        super.addTransportLayers(event, transport);
    }

    @Override
    public int getMaxFrameSize() {
        return 4096;
    }
}

