/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.AbstractSourceInfoStructMaker;
import io.debezium.connector.oracle.CommitScn;
import io.debezium.connector.oracle.SourceInfo;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class OracleSourceInfoStructMaker
extends AbstractSourceInfoStructMaker<SourceInfo> {
    private final Schema schema = CommitScn.schemaBuilder(this.commonSchemaBuilder().name("io.debezium.connector.oracle.Source").field("schema", Schema.STRING_SCHEMA).field("table", Schema.STRING_SCHEMA).field("txId", Schema.OPTIONAL_STRING_SCHEMA).field("scn", Schema.OPTIONAL_STRING_SCHEMA).field("commit_scn", Schema.OPTIONAL_STRING_SCHEMA).field("lcr_position", Schema.OPTIONAL_STRING_SCHEMA).field("rs_id", Schema.OPTIONAL_STRING_SCHEMA).field("ssn", Schema.OPTIONAL_INT32_SCHEMA)).field("user_name", Schema.OPTIONAL_STRING_SCHEMA).build();

    public OracleSourceInfoStructMaker(String connector, String version, CommonConnectorConfig connectorConfig) {
        super(connector, version, connectorConfig);
    }

    public Schema schema() {
        return this.schema;
    }

    public Struct struct(SourceInfo sourceInfo) {
        String eventScn = sourceInfo.getEventScn() == null ? null : sourceInfo.getEventScn().toString();
        Struct ret = super.commonStruct((AbstractSourceInfo)sourceInfo).put("schema", (Object)sourceInfo.tableSchema()).put("table", (Object)sourceInfo.table()).put("txId", (Object)sourceInfo.getTransactionId()).put("scn", (Object)eventScn);
        if (sourceInfo.getLcrPosition() != null) {
            ret.put("lcr_position", (Object)sourceInfo.getLcrPosition());
        }
        if (sourceInfo.getUserName() != null) {
            ret.put("user_name", (Object)sourceInfo.getUserName());
        }
        if (sourceInfo.getRsId() != null) {
            ret.put("rs_id", (Object)sourceInfo.getRsId());
        }
        ret.put("ssn", (Object)sourceInfo.getSsn());
        CommitScn commitScn = sourceInfo.getCommitScn();
        if (commitScn != null) {
            commitScn.store(sourceInfo, ret);
        }
        return ret;
    }
}

