/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.http;

import io.debezium.DebeziumException;
import io.debezium.engine.ChangeEvent;
import io.debezium.engine.DebeziumEngine;
import io.debezium.server.BaseChangeConsumer;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Named;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="http")
@Dependent
public class HttpChangeConsumer
extends BaseChangeConsumer
implements DebeziumEngine.ChangeConsumer<ChangeEvent<Object, Object>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpChangeConsumer.class);
    private static final String PROP_PREFIX = "debezium.sink.http.";
    private static final String PROP_WEBHOOK_URL = "url";
    private static final String PROP_CLIENT_TIMEOUT = "timeout.ms";
    private static final String PROP_RETRIES = "retries";
    private static final String PROP_RETRY_INTERVAL = "retry.interval.ms";
    private static final Long HTTP_TIMEOUT = Integer.toUnsignedLong(60000);
    private static final int DEFAULT_RETRIES = 5;
    private static final Long RETRY_INTERVAL = Integer.toUnsignedLong(1000);
    private static Duration timeoutDuration;
    private static int retries;
    private static Duration retryInterval;
    private HttpClient client;
    private HttpRequest.Builder requestBuilder;

    @PostConstruct
    void connect() throws URISyntaxException {
        String contentType;
        this.client = HttpClient.newHttpClient();
        Config config = ConfigProvider.getConfig();
        String sink = System.getenv("K_SINK");
        timeoutDuration = Duration.ofMillis(HTTP_TIMEOUT);
        retries = 5;
        retryInterval = Duration.ofMillis(RETRY_INTERVAL);
        String sinkUrl = sink != null ? sink : (String)config.getValue("debezium.sink.http.url", String.class);
        config.getOptionalValue("debezium.sink.http.timeout.ms", String.class).ifPresent(t -> {
            timeoutDuration = Duration.ofMillis(Long.parseLong(t));
        });
        config.getOptionalValue("debezium.sink.http.retries", String.class).ifPresent(n -> {
            retries = Integer.parseInt(n);
        });
        config.getOptionalValue("debezium.sink.http.retry.interval.ms", String.class).ifPresent(t -> {
            retryInterval = Duration.ofMillis(Long.parseLong(t));
        });
        switch ((String)config.getValue("debezium.format.value", String.class)) {
            case "avro": {
                contentType = "avro/bytes";
                break;
            }
            case "cloudevents": {
                contentType = "application/cloudevents+json";
                break;
            }
            default: {
                contentType = "application/json";
            }
        }
        LOGGER.info("Using http content-type type {}", (Object)contentType);
        LOGGER.info("Using sink URL: {}", (Object)sinkUrl);
        this.requestBuilder = HttpRequest.newBuilder(new URI(sinkUrl)).timeout(timeoutDuration);
        this.requestBuilder.setHeader("content-type", contentType);
    }

    public void handleBatch(List<ChangeEvent<Object, Object>> records, DebeziumEngine.RecordCommitter<ChangeEvent<Object, Object>> committer) throws InterruptedException {
        for (ChangeEvent<Object, Object> record : records) {
            LOGGER.trace("Received event '{}'", record);
            if (record.value() == null) continue;
            int attempts = 0;
            while (!this.recordSent(record)) {
                if (++attempts >= retries) {
                    throw new DebeziumException("Exceeded maximum number of attempts to publish event " + record);
                }
                Metronome.sleeper((Duration)retryInterval, (Clock)Clock.SYSTEM).pause();
            }
            committer.markProcessed(record);
        }
        committer.markBatchFinished();
    }

    private boolean recordSent(ChangeEvent<Object, Object> record) throws InterruptedException {
        HttpResponse<String> r;
        boolean sent = false;
        String value = (String)record.value();
        HttpRequest request = this.requestBuilder.POST(HttpRequest.BodyPublishers.ofString(value)).build();
        try {
            r = this.client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException ioe) {
            throw new InterruptedException(ioe.toString());
        }
        if (r.statusCode() == 200 || r.statusCode() == 204 || r.statusCode() == 202) {
            sent = true;
        } else {
            LOGGER.info("Failed to publish event: " + r.body());
        }
        return sent;
    }
}

