/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.InitializeInstanceFieldsNode;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=InitializeInstanceFieldsNode.class)
public final class InitializeInstanceFieldsNodeGen
extends InitializeInstanceFieldsNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @Node.Child
    private ObjectData object_cache;

    private InitializeInstanceFieldsNodeGen(JSContext context, JavaScriptNode targetNode, JavaScriptNode sourceNode) {
        super(context, targetNode, sourceNode);
    }

    @Override
    public Object executeEvaluated(Object targetNodeValue, Object[][] sourceNodeValue) {
        int state = this.state_;
        if (state != 0) {
            ObjectData s1_;
            if ((state & 1) != 0 && (s1_ = this.object_cache) != null) {
                return InitializeInstanceFieldsNode.doObject(targetNodeValue, sourceNodeValue, s1_.fieldNodes_);
            }
            if ((state & 2) != 0 && InitializeInstanceFieldsNodeGen.fallbackGuard_(state, targetNodeValue, sourceNodeValue)) {
                return InitializeInstanceFieldsNode.doOther(targetNodeValue, sourceNodeValue);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(targetNodeValue, sourceNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        Object targetNodeValue_ = this.targetNode.execute(frameValue);
        Object sourceNodeValue_ = this.sourceNode.execute(frameValue);
        if (state != 0) {
            if ((state & 1) != 0 && sourceNodeValue_ instanceof Object[][]) {
                Object[][] sourceNodeValue__ = (Object[][])sourceNodeValue_;
                ObjectData s1_ = this.object_cache;
                if (s1_ != null) {
                    return InitializeInstanceFieldsNode.doObject(targetNodeValue_, sourceNodeValue__, s1_.fieldNodes_);
                }
            }
            if ((state & 2) != 0 && InitializeInstanceFieldsNodeGen.fallbackGuard_(state, targetNodeValue_, sourceNodeValue_)) {
                return InitializeInstanceFieldsNode.doOther(targetNodeValue_, sourceNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(targetNodeValue_, sourceNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object targetNodeValue, Object sourceNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (sourceNodeValue instanceof Object[][]) {
                Object[][] sourceNodeValue_ = (Object[][])sourceNodeValue;
                ObjectData s1_ = (ObjectData)super.insert((Node)new ObjectData());
                s1_.fieldNodes_ = (InitializeInstanceFieldsNode.DefineFieldNode[])s1_.insertAccessor(InitializeInstanceFieldsNode.createFieldNodes((Object[])sourceNodeValue_, this.context));
                this.object_cache = s1_;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                Object object = InitializeInstanceFieldsNode.doObject(targetNodeValue, sourceNodeValue_, s1_.fieldNodes_);
                return object;
            }
            this.state_ = state |= 2;
            lock.unlock();
            hasLock = false;
            Object object = InitializeInstanceFieldsNode.doOther(targetNodeValue, sourceNodeValue);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[3];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doObject";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            ArrayList<List<InitializeInstanceFieldsNode.DefineFieldNode>> cached = new ArrayList<List<InitializeInstanceFieldsNode.DefineFieldNode>>();
            ObjectData s1_ = this.object_cache;
            if (s1_ != null) {
                cached.add(Arrays.asList(s1_.fieldNodes_));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doOther";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        return Introspection.Provider.create((Object[])data);
    }

    private static boolean fallbackGuard_(int state, Object targetNodeValue, Object sourceNodeValue) {
        return (state & 1) != 0 || !(sourceNodeValue instanceof Object[][]);
    }

    public static InitializeInstanceFieldsNode create(JSContext context, JavaScriptNode targetNode, JavaScriptNode sourceNode) {
        return new InitializeInstanceFieldsNodeGen(context, targetNode, sourceNode);
    }

    @GeneratedBy(value=InitializeInstanceFieldsNode.class)
    private static final class ObjectData
    extends Node {
        @Node.Children
        InitializeInstanceFieldsNode.DefineFieldNode[] fieldNodes_;

        ObjectData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T[] insertAccessor(T[] node) {
            return super.insert(node);
        }
    }
}

