/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSToLengthNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.runtime.JSRuntime;

public abstract class JSToLengthNode
extends JavaScriptBaseNode {
    protected final BranchProfile needNegativeBranch = BranchProfile.create();

    public static JSToLengthNode create() {
        return JSToLengthNodeGen.create();
    }

    public abstract long executeLong(Object var1);

    @Specialization
    protected long doInt(int value) {
        if (value < 0) {
            this.needNegativeBranch.enter();
            return 0L;
        }
        return value;
    }

    @Specialization
    protected long doDouble(double value, @Cached(value="create()") BranchProfile needPositiveInfinityBranch, @Cached(value="create()") BranchProfile needNaNBranch, @Cached(value="create()") BranchProfile needSafeBranch) {
        if (Double.isNaN(value)) {
            needNaNBranch.enter();
            return 0L;
        }
        if (JSRuntime.isPositiveInfinity(value)) {
            needPositiveInfinityBranch.enter();
            return JSRuntime.MAX_SAFE_INTEGER_LONG;
        }
        return this.doLong((long)value, needSafeBranch);
    }

    @Specialization(guards={"isUndefined(value)"})
    protected long doUndefined(DynamicObject value) {
        return 0L;
    }

    @Specialization
    protected long doObject(Object value, @Cached(value="create()") JSToNumberNode toNumberNode, @Cached(value="create()") BranchProfile needSafeBranch) {
        Number result = (Number)toNumberNode.execute(value);
        return this.doLong(JSRuntime.toInteger(result), needSafeBranch);
    }

    private long doLong(long value, BranchProfile needSafeBranch) {
        if (value < 0L) {
            this.needNegativeBranch.enter();
            return 0L;
        }
        if (value > JSRuntime.MAX_SAFE_INTEGER_LONG) {
            needSafeBranch.enter();
            return JSRuntime.MAX_SAFE_INTEGER_LONG;
        }
        return value;
    }
}

